/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.dexpler.DalvikThrowAnalysis;
import soot.dexpler.typing.UntypedConstant;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.LocalDefs;

public class DexFillArrayDataTransformer
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(DexFillArrayDataTransformer.class);
    private static final int MAX_RECURSION_DEPTH = 5;

    public static DexFillArrayDataTransformer v() {
        return new DexFillArrayDataTransformer();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        ExceptionalUnitGraph g2 = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body, DalvikThrowAnalysis.v());
        LocalDefs defs = G.v().soot_toolkits_scalar_LocalDefsFactory().newLocalDefs(g2);
        Iterator unitIt = body.getUnits().snapshotIterator();
        while (unitIt.hasNext()) {
            Value left;
            AssignStmt ass;
            Value rightOp;
            Unit u = (Unit)unitIt.next();
            if (!(u instanceof AssignStmt) || !((rightOp = (ass = (AssignStmt)u).getRightOp()) instanceof UntypedConstant) || !((left = ass.getLeftOp()) instanceof ArrayRef)) continue;
            ArrayRef leftArray = (ArrayRef)left;
            Local l = (Local)leftArray.getBase();
            List<Type> arrayTypes = new LinkedList<Type>();
            this.checkArrayDefinitions(l, ass, defs, arrayTypes, 5);
            if (arrayTypes.isEmpty()) {
                throw new InternalError("Failed to determine the array type ");
            }
            if (arrayTypes.size() > 1 && (arrayTypes = arrayTypes.stream().distinct().collect(Collectors.toList())).size() > 1) {
                logger.warn("Found multiple possible array types, using first ignoreing the others: {}", (Object)arrayTypes);
            }
            Type elementType = (Type)arrayTypes.get(0);
            Value constant = ass.getRightOp();
            UntypedConstant untyped = (UntypedConstant)constant;
            ass.setRightOp(untyped.defineType(elementType));
        }
    }

    private void checkArrayDefinitions(Local l, Unit u, LocalDefs defs, List<Type> arrayTypes, int maxDepth) {
        if (maxDepth <= 0) {
            logger.warn("Recursion depth limit reached - aborting");
            return;
        }
        List<Unit> assDefs = defs.getDefsOfAt(l, u);
        for (Unit d : assDefs) {
            if (!(d instanceof AssignStmt)) continue;
            AssignStmt arrayAssign = (AssignStmt)d;
            Value source = arrayAssign.getRightOp();
            if (source instanceof NewArrayExpr) {
                NewArrayExpr newArray = (NewArrayExpr)source;
                arrayTypes.add(newArray.getBaseType());
                continue;
            }
            if (source instanceof InvokeExpr) {
                InvokeExpr invExpr = (InvokeExpr)source;
                Type aType = invExpr.getMethodRef().getReturnType();
                if (!(aType instanceof ArrayType)) {
                    throw new InternalError("Failed to identify the array type. The identified method invocation does not return an array type. Invocation: " + invExpr.getMethodRef());
                }
                arrayTypes.add(((ArrayType)aType).getArrayElementType());
                continue;
            }
            if (source instanceof Local) {
                Local newLocal = (Local)source;
                this.checkArrayDefinitions(newLocal, d, defs, arrayTypes, maxDepth - 1);
                continue;
            }
            throw new InternalError("Unsupported array definition statement: " + d);
        }
    }
}

