/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Value;
import soot.dava.internal.AST.ASTAggregatedCondition;
import soot.dava.internal.AST.ASTBinaryCondition;
import soot.dava.internal.AST.ASTCondition;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTUnaryCondition;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.internal.asg.AugmentedStmt;
import soot.jimple.ConditionExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;

public class ForLoopCreationHelper {
    ASTStatementSequenceNode stmtSeqNode;
    ASTWhileNode whileNode;
    ASTStatementSequenceNode newStmtSeqNode;
    ASTForLoopNode forNode;
    Map<String, Integer> varToStmtMap;
    List<AugmentedStmt> myStmts;
    boolean removeLast = false;

    public ForLoopCreationHelper(ASTStatementSequenceNode stmtSeqNode, ASTWhileNode whileNode) {
        this.stmtSeqNode = stmtSeqNode;
        this.whileNode = whileNode;
        this.varToStmtMap = new HashMap<String, Integer>();
    }

    public List<Object> createNewBody(List<Object> oldSubBody, int nodeNumber) {
        ArrayList<Object> newSubBody = new ArrayList<Object>();
        if (oldSubBody.size() <= nodeNumber) {
            return null;
        }
        Iterator<Object> oldIt = oldSubBody.iterator();
        for (int index = 0; index != nodeNumber; ++index) {
            newSubBody.add(oldIt.next());
        }
        ASTNode temp = (ASTNode)oldIt.next();
        if (!(temp instanceof ASTStatementSequenceNode)) {
            return null;
        }
        temp = (ASTNode)oldIt.next();
        if (!(temp instanceof ASTWhileNode)) {
            return null;
        }
        if (this.newStmtSeqNode != null) {
            newSubBody.add(this.newStmtSeqNode);
        }
        newSubBody.add(this.forNode);
        while (oldIt.hasNext()) {
            newSubBody.add(oldIt.next());
        }
        return newSubBody;
    }

    private List<String> getDefs() {
        if (this.stmtSeqNode == null) {
            return null;
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        int stmtNum = 0;
        for (AugmentedStmt as : this.stmtSeqNode.getStatements()) {
            Stmt s2 = as.get_Stmt();
            if (s2 instanceof DefinitionStmt) {
                Value left = ((DefinitionStmt)s2).getLeftOp();
                toReturn.add(left.toString());
                this.varToStmtMap.put(left.toString(), new Integer(stmtNum));
            } else {
                toReturn = new ArrayList();
                this.varToStmtMap = new HashMap<String, Integer>();
            }
            ++stmtNum;
        }
        return toReturn;
    }

    private List<String> getCondUses() {
        if (this.whileNode == null) {
            return null;
        }
        ASTCondition cond = this.whileNode.get_Condition();
        return this.getCond(cond);
    }

    private List<String> getCond(ASTCondition cond) {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (cond instanceof ASTUnaryCondition) {
            toReturn.add(((ASTUnaryCondition)cond).toString());
        } else if (cond instanceof ASTBinaryCondition) {
            ConditionExpr condExpr = ((ASTBinaryCondition)cond).getConditionExpr();
            toReturn.add(condExpr.getOp1().toString());
            toReturn.add(condExpr.getOp2().toString());
        } else if (cond instanceof ASTAggregatedCondition) {
            toReturn.addAll(this.getCond(((ASTAggregatedCondition)cond).getLeftOp()));
            toReturn.addAll(this.getCond(((ASTAggregatedCondition)cond).getRightOp()));
        }
        return toReturn;
    }

    private List<String> getCommonVars(List<String> defs, List<String> condUses) {
        ArrayList<String> toReturn = new ArrayList<String>();
        block0: for (String defString : defs) {
            for (String condString : condUses) {
                if (condString.compareTo(defString) != 0) continue;
                toReturn.add(defString);
                continue block0;
            }
        }
        return toReturn;
    }

    public boolean checkPattern() {
        List<String> defs = this.getDefs();
        if (defs == null || defs.size() == 0) {
            return false;
        }
        List<String> condUses = this.getCondUses();
        if (condUses == null || condUses.size() == 0) {
            return false;
        }
        List<String> commonVars = this.getCommonVars(defs, condUses);
        List<AugmentedStmt> update = this.getUpdate(defs, condUses, commonVars);
        if (update == null || update.size() == 0) {
            return false;
        }
        if (commonVars == null || commonVars.size() == 0) {
            return false;
        }
        List<AugmentedStmt> init = this.createNewStmtSeqNodeAndGetInit(commonVars);
        if (init.size() == 0) {
            return false;
        }
        ASTCondition condition = this.whileNode.get_Condition();
        List body = (List)this.whileNode.get_SubBodies().get(0);
        SETNodeLabel label = this.whileNode.get_Label();
        if (this.removeLast) {
            this.myStmts.remove(this.myStmts.size() - 1);
            this.removeLast = false;
        }
        this.forNode = new ASTForLoopNode(label, init, condition, update, body);
        return true;
    }

    private List<AugmentedStmt> getUpdate(List<String> defs, List<String> condUses, List<String> commonUses) {
        ArrayList<AugmentedStmt> toReturn = new ArrayList<AugmentedStmt>();
        List<Object> subBodies = this.whileNode.get_SubBodies();
        if (subBodies.size() != 1) {
            return toReturn;
        }
        List subBody = (List)subBodies.get(0);
        Iterator it = subBody.iterator();
        while (it.hasNext()) {
            ASTNode temp = (ASTNode)it.next();
            if (it.hasNext()) continue;
            if (!(temp instanceof ASTStatementSequenceNode)) {
                return null;
            }
            List<AugmentedStmt> stmts = ((ASTStatementSequenceNode)temp).getStatements();
            AugmentedStmt last = stmts.get(stmts.size() - 1);
            Stmt lastStmt = last.get_Stmt();
            if (!(lastStmt instanceof DefinitionStmt)) {
                return null;
            }
            Value left = ((DefinitionStmt)lastStmt).getLeftOp();
            for (String defString : defs) {
                if (left.toString().compareTo(defString) != 0) continue;
                toReturn.add(last);
                this.myStmts = stmts;
                this.removeLast = true;
                Iterator<String> coIt = commonUses.iterator();
                boolean matched = false;
                while (coIt.hasNext()) {
                    if (defString.compareTo(coIt.next()) != 0) continue;
                    matched = true;
                }
                if (!matched) {
                    commonUses.add(defString);
                }
                return toReturn;
            }
            for (String condString : condUses) {
                if (left.toString().compareTo(condString) != 0) continue;
                toReturn.add(last);
                this.myStmts = stmts;
                this.removeLast = true;
                Iterator<String> coIt = commonUses.iterator();
                boolean matched = false;
                while (coIt.hasNext()) {
                    if (condString.compareTo(coIt.next()) != 0) continue;
                    matched = true;
                }
                if (!matched) {
                    commonUses.add(condString);
                }
                return toReturn;
            }
        }
        return toReturn;
    }

    private List<AugmentedStmt> createNewStmtSeqNodeAndGetInit(List<String> commonVars) {
        int currentLowestPosition = 999;
        for (String temp : commonVars) {
            Integer tempInt = this.varToStmtMap.get(temp);
            if (tempInt == null || tempInt >= currentLowestPosition) continue;
            currentLowestPosition = tempInt;
        }
        ArrayList<AugmentedStmt> stmts = new ArrayList<AugmentedStmt>();
        List<AugmentedStmt> statements = this.stmtSeqNode.getStatements();
        Iterator<AugmentedStmt> stmtIt = statements.iterator();
        for (int stmtNum = 0; stmtNum < currentLowestPosition && stmtIt.hasNext(); ++stmtNum) {
            stmts.add(stmtIt.next());
        }
        this.newStmtSeqNode = stmts.size() > 0 ? new ASTStatementSequenceNode(stmts) : null;
        ArrayList<AugmentedStmt> init = new ArrayList<AugmentedStmt>();
        while (stmtIt.hasNext()) {
            init.add(stmtIt.next());
        }
        return init;
    }
}

