/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.structuredAnalysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.internal.javaRep.DAbruptStmt;
import soot.dava.toolkits.base.AST.traversals.ClosestAbruptTargetFinder;
import soot.toolkits.scalar.AbstractFlowSet;
import soot.toolkits.scalar.FlowSet;

public class DavaFlowSet<T>
extends AbstractFlowSet<T> {
    static final int DEFAULT_SIZE = 8;
    int numElements;
    int maxElements;
    protected T[] elements;
    HashMap<Serializable, List<DavaFlowSet<T>>> breakList;
    HashMap<Serializable, List<DavaFlowSet<T>>> continueList;
    HashMap<Serializable, List<DavaFlowSet<T>>> implicitBreaks;
    HashMap<Serializable, List<DavaFlowSet<T>>> implicitContinues;

    public DavaFlowSet() {
        this.maxElements = 8;
        this.elements = new Object[8];
        this.numElements = 0;
        this.breakList = new HashMap();
        this.continueList = new HashMap();
        this.implicitBreaks = new HashMap();
        this.implicitContinues = new HashMap();
    }

    public DavaFlowSet(DavaFlowSet<T> other) {
        this.numElements = other.numElements;
        this.maxElements = other.maxElements;
        this.elements = (Object[])other.elements.clone();
        this.breakList = (HashMap)other.breakList.clone();
        this.continueList = (HashMap)other.continueList.clone();
        this.implicitBreaks = (HashMap)other.implicitBreaks.clone();
        this.implicitContinues = (HashMap)other.implicitContinues.clone();
    }

    private boolean sameType(Object flowSet) {
        return flowSet instanceof DavaFlowSet;
    }

    @Override
    public DavaFlowSet<T> clone() {
        return new DavaFlowSet<T>(this);
    }

    @Override
    public FlowSet<T> emptySet() {
        return new DavaFlowSet<T>();
    }

    @Override
    public void clear() {
        this.numElements = 0;
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public boolean isEmpty() {
        return this.numElements == 0;
    }

    @Override
    public List<T> toList() {
        Object[] copiedElements = new Object[this.numElements];
        System.arraycopy(this.elements, 0, copiedElements, 0, this.numElements);
        return Arrays.asList(copiedElements);
    }

    @Override
    public void add(T e) {
        if (!this.contains((Object)e)) {
            if (this.numElements == this.maxElements) {
                this.doubleCapacity();
            }
            this.elements[this.numElements++] = e;
        }
    }

    private void doubleCapacity() {
        int newSize = this.maxElements * 2;
        Object[] newElements = new Object[newSize];
        System.arraycopy(this.elements, 0, newElements, 0, this.numElements);
        this.elements = newElements;
        this.maxElements = newSize;
    }

    @Override
    public void remove(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            this.remove(i);
            break;
        }
    }

    @Override
    public void remove(int idx) {
        this.elements[idx] = this.elements[--this.numElements];
    }

    @Override
    public void union(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            DavaFlowSet dest = (DavaFlowSet)destFlow;
            DavaFlowSet other = (DavaFlowSet)otherFlow;
            if (dest == other) {
                for (int i = 0; i < this.numElements; ++i) {
                    dest.add(this.elements[i]);
                }
            } else {
                if (this != dest) {
                    this.copy(dest);
                }
                for (int i = 0; i < other.numElements; ++i) {
                    dest.add(other.elements[i]);
                }
            }
        } else {
            super.union(otherFlow, destFlow);
        }
    }

    @Override
    public void intersection(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            DavaFlowSet workingSet;
            DavaFlowSet dest = (DavaFlowSet)destFlow;
            DavaFlowSet other = (DavaFlowSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new DavaFlowSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            for (int i = 0; i < this.numElements; ++i) {
                if (!other.contains((Object)this.elements[i])) continue;
                workingSet.add(this.elements[i]);
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.intersection(otherFlow, destFlow);
        }
    }

    @Override
    public void difference(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            DavaFlowSet workingSet;
            DavaFlowSet dest = (DavaFlowSet)destFlow;
            DavaFlowSet other = (DavaFlowSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new DavaFlowSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            for (int i = 0; i < this.numElements; ++i) {
                if (other.contains((Object)this.elements[i])) continue;
                workingSet.add(this.elements[i]);
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.difference(otherFlow, destFlow);
        }
    }

    @Override
    public boolean contains(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object otherFlow) {
        if (this.sameType(otherFlow)) {
            DavaFlowSet other = (DavaFlowSet)otherFlow;
            if (other.numElements != this.numElements) {
                return false;
            }
            int size = this.numElements;
            for (int i = 0; i < size; ++i) {
                if (other.contains((Object)this.elements[i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(otherFlow);
    }

    @Override
    public void copy(FlowSet<T> destFlow) {
        if (this == destFlow) {
            return;
        }
        if (this.sameType(destFlow)) {
            DavaFlowSet dest = (DavaFlowSet)destFlow;
            while (dest.maxElements < this.maxElements) {
                dest.doubleCapacity();
            }
            dest.numElements = this.numElements;
            System.arraycopy(this.elements, 0, dest.elements, 0, this.numElements);
        } else {
            super.copy(destFlow);
        }
    }

    private List<DavaFlowSet<T>> addIfNotDuplicate(List<DavaFlowSet<T>> into, DavaFlowSet<T> addThis) {
        Iterator<DavaFlowSet<T>> it = into.iterator();
        boolean found = false;
        while (it.hasNext()) {
            DavaFlowSet<T> temp = it.next();
            if (!temp.equals(addThis) || !temp.internalDataMatchesTo(addThis)) continue;
            found = true;
            break;
        }
        if (!found) {
            into.add(addThis);
        }
        return into;
    }

    public void addToBreakList(String labelBroken, DavaFlowSet<T> set) {
        List<DavaFlowSet<T>> labelsBreakList = this.breakList.get(labelBroken);
        if (labelsBreakList == null) {
            labelsBreakList = new ArrayList<DavaFlowSet<T>>();
            labelsBreakList.add(set);
            this.breakList.put((Serializable)((Object)labelBroken), labelsBreakList);
        } else {
            this.breakList.put((Serializable)((Object)labelBroken), this.addIfNotDuplicate(labelsBreakList, set));
        }
    }

    public void addToContinueList(String labelContinued, DavaFlowSet<T> set) {
        List<DavaFlowSet<T>> labelsContinueList = this.continueList.get(labelContinued);
        if (labelsContinueList == null) {
            labelsContinueList = new ArrayList<DavaFlowSet<T>>();
            labelsContinueList.add(set);
            this.continueList.put((Serializable)((Object)labelContinued), labelsContinueList);
        } else {
            this.continueList.put((Serializable)((Object)labelContinued), this.addIfNotDuplicate(labelsContinueList, set));
        }
    }

    private boolean checkImplicit(DAbruptStmt ab) {
        SETNodeLabel label = ab.getLabel();
        return label == null || label.toString() == null;
    }

    public void addToImplicitBreaks(DAbruptStmt ab, DavaFlowSet<T> set) {
        if (!this.checkImplicit(ab)) {
            throw new RuntimeException("Tried to add explicit break statement in the implicit list in");
        }
        if (!ab.is_Break()) {
            throw new RuntimeException("Tried to add continue statement in the break list in DavaFlowSet.addToImplicitBreaks");
        }
        ASTNode node = ClosestAbruptTargetFinder.v().getTarget(ab);
        List<DavaFlowSet<T>> listSets = this.implicitBreaks.get(node);
        if (listSets == null) {
            listSets = new ArrayList<DavaFlowSet<T>>();
        }
        this.implicitBreaks.put(node, this.addIfNotDuplicate(listSets, set));
    }

    public void addToImplicitContinues(DAbruptStmt ab, DavaFlowSet<T> set) {
        if (!this.checkImplicit(ab)) {
            throw new RuntimeException("Tried to add explicit continue statement in the implicit list ");
        }
        if (!ab.is_Continue()) {
            throw new RuntimeException("Tried to add break statement in the continue list");
        }
        ASTNode node = ClosestAbruptTargetFinder.v().getTarget(ab);
        List<DavaFlowSet<T>> listSets = this.implicitContinues.get(node);
        if (listSets == null) {
            listSets = new ArrayList<DavaFlowSet<T>>();
        }
        this.implicitContinues.put(node, this.addIfNotDuplicate(listSets, set));
    }

    private HashMap<Serializable, List<DavaFlowSet<T>>> getBreakList() {
        return this.breakList;
    }

    private HashMap<Serializable, List<DavaFlowSet<T>>> getContinueList() {
        return this.continueList;
    }

    public HashMap<Serializable, List<DavaFlowSet<T>>> getImplicitBreaks() {
        return this.implicitBreaks;
    }

    public HashMap<Serializable, List<DavaFlowSet<T>>> getImplicitContinues() {
        return this.implicitContinues;
    }

    public List<DavaFlowSet<T>> getImplicitlyBrokenSets(ASTNode node) {
        List<DavaFlowSet<T>> toReturn = this.implicitBreaks.get(node);
        if (toReturn != null) {
            return toReturn;
        }
        return null;
    }

    public List<DavaFlowSet<T>> getImplicitlyContinuedSets(ASTNode node) {
        List<DavaFlowSet<T>> toReturn = this.implicitContinues.get(node);
        if (toReturn != null) {
            return toReturn;
        }
        return null;
    }

    private List<DavaFlowSet<T>> copyDavaFlowSetList(List<DavaFlowSet<T>> currentList, List<DavaFlowSet<T>> temp) {
        for (DavaFlowSet<T> check : temp) {
            Iterator<DavaFlowSet<T>> currentListIt = currentList.iterator();
            boolean found = false;
            while (currentListIt.hasNext()) {
                DavaFlowSet<T> currentSet = currentListIt.next();
                if (!check.equals(currentSet) || !check.internalDataMatchesTo(currentSet)) continue;
                found = true;
                break;
            }
            if (found) continue;
            currentList.add(check);
        }
        return currentList;
    }

    public void copyInternalDataFrom(DavaFlowSet<T> fromThis) {
        List<DavaFlowSet<T>> toDavaFlowSets;
        List<DavaFlowSet<T>> fromDavaFlowSets;
        List<DavaFlowSet<T>> complete;
        List<DavaFlowSet<T>> currentList;
        List<DavaFlowSet<T>> temp;
        if (!this.sameType(fromThis)) {
            return;
        }
        HashMap<Serializable, List<DavaFlowSet<T>>> fromThisBreakList = fromThis.getBreakList();
        for (String string : fromThisBreakList.keySet()) {
            temp = (List<DavaFlowSet<T>>)fromThisBreakList.get(string);
            currentList = this.breakList.get(string);
            if (currentList == null) {
                this.breakList.put((Serializable)((Object)string), temp);
                continue;
            }
            complete = this.copyDavaFlowSetList(currentList, temp);
            this.breakList.put((Serializable)((Object)string), complete);
        }
        HashMap<Serializable, List<DavaFlowSet<T>>> fromThisContinueList = fromThis.getContinueList();
        for (String string : fromThisContinueList.keySet()) {
            temp = fromThisContinueList.get(string);
            currentList = this.continueList.get(string);
            if (currentList == null) {
                this.continueList.put((Serializable)((Object)string), temp);
                continue;
            }
            complete = this.copyDavaFlowSetList(currentList, temp);
            this.continueList.put((Serializable)((Object)string), complete);
        }
        HashMap<Serializable, List<DavaFlowSet<T>>> copyThis = fromThis.getImplicitBreaks();
        for (ASTNode aSTNode : copyThis.keySet()) {
            fromDavaFlowSets = copyThis.get(aSTNode);
            toDavaFlowSets = this.implicitBreaks.get(aSTNode);
            if (toDavaFlowSets == null) {
                this.implicitBreaks.put(aSTNode, fromDavaFlowSets);
                continue;
            }
            complete = this.copyDavaFlowSetList(toDavaFlowSets, fromDavaFlowSets);
            this.implicitBreaks.put(aSTNode, complete);
        }
        copyThis = fromThis.getImplicitContinues();
        for (ASTNode aSTNode : copyThis.keySet()) {
            fromDavaFlowSets = copyThis.get(aSTNode);
            toDavaFlowSets = this.implicitContinues.get(aSTNode);
            if (toDavaFlowSets == null) {
                this.implicitContinues.put(aSTNode, fromDavaFlowSets);
                continue;
            }
            complete = this.copyDavaFlowSetList(toDavaFlowSets, fromDavaFlowSets);
            this.implicitContinues.put(aSTNode, complete);
        }
    }

    private <X> boolean compareLists(List<X> listOne, List<X> listTwo) {
        if (listOne == null && listTwo == null) {
            return true;
        }
        if (listOne == null || listTwo == null || listOne.size() != listTwo.size()) {
            return false;
        }
        Iterator<X> listOneIt = listOne.iterator();
        boolean found = false;
        while (listOneIt.hasNext()) {
            X listOneObj = listOneIt.next();
            for (X listTwoObj : listTwo) {
                if (!listOneObj.equals(listTwoObj)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            found = false;
        }
        return true;
    }

    public boolean internalDataMatchesTo(Object otherObj) {
        if (!(otherObj instanceof DavaFlowSet)) {
            return false;
        }
        DavaFlowSet other = (DavaFlowSet)otherObj;
        HashMap<Serializable, List<DavaFlowSet<T>>> otherMap = other.getBreakList();
        if (!this.compareHashMaps(this.breakList, otherMap)) {
            return false;
        }
        otherMap = other.getContinueList();
        if (!this.compareHashMaps(this.continueList, otherMap)) {
            return false;
        }
        otherMap = other.getImplicitBreaks();
        if (!this.compareHashMaps(this.implicitBreaks, otherMap)) {
            return false;
        }
        otherMap = other.getImplicitContinues();
        return this.compareHashMaps(this.implicitContinues, otherMap);
    }

    private boolean compareHashMaps(HashMap<Serializable, List<DavaFlowSet<T>>> thisMap, HashMap<Serializable, List<DavaFlowSet<T>>> otherMap) {
        ArrayList<String> otherKeyList = new ArrayList<String>();
        for (String string : otherMap.keySet()) {
            List<DavaFlowSet<T>> listThis;
            otherKeyList.add(string);
            List<DavaFlowSet<T>> listOther = otherMap.get(string);
            if (this.compareLists(listOther, listThis = thisMap.get(string))) continue;
            return false;
        }
        for (String string : thisMap.keySet()) {
            Iterator keyListIt = otherKeyList.iterator();
            boolean alreadyDone = false;
            while (keyListIt.hasNext()) {
                String doneKey = (String)keyListIt.next();
                if (!string.equals(doneKey)) continue;
                alreadyDone = true;
                break;
            }
            if (alreadyDone) continue;
            return false;
        }
        return true;
    }

    public List<DavaFlowSet<T>> getContinueSet(String label) {
        return this.continueList.remove(label);
    }

    public List<DavaFlowSet<T>> getBreakSet(String label) {
        return this.breakList.remove(label);
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(" SET={");
        for (int i = 0; i < this.numElements; ++i) {
            if (i != 0) {
                b.append(" , ");
            }
            b.append(this.elements[i].toString());
        }
        b.append(" }");
        return b.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int lastIdx = 0;

            @Override
            public boolean hasNext() {
                return this.lastIdx < DavaFlowSet.this.numElements;
            }

            @Override
            public T next() {
                return DavaFlowSet.this.elements[this.lastIdx++];
            }

            @Override
            public void remove() {
                DavaFlowSet.this.remove(--this.lastIdx);
            }
        };
    }

    public int getElementCount() {
        return this.elements.length;
    }

    public T getElementAt(int idx) {
        return this.elements[idx];
    }
}

