/*
 * Decompiled with CFR 0.152.
 */
package soot.dava;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.LongType;
import soot.Modifier;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.UnitPatchingChain;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.DavaUnitPrinter;
import soot.dava.DecompilationException;
import soot.dava.internal.AST.ASTNode;
import soot.dava.toolkits.base.renamer.RemoveFullyQualifiedName;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;
import soot.util.IterableSet;

public class DavaPrinter {
    public DavaPrinter(Singletons.Global g2) {
    }

    public static DavaPrinter v() {
        return G.v().soot_dava_DavaPrinter();
    }

    private void printStatementsInBody(Body body, PrintWriter out) {
        UnitPatchingChain units;
        if (Options.v().verbose()) {
            System.out.println("Printing " + body.getMethod().getName());
        }
        if ((units = body.getUnits()).size() != 1) {
            throw new RuntimeException("DavaBody AST doesn't have single root.");
        }
        DavaUnitPrinter up = new DavaUnitPrinter((DavaBody)body);
        ((ASTNode)units.getFirst()).toString(up);
        out.print(((Object)up).toString());
    }

    public void printTo(SootClass cl, PrintWriter out) {
        Iterator<AbstractHost> interfaceIt;
        String superClassName;
        IterableSet<Object> importList = new IterableSet<String>();
        String curPackage = cl.getJavaPackageName();
        if (!curPackage.isEmpty()) {
            out.println("package " + curPackage + ";");
            out.println();
        }
        if (cl.hasSuperclass()) {
            SootClass superClass = cl.getSuperclass();
            importList.add(superClass.toString());
        }
        for (SootClass sootClass : cl.getInterfaces()) {
            String string = sootClass.toString();
            if (importList.contains(string)) continue;
            importList.add(string);
        }
        Iterator<AbstractHost> methodIt = cl.methodIterator();
        while (methodIt.hasNext()) {
            String returnPackage;
            SootMethod sootMethod = methodIt.next();
            if (sootMethod.hasActiveBody()) {
                importList = importList.union(((DavaBody)sootMethod.getActiveBody()).getImportList());
            }
            for (SootClass sc : sootMethod.getExceptions()) {
                String thrownPackage = sc.toString();
                if (importList.contains(thrownPackage)) continue;
                importList.add(thrownPackage);
            }
            for (Type t3 : sootMethod.getParameterTypes()) {
                String paramPackage;
                if (!(t3 instanceof RefType) || importList.contains(paramPackage = ((RefType)t3).getSootClass().toString())) continue;
                importList.add(paramPackage);
            }
            Type type = sootMethod.getReturnType();
            if (!(type instanceof RefType) || importList.contains(returnPackage = ((RefType)type).getSootClass().toString())) continue;
            importList.add(returnPackage);
        }
        for (SootField sootField : cl.getFields()) {
            String fieldPackage;
            Type type;
            if (sootField.isPhantom() || !((type = sootField.getType()) instanceof RefType) || importList.contains(fieldPackage = ((RefType)type).getSootClass().toString())) continue;
            importList.add(fieldPackage);
        }
        ArrayList<String> toImport = new ArrayList<String>();
        for (String string : importList) {
            String tempClassName;
            if (string.contains("java.lang") && string.equals("java.lang." + (tempClassName = RemoveFullyQualifiedName.getClassName(string))) || !curPackage.isEmpty() && string.contains(curPackage) || cl.toString().equals(string)) continue;
            toImport.add(string);
        }
        for (String string : toImport) {
            if (RemoveFullyQualifiedName.containsMultiple(toImport.iterator(), string, null)) {
                if (string.lastIndexOf(46) > -1) {
                    String string2 = string.substring(0, string.lastIndexOf(46));
                    out.println("import " + string2 + ".*;");
                    continue;
                }
                throw new DecompilationException("Cant find the DOT . for fullyqualified name");
            }
            if (string.lastIndexOf(46) == -1) continue;
            out.println("import " + string + ";");
        }
        out.println();
        Dava.v().set_CurrentPackageContext(importList);
        Dava.v().set_CurrentPackage(curPackage);
        String classPrefix = Modifier.toString(cl.getModifiers()).trim();
        if (!cl.isInterface()) {
            classPrefix = (classPrefix + " class").trim();
        }
        out.print(classPrefix + " " + cl.getShortJavaStyleName());
        if (cl.hasSuperclass() && !"java.lang.Object".equals(superClassName = cl.getSuperclass().getName())) {
            out.print(" extends " + RemoveFullyQualifiedName.getReducedName(importList, superClassName, cl.getType()));
        }
        if ((interfaceIt = cl.getInterfaces().iterator()).hasNext()) {
            if (cl.isInterface()) {
                out.print(" extends ");
            } else {
                out.print(" implements ");
            }
            out.print(interfaceIt.next().getName());
            while (interfaceIt.hasNext()) {
                out.print(", " + ((SootClass)interfaceIt.next()).getName());
            }
        }
        out.println();
        out.println("{");
        for (SootField f : cl.getFields()) {
            if (f.isPhantom()) continue;
            Type type = f.getType();
            String string = (Modifier.toString(f.getModifiers()) + " " + RemoveFullyQualifiedName.getReducedName(importList, type.toString(), type)).trim();
            Object declaration = string.isEmpty() ? Scene.v().quotedNameOf(f.getName()) : string + " " + Scene.v().quotedNameOf(f.getName());
            if (f.isFinal() && f.isStatic()) {
                this.printTags(f, (String)declaration, out);
                continue;
            }
            out.println("    " + (String)declaration + ";");
        }
        Iterator<SootMethod> methodIt2 = cl.methodIterator();
        if (methodIt2.hasNext()) {
            if (cl.getMethodCount() != 0) {
                out.println();
            }
            do {
                SootMethod method;
                if ((method = methodIt2.next()).isPhantom()) continue;
                if (!Modifier.isAbstract(method.getModifiers()) && !Modifier.isNative(method.getModifiers())) {
                    if (!method.hasActiveBody()) {
                        throw new RuntimeException("method " + method.getName() + " has no active body!");
                    }
                    this.printTo(method.getActiveBody(), out);
                    if (!methodIt2.hasNext()) continue;
                    out.println();
                    continue;
                }
                out.print("    ");
                out.print(method.getDavaDeclaration());
                out.println(";");
                if (!methodIt2.hasNext()) continue;
                out.println();
            } while (methodIt2.hasNext());
        }
        if (G.v().SootClassNeedsDavaSuperHandlerClass.contains(cl)) {
            out.println("\n    private static class DavaSuperHandler{");
            out.println("         java.util.Vector myVector = new java.util.Vector();");
            out.println("\n         public Object get(int pos){");
            out.println("            return myVector.elementAt(pos);");
            out.println("         }");
            out.println("\n         public void store(Object obj){");
            out.println("            myVector.add(obj);");
            out.println("         }");
            out.println("    }");
        }
        out.println("}");
    }

    private void printTags(SootField f, String declaration, PrintWriter out) {
        Type fieldType = f.getType();
        if (fieldType instanceof DoubleType) {
            DoubleConstantValueTag t2 = (DoubleConstantValueTag)f.getTag("DoubleConstantValueTag");
            if (t2 != null) {
                out.println("    " + declaration + " = " + t2.getDoubleValue() + ";");
                return;
            }
        } else if (fieldType instanceof FloatType) {
            FloatConstantValueTag t3 = (FloatConstantValueTag)f.getTag("FloatConstantValueTag");
            if (t3 != null) {
                out.println("    " + declaration + " = " + t3.getFloatValue() + "f;");
                return;
            }
        } else if (fieldType instanceof LongType) {
            LongConstantValueTag t4 = (LongConstantValueTag)f.getTag("LongConstantValueTag");
            if (t4 != null) {
                out.println("    " + declaration + " = " + t4.getLongValue() + "l;");
                return;
            }
        } else if (fieldType instanceof CharType) {
            IntegerConstantValueTag t5 = (IntegerConstantValueTag)f.getTag("IntegerConstantValueTag");
            if (t5 != null) {
                out.println("    " + declaration + " = '" + (char)t5.getIntValue() + "';");
                return;
            }
        } else if (fieldType instanceof BooleanType) {
            IntegerConstantValueTag t6 = (IntegerConstantValueTag)f.getTag("IntegerConstantValueTag");
            if (t6 != null) {
                out.println("    " + declaration + (t6.getIntValue() == 0 ? " = false;" : " = true;"));
                return;
            }
        } else if (fieldType instanceof IntType || fieldType instanceof ByteType || fieldType instanceof ShortType) {
            IntegerConstantValueTag t7 = (IntegerConstantValueTag)f.getTag("IntegerConstantValueTag");
            if (t7 != null) {
                out.println("    " + declaration + " = " + t7.getIntValue() + ";");
                return;
            }
        } else {
            StringConstantValueTag t8 = (StringConstantValueTag)f.getTag("StringConstantValueTag");
            if (t8 != null) {
                out.println("    " + declaration + " = \"" + t8.getStringValue() + "\";");
                return;
            }
        }
        out.println("    " + declaration + ";");
    }

    private void printTo(Body b, PrintWriter out) {
        b.validate();
        out.println("    " + b.getMethod().getDavaDeclaration());
        if (Options.v().print_tags_in_output()) {
            for (Tag t2 : b.getMethod().getTags()) {
                out.println(t2);
            }
        }
        out.println("    {");
        this.printStatementsInBody(b, out);
        out.println("    }");
    }
}

