/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.toolkits.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.IntegerType;
import soot.LongType;
import soot.PatchingChain;
import soot.RefLikeType;
import soot.RefType;
import soot.SootMethod;
import soot.StmtAddressType;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.VoidType;
import soot.baf.AddInst;
import soot.baf.AndInst;
import soot.baf.ArrayLengthInst;
import soot.baf.ArrayReadInst;
import soot.baf.ArrayWriteInst;
import soot.baf.BafBody;
import soot.baf.CmpInst;
import soot.baf.CmpgInst;
import soot.baf.CmplInst;
import soot.baf.DivInst;
import soot.baf.Dup1Inst;
import soot.baf.Dup1_x1Inst;
import soot.baf.Dup1_x2Inst;
import soot.baf.Dup2Inst;
import soot.baf.Dup2_x1Inst;
import soot.baf.Dup2_x2Inst;
import soot.baf.DynamicInvokeInst;
import soot.baf.EnterMonitorInst;
import soot.baf.ExitMonitorInst;
import soot.baf.FieldGetInst;
import soot.baf.FieldPutInst;
import soot.baf.GotoInst;
import soot.baf.IdentityInst;
import soot.baf.IfCmpEqInst;
import soot.baf.IfCmpGeInst;
import soot.baf.IfCmpGtInst;
import soot.baf.IfCmpLeInst;
import soot.baf.IfCmpLtInst;
import soot.baf.IfCmpNeInst;
import soot.baf.IfEqInst;
import soot.baf.IfGeInst;
import soot.baf.IfGtInst;
import soot.baf.IfLeInst;
import soot.baf.IfLtInst;
import soot.baf.IfNeInst;
import soot.baf.IfNonNullInst;
import soot.baf.IfNullInst;
import soot.baf.IncInst;
import soot.baf.Inst;
import soot.baf.InstSwitch;
import soot.baf.InstanceCastInst;
import soot.baf.InstanceOfInst;
import soot.baf.InterfaceInvokeInst;
import soot.baf.JSRInst;
import soot.baf.LoadInst;
import soot.baf.LookupSwitchInst;
import soot.baf.MethodArgInst;
import soot.baf.MulInst;
import soot.baf.NegInst;
import soot.baf.NewArrayInst;
import soot.baf.NewInst;
import soot.baf.NewMultiArrayInst;
import soot.baf.NopInst;
import soot.baf.OpTypeArgInst;
import soot.baf.OrInst;
import soot.baf.PopInst;
import soot.baf.PrimitiveCastInst;
import soot.baf.PushInst;
import soot.baf.RemInst;
import soot.baf.ReturnInst;
import soot.baf.ReturnVoidInst;
import soot.baf.ShlInst;
import soot.baf.ShrInst;
import soot.baf.SpecialInvokeInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticInvokeInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.baf.SubInst;
import soot.baf.SwapInst;
import soot.baf.TableSwitchInst;
import soot.baf.TargetArgInst;
import soot.baf.ThrowInst;
import soot.baf.UshrInst;
import soot.baf.VirtualInvokeInst;
import soot.baf.XorInst;
import soot.baf.internal.AbstractOpTypeInst;
import soot.baf.internal.BPopInst;
import soot.toolkits.graph.BriefUnitGraph;
import soot.util.Chain;

public class OpStackCalculator {
    private static final Logger logger = LoggerFactory.getLogger(OpStackCalculator.class);

    public static Map<Unit, Stack<Type>> calculateStacks(BafBody b) {
        IdentityHashMap<Unit, Stack<Type>> results = new IdentityHashMap<Unit, Stack<Type>>();
        StackEffectSwitch sw = new StackEffectSwitch();
        BriefUnitGraph bug = new BriefUnitGraph(b);
        for (Unit h2 : bug.getHeads()) {
            RefType handlerExc = OpStackCalculator.isHandlerUnit(b.getTraps(), h2);
            Stack<Object> stack = (Stack<RefType>)results.get(h2);
            if (stack == null) {
                stack = new Stack<RefType>();
                if (handlerExc != null) {
                    stack.push(handlerExc);
                }
                results.put(h2, stack);
                ArrayList<Unit> worklist = new ArrayList<Unit>();
                worklist.add(h2);
                while (!worklist.isEmpty()) {
                    Inst inst = (Inst)worklist.remove(0);
                    inst.apply(sw);
                    stack = OpStackCalculator.updateStack(sw, (Stack)results.get(inst));
                    for (Unit next : bug.getSuccsOf(inst)) {
                        Stack nxtStck = (Stack)results.get(next);
                        if (nxtStck != null) {
                            if (nxtStck.size() == stack.size()) continue;
                            OpStackCalculator.printStack(sw, b.getUnits(), results);
                            throw new RuntimeException("Problem with stack height at: " + next + "\n\rHas Stack " + nxtStck + " but is expecting " + stack);
                        }
                        results.put(next, stack);
                        worklist.add(next);
                    }
                }
                continue;
            }
            if (stack.size() == (handlerExc != null ? 1 : 0)) continue;
            throw new RuntimeException("Problem with stack height - head expects 0 (or 1 if exception handler)");
        }
        return results;
    }

    private static Stack<Type> updateStack(StackEffectSwitch sw, Stack<Type> st) {
        Stack clone = (Stack)st.clone();
        Type[] remove_types = sw.remove_types;
        if (remove_types != null) {
            if (remove_types.length > clone.size()) {
                StringBuilder exc = new StringBuilder();
                exc.append("Expecting values on stack: ");
                for (Type element : remove_types) {
                    String type = element.toString();
                    if (type.trim().isEmpty()) {
                        type = element instanceof RefLikeType ? "L" : "U";
                    }
                    exc.append(type).append("  ");
                }
                exc.append("\n\tbut only found: ");
                for (Type element : clone) {
                    String type = element.toString();
                    if (type.trim().isEmpty()) {
                        type = element instanceof RefLikeType ? "L" : "U";
                    }
                    exc.append(type).append("  ");
                }
                if (sw.shouldThrow) {
                    throw new RuntimeException(exc.toString());
                }
                logger.debug(exc.toString());
            }
            for (int i = remove_types.length - 1; i >= 0; --i) {
                try {
                    Type t2 = (Type)clone.pop();
                    if ($assertionsDisabled || OpStackCalculator.typesAreCompatible(t2, remove_types[i])) continue;
                    throw new AssertionError();
                }
                catch (Exception exc) {
                    return null;
                }
            }
        }
        if (sw.add_types != null) {
            for (Type element : sw.add_types) {
                clone.push(element);
            }
        }
        return clone;
    }

    private static boolean typesAreCompatible(Type t1, Type t2) {
        if (t1 == t2 || t1 instanceof RefLikeType && t2 instanceof RefLikeType) {
            return true;
        }
        if (t1 instanceof IntegerType && t2 instanceof IntegerType || t1 instanceof LongType && t2 instanceof LongType) {
            return true;
        }
        if (t1 instanceof DoubleType && t2 instanceof DoubleType) {
            return true;
        }
        return t1 instanceof FloatType && t2 instanceof FloatType;
    }

    private static RefType isHandlerUnit(Chain<Trap> traps, Unit h2) {
        for (Trap t2 : traps) {
            if (t2.getHandlerUnit() != h2) continue;
            return t2.getException().getType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStack(StackEffectSwitch sw, PatchingChain<Unit> units, Map<Unit, Stack<Type>> stacks) {
        try {
            sw.shouldThrow = false;
            HashMap<Unit, Integer> indexes = new HashMap<Unit, Integer>();
            int count = 0;
            Iterator<Unit> it = units.snapshotIterator();
            while (it.hasNext()) {
                indexes.put(it.next(), count++);
            }
            Iterator<Unit> it2 = units.snapshotIterator();
            while (it2.hasNext()) {
                Unit unit = it2.next();
                StringBuilder s2 = new StringBuilder();
                try {
                    s2.append(indexes.get(unit)).append(' ').append(unit).append("  ");
                }
                catch (Exception e) {
                    logger.debug("Error in OpStackCalculator trying to find index of unit");
                }
                if (unit instanceof TargetArgInst) {
                    s2.append(indexes.get(((TargetArgInst)unit).getTarget()));
                } else if (unit instanceof TableSwitchInst) {
                    TableSwitchInst tswi = (TableSwitchInst)unit;
                    s2.append("\r\tdefault: ").append(tswi.getDefaultTarget());
                    s2.append("  ").append(indexes.get(tswi.getDefaultTarget()));
                    int index = 0;
                    int e = tswi.getHighIndex();
                    for (int x = tswi.getLowIndex(); x <= e; ++x) {
                        s2.append("\r\t ").append(x).append(": ").append(tswi.getTarget(index));
                        s2.append("  ").append(indexes.get(tswi.getTarget(index++)));
                    }
                }
                s2.append("   [");
                Stack<Type> stack = stacks.get(unit);
                if (stack != null) {
                    unit.apply(sw);
                    stack = OpStackCalculator.updateStack(sw, stack);
                    if (stack == null) {
                        OpStackCalculator.printUnits(units, " StackTypeHeightCalc failed");
                        return;
                    }
                    int e = stack.size();
                    for (int i = 0; i < e; ++i) {
                        s2.append(OpStackCalculator.printType((Type)stack.get(i)));
                    }
                } else {
                    s2.append("***missing***");
                }
                s2.append(']');
                System.out.println(s2);
            }
        }
        finally {
            sw.shouldThrow = true;
        }
    }

    private static String printType(Type t2) {
        if (t2 instanceof IntegerType) {
            return "I";
        }
        if (t2 instanceof FloatType) {
            return "F";
        }
        if (t2 instanceof DoubleType) {
            return "D";
        }
        if (t2 instanceof LongType) {
            return "J";
        }
        if (t2 instanceof RefLikeType) {
            return "L" + t2.toString();
        }
        return "U(" + t2.getClass().toString() + ")";
    }

    private static void printUnits(PatchingChain<Unit> u, String msg) {
        System.out.println("\r\r***********  " + msg);
        HashMap<Unit, Integer> numbers = new HashMap<Unit, Integer>();
        int i = 0;
        Iterator<Unit> it = u.snapshotIterator();
        while (it.hasNext()) {
            numbers.put(it.next(), i++);
        }
        Iterator<Unit> udit = u.snapshotIterator();
        while (udit.hasNext()) {
            Unit unit = udit.next();
            Integer numb = (Integer)numbers.get(unit);
            if (unit instanceof TargetArgInst) {
                TargetArgInst ti = (TargetArgInst)unit;
                if (ti.getTarget() == null) {
                    System.out.println(unit + " null null null null null null null null null");
                    continue;
                }
                System.out.println(numb + " " + unit + "   #" + numbers.get(ti.getTarget()));
                continue;
            }
            if (unit instanceof TableSwitchInst) {
                TableSwitchInst tswi = (TableSwitchInst)unit;
                System.out.println(numb + " SWITCH:");
                System.out.println("\tdefault: " + tswi.getDefaultTarget() + "  " + numbers.get(tswi.getDefaultTarget()));
                int idx = 0;
                int e = tswi.getHighIndex();
                for (int x = tswi.getLowIndex(); x <= e; ++x) {
                    System.out.println("\t " + x + ": " + tswi.getTarget(idx) + "  " + numbers.get(tswi.getTarget(idx++)));
                }
                continue;
            }
            System.out.println(numb + " " + unit);
        }
    }

    private OpStackCalculator() {
    }

    private static class StackEffectSwitch
    implements InstSwitch {
        public boolean shouldThrow = true;
        public Type[] remove_types = null;
        public Type[] add_types = null;

        private StackEffectSwitch() {
        }

        private static RefLikeType arrayRefType() {
            return RefType.v();
        }

        @Override
        public void caseReturnInst(ReturnInst i) {
            this.remove_types = new Type[]{i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseReturnVoidInst(ReturnVoidInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseNopInst(NopInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseGotoInst(GotoInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseJSRInst(JSRInst i) {
            this.remove_types = null;
            this.add_types = new Type[]{StmtAddressType.v()};
        }

        @Override
        public void casePushInst(PushInst i) {
            this.remove_types = null;
            this.add_types = new Type[]{i.getConstant().getType()};
        }

        @Override
        public void casePopInst(PopInst i) {
            this.remove_types = new Type[]{((BPopInst)i).getType()};
            this.add_types = null;
        }

        @Override
        public void caseIdentityInst(IdentityInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseStoreInst(StoreInst i) {
            this.remove_types = new Type[]{((AbstractOpTypeInst)((Object)i)).getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseLoadInst(LoadInst i) {
            this.remove_types = null;
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseArrayWriteInst(ArrayWriteInst i) {
            this.remove_types = new Type[]{StackEffectSwitch.arrayRefType(), IntType.v(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseArrayReadInst(ArrayReadInst i) {
            this.remove_types = new Type[]{StackEffectSwitch.arrayRefType(), IntType.v()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseIfNullInst(IfNullInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = null;
        }

        @Override
        public void caseIfNonNullInst(IfNonNullInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = null;
        }

        @Override
        public void caseIfEqInst(IfEqInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfNeInst(IfNeInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfGtInst(IfGtInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfGeInst(IfGeInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfLtInst(IfLtInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfLeInst(IfLeInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpEqInst(IfCmpEqInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpNeInst(IfCmpNeInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpGtInst(IfCmpGtInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpGeInst(IfCmpGeInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpLtInst(IfCmpLtInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpLeInst(IfCmpLeInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseStaticGetInst(StaticGetInst i) {
            this.remove_types = null;
            this.add_types = new Type[]{i.getField().getType()};
        }

        @Override
        public void caseStaticPutInst(StaticPutInst i) {
            this.remove_types = new Type[]{i.getField().getType()};
            this.add_types = null;
        }

        @Override
        public void caseFieldGetInst(FieldGetInst i) {
            this.remove_types = new Type[]{i.getField().getDeclaringClass().getType()};
            this.add_types = new Type[]{i.getField().getType()};
        }

        @Override
        public void caseFieldPutInst(FieldPutInst i) {
            this.remove_types = new Type[]{i.getField().getDeclaringClass().getType(), i.getField().getType()};
            this.add_types = null;
        }

        @Override
        public void caseInstanceCastInst(InstanceCastInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = new Type[]{i.getCastType()};
        }

        @Override
        public void caseInstanceOfInst(InstanceOfInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = new Type[]{IntType.v()};
        }

        @Override
        public void casePrimitiveCastInst(PrimitiveCastInst i) {
            this.remove_types = new Type[]{i.getFromType()};
            this.add_types = new Type[]{i.getToType()};
        }

        private void staticinvoke(MethodArgInst i) {
            Type[] typeArray;
            SootMethod m4 = i.getMethod();
            int len = m4.getParameterCount();
            this.remove_types = new Type[len];
            System.arraycopy(m4.getParameterTypes().toArray(), 0, this.remove_types, 0, len);
            Type retTy = m4.getReturnType();
            if (retTy instanceof VoidType) {
                typeArray = null;
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = retTy;
            }
            this.add_types = typeArray;
        }

        private void instanceinvoke(MethodArgInst i) {
            Type[] typeArray;
            SootMethod m4 = i.getMethod();
            int len = m4.getParameterCount();
            this.remove_types = new Type[len + 1];
            this.remove_types[0] = RefType.v("java.lang.Object");
            System.arraycopy(m4.getParameterTypes().toArray(), 0, this.remove_types, 1, len);
            Type retTy = m4.getReturnType();
            if (retTy instanceof VoidType) {
                typeArray = null;
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = retTy;
            }
            this.add_types = typeArray;
        }

        @Override
        public void caseDynamicInvokeInst(DynamicInvokeInst i) {
            this.staticinvoke(i);
        }

        @Override
        public void caseStaticInvokeInst(StaticInvokeInst i) {
            this.staticinvoke(i);
        }

        @Override
        public void caseVirtualInvokeInst(VirtualInvokeInst i) {
            this.instanceinvoke(i);
        }

        @Override
        public void caseInterfaceInvokeInst(InterfaceInvokeInst i) {
            this.instanceinvoke(i);
        }

        @Override
        public void caseSpecialInvokeInst(SpecialInvokeInst i) {
            this.instanceinvoke(i);
        }

        @Override
        public void caseThrowInst(ThrowInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Throwable")};
            this.add_types = null;
        }

        @Override
        public void caseAddInst(AddInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        private void bitOps(OpTypeArgInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseAndInst(AndInst i) {
            this.bitOps(i);
        }

        @Override
        public void caseOrInst(OrInst i) {
            this.bitOps(i);
        }

        @Override
        public void caseXorInst(XorInst i) {
            this.bitOps(i);
        }

        @Override
        public void caseArrayLengthInst(ArrayLengthInst i) {
            this.remove_types = new Type[]{StackEffectSwitch.arrayRefType()};
            this.add_types = new Type[]{IntType.v()};
        }

        @Override
        public void caseCmpInst(CmpInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{IntType.v()};
        }

        @Override
        public void caseCmpgInst(CmpgInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{IntType.v()};
        }

        @Override
        public void caseCmplInst(CmplInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{IntType.v()};
        }

        @Override
        public void caseDivInst(DivInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseIncInst(IncInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseMulInst(MulInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseRemInst(RemInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseSubInst(SubInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseShlInst(ShlInst i) {
            this.remove_types = new Type[]{i.getOpType(), IntType.v()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseShrInst(ShrInst i) {
            this.remove_types = new Type[]{i.getOpType(), IntType.v()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseUshrInst(UshrInst i) {
            this.remove_types = new Type[]{i.getOpType(), IntType.v()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseNewInst(NewInst i) {
            this.remove_types = null;
            this.add_types = new Type[]{i.getBaseType()};
        }

        @Override
        public void caseNegInst(NegInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseSwapInst(SwapInst i) {
            this.remove_types = new Type[]{i.getFromType(), i.getToType()};
            this.add_types = new Type[]{i.getToType(), i.getFromType()};
        }

        @Override
        public void caseDup1Inst(Dup1Inst i) {
            this.remove_types = new Type[]{i.getOp1Type()};
            this.add_types = new Type[]{i.getOp1Type(), i.getOp1Type()};
        }

        @Override
        public void caseDup2Inst(Dup2Inst i) {
            if (!(i.getOp1Type() instanceof DoubleType) && !(i.getOp1Type() instanceof LongType)) {
                this.add_types = new Type[]{i.getOp2Type(), i.getOp1Type()};
                this.remove_types = null;
            } else {
                this.add_types = new Type[]{i.getOp1Type()};
                this.remove_types = null;
            }
        }

        @Override
        public void caseDup1_x1Inst(Dup1_x1Inst i) {
            this.remove_types = new Type[]{i.getUnder1Type(), i.getOp1Type()};
            this.add_types = new Type[]{i.getOp1Type(), i.getUnder1Type(), i.getOp1Type()};
        }

        @Override
        public void caseDup1_x2Inst(Dup1_x2Inst i) {
            Type u1 = i.getUnder1Type();
            if (u1 instanceof DoubleType || u1 instanceof LongType) {
                this.remove_types = new Type[]{u1, i.getOp1Type()};
                this.add_types = new Type[]{i.getOp1Type(), u1, i.getOp1Type()};
            } else {
                this.remove_types = new Type[]{i.getUnder2Type(), u1, i.getOp1Type()};
                this.add_types = new Type[]{i.getOp1Type(), i.getUnder2Type(), u1, i.getOp1Type()};
            }
        }

        @Override
        public void caseDup2_x1Inst(Dup2_x1Inst i) {
            Type ot = i.getOp1Type();
            if (ot instanceof DoubleType || ot instanceof LongType) {
                this.remove_types = new Type[]{i.getUnder1Type(), ot};
                this.add_types = new Type[]{ot, i.getUnder1Type(), ot};
            } else {
                this.remove_types = new Type[]{i.getUnder1Type(), i.getOp2Type(), ot};
                this.add_types = new Type[]{i.getOp2Type(), ot, i.getUnder1Type(), i.getOp2Type(), ot};
            }
        }

        @Override
        public void caseDup2_x2Inst(Dup2_x2Inst i) {
            Type u1 = i.getUnder1Type();
            Type o1 = i.getOp1Type();
            if (u1 instanceof DoubleType || u1 instanceof LongType) {
                if (o1 instanceof DoubleType || o1 instanceof LongType) {
                    this.remove_types = new Type[]{u1, o1};
                    this.add_types = new Type[]{o1, u1, o1};
                } else {
                    this.remove_types = new Type[]{u1, i.getOp2Type(), o1};
                    this.add_types = new Type[]{i.getOp2Type(), o1, u1, i.getOp2Type(), o1};
                }
            } else if (o1 instanceof DoubleType || o1 instanceof LongType) {
                this.remove_types = new Type[]{i.getUnder2Type(), u1, o1};
                this.add_types = new Type[]{o1, i.getUnder2Type(), u1, o1};
            } else {
                this.remove_types = new Type[]{i.getUnder2Type(), u1, i.getOp2Type(), o1};
                this.add_types = new Type[]{i.getOp2Type(), o1, i.getUnder2Type(), u1, i.getOp2Type(), o1};
            }
        }

        @Override
        public void caseNewArrayInst(NewArrayInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = new Type[]{StackEffectSwitch.arrayRefType()};
        }

        @Override
        public void caseNewMultiArrayInst(NewMultiArrayInst i) {
            int size = i.getDimensionCount();
            this.remove_types = new Type[size];
            Arrays.fill(this.remove_types, 0, size, IntType.v());
            this.add_types = new Type[]{StackEffectSwitch.arrayRefType()};
        }

        @Override
        public void caseLookupSwitchInst(LookupSwitchInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseTableSwitchInst(TableSwitchInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseEnterMonitorInst(EnterMonitorInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = null;
        }

        @Override
        public void caseExitMonitorInst(ExitMonitorInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = null;
        }
    }
}

