/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.toolkits.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PhaseOptions;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.baf.AddInst;
import soot.baf.AndInst;
import soot.baf.ArrayReadInst;
import soot.baf.ArrayWriteInst;
import soot.baf.Baf;
import soot.baf.Dup1Inst;
import soot.baf.DupInst;
import soot.baf.EnterMonitorInst;
import soot.baf.ExitMonitorInst;
import soot.baf.FieldArgInst;
import soot.baf.FieldGetInst;
import soot.baf.FieldPutInst;
import soot.baf.IdentityInst;
import soot.baf.IncInst;
import soot.baf.Inst;
import soot.baf.LoadInst;
import soot.baf.MethodArgInst;
import soot.baf.MulInst;
import soot.baf.NewInst;
import soot.baf.OrInst;
import soot.baf.PushInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.baf.XorInst;
import soot.options.Options;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.ZonedBlockGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;

public class LoadStoreOptimizer
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(LoadStoreOptimizer.class);
    private static final boolean SKIP_SLOW_ASSERTS = true;
    private static final int FAILURE = 0;
    private static final int SUCCESS = 1;
    private static final int MAKE_DUP = 2;
    private static final int MAKE_DUP1_X1 = 3;
    private static final int SPECIAL_SUCCESS = 4;
    private static final int HAS_CHANGED = 5;
    private static final int SPECIAL_SUCCESS2 = 6;
    private static final int STORE_LOAD_ELIMINATION = 0;
    private static final int STORE_LOAD_LOAD_ELIMINATION = -1;

    public LoadStoreOptimizer(Singletons.Global g2) {
    }

    public static LoadStoreOptimizer v() {
        return G.v().soot_baf_toolkits_base_LoadStoreOptimizer();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        boolean debug = PhaseOptions.getBoolean(options, "debug");
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Performing LoadStore optimizations...");
        }
        if (debug) {
            logger.debug("\n\nOptimizing Method: " + body.getMethod().getName());
        }
        new Instance(body, options, debug).go();
    }

    private static class Instance {
        private final boolean debug;
        private final Map<String, String> gOptions;
        private final Chain<Unit> mUnits;
        private final Body mBody;
        private final Map<Unit, Block> mUnitToBlockMap;
        private LocalDefs mLocalDefs;
        private LocalUses mLocalUses;

        public Instance(Body b, Map<String, String> options, boolean debug) {
            this.mBody = b;
            this.mUnits = b.getUnits();
            this.gOptions = options;
            this.debug = debug;
            this.mUnitToBlockMap = new HashMap<Unit, Block>();
        }

        public void go() {
            if (!this.mUnits.isEmpty()) {
                this.buildUnitToBlockMap();
                if (this.debug) {
                    logger.debug("Calling optimizeLoadStore(1)\n");
                }
                this.optimizeLoadStores(false);
                if (PhaseOptions.getBoolean(this.gOptions, "inter")) {
                    if (this.debug) {
                        logger.debug("Calling doInterBlockOptimizations");
                    }
                    this.doInterBlockOptimizations();
                }
                if (PhaseOptions.getBoolean(this.gOptions, "sl2") || PhaseOptions.getBoolean(this.gOptions, "sll2")) {
                    if (this.debug) {
                        logger.debug("Calling optimizeLoadStore(2)");
                    }
                    this.optimizeLoadStores(true);
                }
            }
        }

        private void buildUnitToBlockMap() {
            this.mUnitToBlockMap.clear();
            ZonedBlockGraph blockGraph = new ZonedBlockGraph(this.mBody);
            if (this.debug) {
                logger.debug("Method " + this.mBody.getMethod().getName() + " Block Graph: ");
                logger.debug(blockGraph.toString());
            }
            for (Block block : blockGraph.getBlocks()) {
                for (Unit unit : block) {
                    this.mUnitToBlockMap.put(unit, block);
                }
            }
        }

        private void computeLocalDefsAndLocalUsesInfo() {
            if (this.mLocalDefs == null) {
                this.mLocalDefs = G.v().soot_toolkits_scalar_LocalDefsFactory().newLocalDefs(this.mBody);
            }
            if (this.mLocalUses == null) {
                this.mLocalUses = LocalUses.Factory.newLocalUses(this.mBody, this.mLocalDefs);
            }
        }

        private void clearLocalDefsAndLocalUsesInfo() {
            this.mLocalDefs = null;
            this.mLocalUses = null;
        }

        private List<Unit> buildStoreList() {
            ArrayList<Unit> storeList = new ArrayList<Unit>();
            for (Unit unit : this.mUnits) {
                if (!(unit instanceof StoreInst)) continue;
                storeList.add(unit);
            }
            return storeList;
        }

        /*
         * WARNING - void declaration
         */
        private void optimizeLoadStores(boolean mPass2) {
            this.computeLocalDefsAndLocalUsesInfo();
            List<Unit> storeList = this.buildStoreList();
            boolean hasChanged = true;
            boolean hasChangedFlag = false;
            while (hasChanged) {
                hasChanged = false;
                Iterator<Unit> unitIt = storeList.iterator();
                block6: while (unitIt.hasNext()) {
                    Unit unit = unitIt.next();
                    List<UnitValueBoxPair> uses = this.mLocalUses.getUsesOf(unit);
                    if (uses.size() >= 3) continue;
                    for (UnitValueBoxPair unitValueBoxPair : uses) {
                        List<Unit> defs;
                        Unit loadUnit = unitValueBoxPair.getUnit();
                        if (loadUnit instanceof LoadInst && (defs = this.mLocalDefs.getDefsOfAt((Local)unitValueBoxPair.getValueBox().getValue(), loadUnit)).size() <= 1 && defs.get(0) == unit) continue;
                        continue block6;
                    }
                    Block storeBlock = this.mUnitToBlockMap.get(unit);
                    for (UnitValueBoxPair pair3 : uses) {
                        Block useBlock = this.mUnitToBlockMap.get(pair3.getUnit());
                        if (useBlock == storeBlock) continue;
                        continue block6;
                    }
                    switch (uses.size()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            Block block;
                            if (!PhaseOptions.getBoolean(this.gOptions, "sl") || mPass2 && !PhaseOptions.getBoolean(this.gOptions, "sl2")) break;
                            Unit loadUnit = uses.get(0).getUnit();
                            int test = this.stackIndependent(unit, loadUnit, block = this.mUnitToBlockMap.get(unit), 0);
                            if (test != 1 && test != 4) continue block6;
                            block.remove(unit);
                            this.mUnitToBlockMap.remove(unit);
                            block.remove(loadUnit);
                            this.mUnitToBlockMap.remove(loadUnit);
                            unitIt.remove();
                            hasChanged = true;
                            hasChangedFlag = false;
                            if (!this.debug) continue block6;
                            logger.debug("Store/Load elimination occurred case1.");
                            break;
                        }
                        case 2: {
                            Block block;
                            int result;
                            Unit unit2;
                            if (!PhaseOptions.getBoolean(this.gOptions, "sll") || mPass2 && !PhaseOptions.getBoolean(this.gOptions, "sll2")) break;
                            Unit firstLoad = uses.get(0).getUnit();
                            if (this.mUnits.follows(firstLoad, unit2 = uses.get(1).getUnit())) {
                                Unit temp = unit2;
                                Unit unit3 = firstLoad;
                                firstLoad = temp;
                            }
                            if ((result = this.stackIndependent(unit, firstLoad, block = this.mUnitToBlockMap.get(unit), 0)) == 1) {
                                void var9_15;
                                block.remove(firstLoad);
                                block.insertAfter(firstLoad, unit);
                                int res = this.stackIndependent(unit, (Unit)var9_15, block, -1);
                                if (res != 2) continue block6;
                                Dup1Inst dup = Baf.v().newDup1Inst(((LoadInst)var9_15).getOpType());
                                dup.addAllTagsOf(unit);
                                this.replaceUnit(unit, dup);
                                unitIt.remove();
                                block.remove(firstLoad);
                                this.mUnitToBlockMap.remove(firstLoad);
                                block.remove((Unit)var9_15);
                                this.mUnitToBlockMap.remove(var9_15);
                                hasChanged = true;
                                hasChangedFlag = false;
                                break;
                            }
                            if (result != 4 && result != 5 && result != 6 || hasChangedFlag) break;
                            hasChangedFlag = true;
                            hasChanged = true;
                        }
                    }
                }
            }
        }

        private boolean isRequiredByFollowingUnits(Unit from, Unit to) {
            if (from != to) {
                Unit currentInst;
                int stackHeight = 0;
                Iterator<Unit> it = this.mUnits.iterator(from, to);
                it.next();
                while (it.hasNext() && (currentInst = it.next()) != to) {
                    if ((stackHeight -= ((Inst)currentInst).getInCount()) < 0) {
                        return true;
                    }
                    stackHeight += ((Inst)currentInst).getOutCount();
                }
            }
            return false;
        }

        private int pushStoreToLoad(Unit from, Unit to, Block block) {
            Unit storePred = block.getPredOf(from);
            if (storePred == null || ((Inst)storePred).getOutCount() != 1) {
                if (this.debug) {
                    if (storePred == null) {
                        logger.debug("xxx: failed due: cannot move past block tail ");
                    } else {
                        logger.debug("xxx: failed due: pred out-count != 1 ");
                    }
                }
                return 0;
            }
            HashSet<Unit> unitsToMove = new HashSet<Unit>();
            unitsToMove.add(storePred);
            unitsToMove.add(from);
            int h2 = ((Inst)storePred).getInCount();
            Unit currentUnit = storePred;
            if (h2 != 0) {
                currentUnit = block.getPredOf(storePred);
                while (currentUnit != null) {
                    if ((h2 -= ((Inst)currentUnit).getOutCount()) < 0) {
                        if (this.debug) {
                            logger.debug("xxx: negative");
                        }
                        return 0;
                    }
                    unitsToMove.add(currentUnit);
                    if ((h2 += ((Inst)currentUnit).getInCount()) == 0) break;
                    currentUnit = block.getPredOf(currentUnit);
                }
            }
            if (currentUnit == null) {
                if (this.debug) {
                    logger.debug("xxx: null");
                }
                return 0;
            }
            Unit uu = block.getSuccOf(from);
            while (uu != to) {
                for (Unit nu : unitsToMove) {
                    if (!this.canMoveUnitOver(nu, uu)) {
                        if (this.debug) {
                            logger.debug("xxx: failure cannot move " + nu + " over " + uu);
                        }
                        return 0;
                    }
                    if (!this.debug) continue;
                    logger.debug("can move " + nu + " over " + uu);
                }
                uu = block.getSuccOf(uu);
            }
            Unit unitToMove = currentUnit;
            while (unitToMove != from) {
                Unit succ = block.getSuccOf(unitToMove);
                if (this.debug) {
                    logger.debug("moving " + unitToMove);
                }
                block.remove(unitToMove);
                block.insertBefore(unitToMove, to);
                unitToMove = succ;
            }
            block.remove(from);
            block.insertBefore(from, to);
            if (this.debug) {
                logger.debug("xxx: success pushing forward stuff.");
            }
            return 4;
        }

        private int stackIndependent(Unit from, Unit to, Block block, int aContext) {
            assert (aContext == 0 || aContext == -1);
            if (this.debug) {
                logger.debug("Trying: " + from + "/" + to + " in block  " + block.getIndexInMethod() + ":");
                logger.debug("context: " + (aContext == 0 ? "STORE_LOAD_ELIMINATION" : "STORE_LOAD_LOAD_ELIMINATION"));
            }
            int minStackHeightAttained = 0;
            int stackHeight = 0;
            Iterator<Unit> it = this.mUnits.iterator(this.mUnits.getSuccOf(from));
            Unit currentInst = it.next();
            if (aContext == -1) {
                currentInst = it.next();
            }
            while (currentInst != to && it.hasNext()) {
                if ((stackHeight -= ((Inst)currentInst).getInCount()) < minStackHeightAttained) {
                    minStackHeightAttained = stackHeight;
                }
                stackHeight += ((Inst)currentInst).getOutCount();
                currentInst = it.next();
            }
            if (this.debug) {
                logger.debug("nshv = " + stackHeight);
                logger.debug("mshv = " + minStackHeightAttained);
            }
            boolean hasChanged = true;
            block1: while (hasChanged) {
                hasChanged = false;
                if (aContext == -1) {
                    if (stackHeight == 0 && minStackHeightAttained == 0) {
                        if (this.debug) {
                            logger.debug("xxx: succ: -1, makedup ");
                        }
                        return 2;
                    }
                    if (stackHeight == -1 && minStackHeightAttained == -1) {
                        if (this.debug) {
                            logger.debug("xxx: succ: -1, makedup , -1");
                        }
                        return 2;
                    }
                    if (stackHeight == -2 && minStackHeightAttained == -2) {
                        if (this.debug) {
                            logger.debug("xxx: succ -1 , make dupx1 ");
                        }
                        return 3;
                    }
                    if (minStackHeightAttained < -2) {
                        if (this.debug) {
                            logger.debug("xxx: failed due: minStackHeightAttained < -2 ");
                        }
                        return 0;
                    }
                } else if (aContext == 0) {
                    if (stackHeight == 0 && minStackHeightAttained == 0) {
                        if (this.debug) {
                            logger.debug("xxx: success due: 0, SUCCESS");
                        }
                        return 1;
                    }
                    if (minStackHeightAttained < 0) {
                        return this.pushStoreToLoad(from, to, block);
                    }
                }
                Iterator<Unit> it2 = this.mUnits.iterator(this.mUnits.getSuccOf(from), to);
                Unit u = it2.next();
                if (aContext == -1) {
                    u = it2.next();
                }
                while (u != to) {
                    Unit unitToMove = null;
                    if (((Inst)u).getNetCount() == 1) {
                        if (u instanceof LoadInst || u instanceof PushInst || u instanceof NewInst || u instanceof StaticGetInst || u instanceof Dup1Inst) {
                            if (!this.isRequiredByFollowingUnits(u, to)) {
                                unitToMove = u;
                            }
                        } else if (this.debug) {
                            logger.debug("(LoadStoreOptimizer@stackIndependent): found unknown unit w/ getNetCount == 1: " + u);
                        }
                    }
                    if (unitToMove != null && this.tryToMoveUnit(unitToMove, block, from, to, 0)) {
                        if (stackHeight > -2 && minStackHeightAttained == -2) {
                            if (this.debug) {
                                logger.debug("xxx: has changed ");
                            }
                            return 5;
                        }
                        if (--stackHeight < minStackHeightAttained) {
                            minStackHeightAttained = stackHeight;
                        }
                        hasChanged = true;
                        continue block1;
                    }
                    u = it2.next();
                }
            }
            if (this.isCommutativeBinOp(block.getSuccOf(to))) {
                Inst toPred;
                if (aContext == 0 && stackHeight == 1 && minStackHeightAttained == 0) {
                    if (this.debug) {
                        logger.debug("xxx: commutative ");
                    }
                    return 4;
                }
                Inst toAsInst = (Inst)to;
                if (toAsInst.getOutCount() == 1 && toAsInst.getInCount() == 0 && (toPred = (Inst)this.mUnits.getPredOf(to)).getOutCount() == 1 && toPred.getInCount() == 0) {
                    block.remove(toPred);
                    block.insertAfter(toPred, to);
                    if (this.debug) {
                        logger.debug("xxx: (commutative) has changed ");
                    }
                    return 5;
                }
                if (this.debug) {
                    logger.debug("xxx: (commutative) failed due: ??? ");
                }
                return 0;
            }
            if (aContext == 0) {
                return this.pushStoreToLoad(from, to, block);
            }
            if (this.debug) {
                logger.debug("xxx: failed due: ??? ");
            }
            return 0;
        }

        private boolean isNonLocalReadOrWrite(Unit aUnit) {
            return aUnit instanceof FieldArgInst || aUnit instanceof ArrayReadInst || aUnit instanceof ArrayWriteInst;
        }

        private boolean canMoveUnitOver(Unit aUnitToMove, Unit aUnitToGoOver) {
            if (aUnitToGoOver instanceof MethodArgInst && aUnitToMove instanceof MethodArgInst || aUnitToGoOver instanceof MethodArgInst && this.isNonLocalReadOrWrite(aUnitToMove) || this.isNonLocalReadOrWrite(aUnitToGoOver) && aUnitToMove instanceof MethodArgInst || aUnitToGoOver instanceof ArrayReadInst && aUnitToMove instanceof ArrayWriteInst || aUnitToGoOver instanceof ArrayWriteInst && aUnitToMove instanceof ArrayReadInst || aUnitToGoOver instanceof ArrayWriteInst && aUnitToMove instanceof ArrayWriteInst || aUnitToGoOver instanceof FieldPutInst && aUnitToMove instanceof FieldGetInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField() || aUnitToGoOver instanceof FieldGetInst && aUnitToMove instanceof FieldPutInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField() || aUnitToGoOver instanceof FieldPutInst && aUnitToMove instanceof FieldPutInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField() || aUnitToGoOver instanceof StaticPutInst && aUnitToMove instanceof StaticGetInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField() || aUnitToGoOver instanceof StaticGetInst && aUnitToMove instanceof StaticPutInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField() || aUnitToGoOver instanceof StaticPutInst && aUnitToMove instanceof StaticPutInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField()) {
                return false;
            }
            if (aUnitToGoOver instanceof EnterMonitorInst || aUnitToGoOver instanceof ExitMonitorInst || aUnitToMove instanceof EnterMonitorInst || aUnitToGoOver instanceof ExitMonitorInst) {
                return false;
            }
            if (aUnitToGoOver instanceof IdentityInst || aUnitToMove instanceof IdentityInst) {
                return false;
            }
            if (aUnitToMove instanceof LoadInst && (aUnitToGoOver instanceof StoreInst ? ((StoreInst)aUnitToGoOver).getLocal() == ((LoadInst)aUnitToMove).getLocal() : aUnitToGoOver instanceof IncInst && ((IncInst)aUnitToGoOver).getLocal() == ((LoadInst)aUnitToMove).getLocal())) {
                return false;
            }
            if (aUnitToMove instanceof StoreInst && (aUnitToGoOver instanceof LoadInst ? ((LoadInst)aUnitToGoOver).getLocal() == ((StoreInst)aUnitToMove).getLocal() : aUnitToGoOver instanceof IncInst && ((IncInst)aUnitToGoOver).getLocal() == ((StoreInst)aUnitToMove).getLocal())) {
                return false;
            }
            return !(aUnitToMove instanceof IncInst) || !(aUnitToGoOver instanceof StoreInst ? ((StoreInst)aUnitToGoOver).getLocal() == ((IncInst)aUnitToMove).getLocal() : aUnitToGoOver instanceof LoadInst && ((LoadInst)aUnitToGoOver).getLocal() == ((IncInst)aUnitToMove).getLocal());
        }

        private boolean tryToMoveUnit(Unit unitToMove, Block block, Unit from, Unit to, int flag) {
            if (this.debug) {
                logger.debug("[tryToMoveUnit]: trying to move:" + unitToMove);
            }
            if (unitToMove == null) {
                return false;
            }
            int h2 = 0;
            boolean reachedStore = false;
            boolean reorderingOccurred = false;
            Unit current = unitToMove;
            while (current != block.getHead()) {
                if (!this.canMoveUnitOver(current = this.mUnits.getPredOf(current), unitToMove)) {
                    return false;
                }
                if (current == from) {
                    reachedStore = true;
                }
                if ((h2 -= ((Inst)current).getOutCount()) < 0) {
                    if (this.debug) {
                        logger.debug("(LoadStoreOptimizer@stackIndependent): Stack went negative while trying to reorder code.");
                    }
                    if (flag == 1 && current instanceof DupInst) {
                        block.remove(unitToMove);
                        block.insertAfter(unitToMove, current);
                    }
                    return false;
                }
                if ((h2 += ((Inst)current).getInCount()) != 0 || !reachedStore || this.isRequiredByFollowingUnits(unitToMove, to)) continue;
                if (this.debug) {
                    logger.debug("(LoadStoreOptimizer@stackIndependent): reordering bytecode move: " + unitToMove + " before: " + current);
                }
                block.remove(unitToMove);
                block.insertBefore(unitToMove, current);
                reorderingOccurred = true;
                break;
            }
            if (this.debug) {
                if (reorderingOccurred) {
                    logger.debug("reordering occurred");
                } else {
                    logger.debug("(LoadStoreOptimizer@stackIndependent):failed to find a new slot for unit to move");
                }
            }
            return reorderingOccurred;
        }

        private void replaceUnit(Unit aToReplace1, Unit aToReplace2, Unit aReplacement) {
            Block block = this.mUnitToBlockMap.get(aToReplace1);
            if (aToReplace2 != null) {
                block.insertAfter(aReplacement, aToReplace2);
                block.remove(aToReplace2);
                this.mUnitToBlockMap.remove(aToReplace2);
            } else {
                block.insertAfter(aReplacement, aToReplace1);
            }
            block.remove(aToReplace1);
            this.mUnitToBlockMap.remove(aToReplace1);
            this.mUnitToBlockMap.put(aReplacement, block);
        }

        private void replaceUnit(Unit aToReplace, Unit aReplacement) {
            this.replaceUnit(aToReplace, null, aReplacement);
        }

        private boolean isExceptionHandlerBlock(Block aBlock) {
            Unit blockHead = aBlock.getHead();
            for (Trap trap : this.mBody.getTraps()) {
                if (trap.getHandlerUnit() != blockHead) continue;
                return true;
            }
            return false;
        }

        private int getDeltaStackHeightFromTo(Unit aFrom, Unit aTo) {
            int h2 = 0;
            Iterator<Unit> it = this.mUnits.iterator(aFrom, aTo);
            while (it.hasNext()) {
                Unit next = it.next();
                h2 += ((Inst)next).getNetCount();
            }
            return h2;
        }

        private boolean isZeroStackDeltaWithoutClobbering(Unit aFrom, Unit aTo) {
            int h2 = 0;
            Iterator<Unit> it = this.mUnits.iterator(aFrom, aTo);
            while (it.hasNext()) {
                Inst next = (Inst)it.next();
                if (next.getInCount() > h2) {
                    return false;
                }
                if ((h2 += next.getNetCount()) >= 0) continue;
                return false;
            }
            return h2 == 0;
        }

        private void doInterBlockOptimizations() {
            boolean hasChanged = true;
            while (hasChanged) {
                this.computeLocalDefsAndLocalUsesInfo();
                hasChanged = false;
                if (this.debug) {
                    logger.debug("[doInterBlockOptimizations] begin pass...");
                }
                for (Unit u : new ArrayList<Unit>(this.mUnits)) {
                    if (!(u instanceof LoadInst)) continue;
                    if (this.debug) {
                        logger.debug("interopt trying: " + u);
                    }
                    Block loadBlock = this.mUnitToBlockMap.get(u);
                    List<Unit> defs = this.mLocalDefs.getDefsOfAt(((LoadInst)u).getLocal(), u);
                    if (this.debug) {
                        logger.debug("  loadBlock: " + loadBlock);
                        logger.debug("  defs: " + defs);
                    }
                    if (defs.size() == 1) {
                        List<UnitValueBoxPair> uses;
                        Unit def = defs.get(0);
                        Block defBlock = this.mUnitToBlockMap.get(def);
                        if (defBlock == loadBlock || this.isExceptionHandlerBlock(loadBlock) || !(def instanceof StoreInst) || (uses = this.mLocalUses.getUsesOf(def)).size() != 1 || !this.allSuccesorsOfAreThePredecessorsOf(defBlock, loadBlock) || !this.isZeroStackDeltaWithoutClobbering(defBlock.getSuccOf(def), defBlock.getTail())) continue;
                        boolean res = true;
                        for (Block b : defBlock.getSuccs()) {
                            if (this.getDeltaStackHeightFromTo(b.getHead(), b.getTail()) == 0 && b.getPreds().size() == 1 && b.getSuccs().size() == 1) continue;
                            res = false;
                            break;
                        }
                        if (this.debug) {
                            logger.debug(defBlock.toString() + loadBlock.toString());
                        }
                        if (!res) continue;
                        defBlock.remove(def);
                        this.mUnitToBlockMap.put(def, loadBlock);
                        loadBlock.insertBefore(def, loadBlock.getHead());
                        hasChanged = true;
                        if (this.debug) {
                            logger.debug("inter-block opt 1 occurred " + def + " " + u);
                        }
                        if (!this.debug) continue;
                        logger.debug(defBlock.toString() + loadBlock.toString());
                        continue;
                    }
                    if (defs.size() != 2) continue;
                    Unit def0 = defs.get(0);
                    Block defBlock0 = this.mUnitToBlockMap.get(def0);
                    Unit def1 = defs.get(1);
                    Block defBlock1 = this.mUnitToBlockMap.get(def1);
                    if (defBlock0 != loadBlock && defBlock1 != loadBlock && defBlock0 != defBlock1 && !this.isExceptionHandlerBlock(loadBlock)) {
                        if (this.mLocalUses.getUsesOf(def0).size() == 1 && this.mLocalUses.getUsesOf(def1).size() == 1) {
                            List<Block> def0Succs = defBlock0.getSuccs();
                            List<Block> def1Succs = defBlock1.getSuccs();
                            if (def0Succs.size() == 1 && def1Succs.size() == 1) {
                                if (def0Succs.get(0) == loadBlock && def1Succs.get(0) == loadBlock) {
                                    if (loadBlock.getPreds().size() == 2) {
                                        Unit tailB0 = defBlock0.getTail();
                                        Unit tailB1 = defBlock1.getTail();
                                        if ((def0 == tailB0 || this.isZeroStackDeltaWithoutClobbering(defBlock0.getSuccOf(def0), tailB0)) && (def1 == tailB1 || this.isZeroStackDeltaWithoutClobbering(defBlock1.getSuccOf(def1), tailB1))) {
                                            defBlock0.remove(def0);
                                            defBlock1.remove(def1);
                                            loadBlock.insertBefore(def0, loadBlock.getHead());
                                            this.mUnitToBlockMap.put(def0, loadBlock);
                                            this.mUnitToBlockMap.remove(def1);
                                            hasChanged = true;
                                            if (!this.debug) continue;
                                            logger.debug("inter-block opt 2 occurred " + def0);
                                            continue;
                                        }
                                        if (!this.debug) continue;
                                        logger.debug("failed: inter: unacceptable stack offset");
                                        continue;
                                    }
                                    if (!this.debug) continue;
                                    logger.debug("failed: inter: 'loadBlock' #preds != 2");
                                    continue;
                                }
                                if (!this.debug) continue;
                                logger.debug("failed: inter: successor is not 'loadBlock'");
                                continue;
                            }
                            if (!this.debug) continue;
                            logger.debug("failed: inter: #successors != 1");
                            continue;
                        }
                        if (!this.debug) continue;
                        logger.debug("failed: inter: #defs != 1");
                        continue;
                    }
                    if (!this.debug) continue;
                    logger.debug("failed: inter: unacceptable blocks");
                }
                if (this.debug) {
                    logger.debug("[doInterBlockOptimizations] completed pass. changed? " + hasChanged);
                }
                if (!hasChanged) continue;
                this.clearLocalDefsAndLocalUsesInfo();
            }
        }

        private boolean allSuccesorsOfAreThePredecessorsOf(Block aFirstBlock, Block aSecondBlock) {
            List<Block> preds = aSecondBlock.getPreds();
            for (Block next : aFirstBlock.getSuccs()) {
                if (preds.contains(next)) continue;
                return false;
            }
            return aFirstBlock.getSuccs().size() == preds.size();
        }

        private boolean isCommutativeBinOp(Unit aUnit) {
            return aUnit instanceof AddInst || aUnit instanceof MulInst || aUnit instanceof AndInst || aUnit instanceof OrInst || aUnit instanceof XorInst;
        }

        private boolean unitToBlockMapIsValid() {
            for (Unit u : this.mUnits) {
                assert (this.mUnitToBlockMap.containsKey(u));
            }
            HashSet<Block> blocks = new HashSet<Block>();
            for (Map.Entry<Unit, Block> e : this.mUnitToBlockMap.entrySet()) {
                blocks.add(e.getValue());
                assert (Instance.contains(e.getValue(), e.getKey()));
            }
            for (Block b : blocks) {
                Unit t2 = b.getTail();
                assert (this.mUnitToBlockMap.get(t2) == b);
                Unit u2 = b.getHead();
                while (u2 != t2) {
                    assert (this.mUnitToBlockMap.get(u2) == b);
                    u2 = b.getSuccOf(u2);
                }
            }
            return true;
        }

        private static boolean contains(Block b, Unit u) {
            Unit t2 = b.getTail();
            if (u == t2) {
                return true;
            }
            Unit u2 = b.getHead();
            while (u2 != t2) {
                if (u == u2) {
                    return true;
                }
                u2 = b.getSuccOf(u2);
            }
            return false;
        }
    }
}

