/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.baf.Baf;
import soot.baf.SwitchInst;
import soot.baf.internal.AbstractInst;

public abstract class AbstractSwitchInst
extends AbstractInst
implements SwitchInst {
    UnitBox defaultTargetBox;
    UnitBox[] targetBoxes;
    List<UnitBox> unitBoxes;

    public AbstractSwitchInst(Unit defaultTarget, List<? extends Unit> targets) {
        this.defaultTargetBox = Baf.v().newInstBox(defaultTarget);
        int numTargets = targets.size();
        UnitBox[] tgts = new UnitBox[numTargets];
        for (int i = 0; i < numTargets; ++i) {
            tgts[i] = Baf.v().newInstBox(targets.get(i));
        }
        this.targetBoxes = tgts;
        ArrayList<UnitBox> unitBoxes = new ArrayList<UnitBox>(numTargets + 1);
        for (UnitBox element : tgts) {
            unitBoxes.add(element);
        }
        unitBoxes.add(this.defaultTargetBox);
        this.unitBoxes = Collections.unmodifiableList(unitBoxes);
    }

    @Override
    public int getInCount() {
        return 1;
    }

    @Override
    public int getInMachineCount() {
        return 1;
    }

    @Override
    public int getOutCount() {
        return 0;
    }

    @Override
    public int getOutMachineCount() {
        return 0;
    }

    @Override
    public List<UnitBox> getUnitBoxes() {
        return this.unitBoxes;
    }

    @Override
    public boolean fallsThrough() {
        return false;
    }

    @Override
    public boolean branches() {
        return true;
    }

    @Override
    public Unit getDefaultTarget() {
        return this.defaultTargetBox.getUnit();
    }

    @Override
    public void setDefaultTarget(Unit defaultTarget) {
        this.defaultTargetBox.setUnit(defaultTarget);
    }

    @Override
    public UnitBox getDefaultTargetBox() {
        return this.defaultTargetBox;
    }

    @Override
    public int getTargetCount() {
        return this.targetBoxes.length;
    }

    @Override
    public Unit getTarget(int index) {
        return this.targetBoxes[index].getUnit();
    }

    @Override
    public void setTarget(int index, Unit target) {
        this.targetBoxes[index].setUnit(target);
    }

    @Override
    public void setTargets(List<Unit> targets) {
        UnitBox[] targetBoxes = this.targetBoxes;
        for (int i = 0; i < targets.size(); ++i) {
            targetBoxes[i].setUnit(targets.get(i));
        }
    }

    @Override
    public UnitBox getTargetBox(int index) {
        return this.targetBoxes[index];
    }

    @Override
    public List<Unit> getTargets() {
        ArrayList<Unit> targets = new ArrayList<Unit>();
        for (UnitBox element : this.targetBoxes) {
            targets.add(element.getUnit());
        }
        return targets;
    }
}

