/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import soot.AbstractJasminClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.UnitPrinter;
import soot.VoidType;
import soot.baf.internal.AbstractInst;

public abstract class AbstractInvokeInst
extends AbstractInst {
    SootMethodRef methodRef;

    public SootMethodRef getMethodRef() {
        return this.methodRef;
    }

    public SootMethod getMethod() {
        return this.methodRef.resolve();
    }

    public Type getType() {
        return this.methodRef.getReturnType();
    }

    @Override
    public String toString() {
        return this.getName() + this.getParameters();
    }

    @Override
    public abstract String getName();

    @Override
    String getParameters() {
        return " " + this.methodRef.getSignature();
    }

    @Override
    protected void getParameters(UnitPrinter up) {
        up.literal(" ");
        up.methodRef(this.methodRef);
    }

    @Override
    public int getInCount() {
        return this.getMethodRef().getParameterTypes().size();
    }

    @Override
    public int getOutCount() {
        return this.getMethodRef().getReturnType() instanceof VoidType ? 0 : 1;
    }

    @Override
    public int getInMachineCount() {
        int count = 0;
        for (Type t2 : this.getMethodRef().getParameterTypes()) {
            count += AbstractJasminClass.sizeOfType(t2);
        }
        return count;
    }

    @Override
    public int getOutMachineCount() {
        Type returnType = this.getMethodRef().getReturnType();
        return returnType instanceof VoidType ? 0 : AbstractJasminClass.sizeOfType(returnType);
    }

    @Override
    public boolean containsInvokeExpr() {
        return true;
    }
}

