/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.GotoStmt;
import soot.jimple.Jimple;
import soot.jimple.ReturnStmt;

public class CastAndReturnInliner
extends BodyTransformer {
    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        UnitPatchingChain units = body.getUnits();
        Iterator it = units.snapshotIterator();
        while (it.hasNext()) {
            ReturnStmt retStmt;
            AssignStmt assign;
            GotoStmt gtStmt;
            Unit u = (Unit)it.next();
            if (!(u instanceof GotoStmt) || !((gtStmt = (GotoStmt)u).getTarget() instanceof AssignStmt) || !((assign = (AssignStmt)gtStmt.getTarget()).getRightOp() instanceof CastExpr)) continue;
            CastExpr ce = (CastExpr)assign.getRightOp();
            AssignStmt nextStmt = units.getSuccOf(assign);
            if (!(nextStmt instanceof ReturnStmt) || (retStmt = (ReturnStmt)((Object)nextStmt)).getOp() != assign.getLeftOp()) continue;
            ReturnStmt newStmt = (ReturnStmt)retStmt.clone();
            Local a = (Local)ce.getOp();
            for (Trap t2 : body.getTraps()) {
                for (UnitBox ubox : t2.getUnitBoxes()) {
                    if (ubox.getUnit() != gtStmt) continue;
                    ubox.setUnit(newStmt);
                }
            }
            Jimple j = Jimple.v();
            Local n = j.newLocal(a.getName() + "_ret", ce.getCastType());
            body.getLocals().add(n);
            newStmt.setOp(n);
            List<UnitBox> boxesRefGtStmt = gtStmt.getBoxesPointingToThis();
            while (!boxesRefGtStmt.isEmpty()) {
                boxesRefGtStmt.get(0).setUnit(newStmt);
            }
            units.swapWith(gtStmt, newStmt);
            ce = (CastExpr)ce.clone();
            units.insertBefore(j.newAssignStmt(n, ce), newStmt);
        }
    }
}

