/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import com.google.common.base.Optional;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.ModuleRefType;
import soot.ModuleUtil;
import soot.RefLikeType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.Type;
import soot.Unit;
import soot.VoidType;
import soot.jimple.AssignStmt;

public class AsmUtil {
    private static final Logger logger = LoggerFactory.getLogger(AsmUtil.class);

    private static RefType makeRefType(String className, Optional<String> moduleName) {
        if (ModuleUtil.module_mode()) {
            return ModuleRefType.v(className, moduleName);
        }
        return RefType.v(className);
    }

    public static boolean isDWord(Type type) {
        return type instanceof LongType || type instanceof DoubleType;
    }

    public static Type toBaseType(String internal, Optional<String> moduleName) {
        if (internal.charAt(0) == '[') {
            internal = internal.substring(internal.lastIndexOf(91) + 1);
        }
        if (internal.charAt(internal.length() - 1) == ';') {
            if ((internal = internal.substring(0, internal.length() - 1)).charAt(0) == 'L') {
                internal = internal.substring(1);
            }
            internal = AsmUtil.toQualifiedName(internal);
            return AsmUtil.makeRefType(internal, moduleName);
        }
        switch (internal.charAt(0)) {
            case 'Z': {
                return BooleanType.v();
            }
            case 'B': {
                return ByteType.v();
            }
            case 'C': {
                return CharType.v();
            }
            case 'S': {
                return ShortType.v();
            }
            case 'I': {
                return IntType.v();
            }
            case 'F': {
                return FloatType.v();
            }
            case 'J': {
                return LongType.v();
            }
            case 'D': {
                return DoubleType.v();
            }
        }
        internal = AsmUtil.toQualifiedName(internal);
        return AsmUtil.makeRefType(internal, moduleName);
    }

    public static String toQualifiedName(String internal) {
        return internal.replace('/', '.');
    }

    public static String toInternalName(String qual) {
        return qual.replace('.', '/');
    }

    public static String toInternalName(SootClass cls) {
        return AsmUtil.toInternalName(cls.getName());
    }

    public static Type toJimpleRefType(String desc, Optional<String> moduleName) {
        return desc.charAt(0) == '[' ? AsmUtil.toJimpleType(desc, moduleName) : AsmUtil.makeRefType(AsmUtil.toQualifiedName(desc), moduleName);
    }

    public static Type toJimpleType(String desc, Optional<String> moduleName) {
        Type baseType;
        int idx = desc.lastIndexOf(91);
        int nrDims = idx + 1;
        if (nrDims > 0) {
            if (desc.charAt(0) != '[') {
                throw new AssertionError((Object)("Invalid array descriptor: " + desc));
            }
            desc = desc.substring(idx + 1);
        }
        switch (desc.charAt(0)) {
            case 'Z': {
                baseType = BooleanType.v();
                break;
            }
            case 'B': {
                baseType = ByteType.v();
                break;
            }
            case 'C': {
                baseType = CharType.v();
                break;
            }
            case 'S': {
                baseType = ShortType.v();
                break;
            }
            case 'I': {
                baseType = IntType.v();
                break;
            }
            case 'F': {
                baseType = FloatType.v();
                break;
            }
            case 'J': {
                baseType = LongType.v();
                break;
            }
            case 'D': {
                baseType = DoubleType.v();
                break;
            }
            case 'L': {
                if (desc.charAt(desc.length() - 1) != ';') {
                    throw new AssertionError((Object)("Invalid reference descriptor: " + desc));
                }
                String name = desc.substring(1, desc.length() - 1);
                name = AsmUtil.toQualifiedName(name);
                baseType = AsmUtil.makeRefType(name, moduleName);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown descriptor: " + desc));
            }
        }
        if (!(baseType instanceof RefLikeType) && desc.length() > 1) {
            throw new AssertionError((Object)("Invalid primitive type descriptor: " + desc));
        }
        return nrDims > 0 ? ArrayType.v(baseType, nrDims) : baseType;
    }

    public static List<Type> toJimpleDesc(String desc, Optional<String> moduleName) {
        ArrayList<Type> types = new ArrayList<Type>(2);
        int len = desc.length();
        int idx = 0;
        block14: while (idx != len) {
            int nrDims = 0;
            Type baseType = null;
            block15: while (idx != len) {
                char c = desc.charAt(idx++);
                switch (c) {
                    case '(': 
                    case ')': {
                        continue block14;
                    }
                    case '[': {
                        ++nrDims;
                        continue block15;
                    }
                    case 'Z': {
                        baseType = BooleanType.v();
                        break block15;
                    }
                    case 'B': {
                        baseType = ByteType.v();
                        break block15;
                    }
                    case 'C': {
                        baseType = CharType.v();
                        break block15;
                    }
                    case 'S': {
                        baseType = ShortType.v();
                        break block15;
                    }
                    case 'I': {
                        baseType = IntType.v();
                        break block15;
                    }
                    case 'F': {
                        baseType = FloatType.v();
                        break block15;
                    }
                    case 'J': {
                        baseType = LongType.v();
                        break block15;
                    }
                    case 'D': {
                        baseType = DoubleType.v();
                        break block15;
                    }
                    case 'V': {
                        baseType = VoidType.v();
                        break block15;
                    }
                    case 'L': {
                        int begin = idx;
                        while (desc.charAt(++idx) != ';') {
                        }
                        String cls = desc.substring(begin, idx++);
                        baseType = AsmUtil.makeRefType(AsmUtil.toQualifiedName(cls), moduleName);
                        break block15;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown type: " + c));
                    }
                }
            }
            if (baseType != null && nrDims > 0) {
                types.add(ArrayType.v(baseType, nrDims));
                continue;
            }
            types.add(baseType);
        }
        return types;
    }

    public static String baseTypeName(String s2) {
        int index = s2.indexOf("[");
        if (index < 0) {
            return s2;
        }
        return s2.substring(0, index);
    }

    private AsmUtil() {
    }

    public static int byteCodeToJavaVersion(int bytecodeVersion) {
        int javaVersion;
        switch (bytecodeVersion) {
            case 49: {
                javaVersion = 6;
                break;
            }
            case 50: {
                javaVersion = 7;
                break;
            }
            case 51: {
                javaVersion = 8;
                break;
            }
            case 52: {
                javaVersion = 9;
                break;
            }
            case 53: {
                javaVersion = 10;
                break;
            }
            case 54: {
                javaVersion = 11;
                break;
            }
            case 55: {
                javaVersion = 12;
                break;
            }
            case 56: {
                javaVersion = 13;
                break;
            }
            default: {
                javaVersion = 1;
            }
        }
        return javaVersion;
    }

    public static int javaToBytecodeVersion(int javaVersion) {
        int bytecodeVersion;
        switch (javaVersion) {
            case 2: {
                bytecodeVersion = 196653;
                break;
            }
            case 3: {
                bytecodeVersion = 46;
                break;
            }
            case 4: {
                bytecodeVersion = 47;
                break;
            }
            case 5: {
                bytecodeVersion = 48;
                break;
            }
            case 6: {
                bytecodeVersion = 49;
                break;
            }
            case 7: {
                bytecodeVersion = 50;
                break;
            }
            case 8: {
                bytecodeVersion = 51;
                break;
            }
            case 9: {
                bytecodeVersion = 52;
                break;
            }
            case 10: {
                bytecodeVersion = 53;
                break;
            }
            case 11: {
                bytecodeVersion = 54;
                break;
            }
            case 12: {
                bytecodeVersion = 55;
                break;
            }
            case 13: {
                bytecodeVersion = 56;
                break;
            }
            default: {
                bytecodeVersion = 51;
            }
        }
        return bytecodeVersion;
    }

    static boolean alreadyExists(Unit prev, Object left, Object right) {
        AssignStmt prevAsign;
        return prev instanceof AssignStmt && (prevAsign = (AssignStmt)prev).getLeftOp().equivTo(left) && prevAsign.getRightOp().equivTo(right);
    }

    public static Type[] jimpleTypesOfFieldOrMethodDescriptor(String descriptor) {
        Type[] ret = null;
        char[] d = descriptor.toCharArray();
        int p = 0;
        ArrayList<ByteType> conversionTypes = new ArrayList<ByteType>();
        block14: while (p < d.length) {
            boolean isArray = false;
            int numDimensions = 0;
            Type baseType = null;
            block15: while (p < d.length) {
                switch (d[p]) {
                    case '(': 
                    case ')': {
                        ++p;
                        continue block14;
                    }
                    case '[': {
                        isArray = true;
                        ++numDimensions;
                        ++p;
                        continue block15;
                    }
                    case 'B': {
                        baseType = ByteType.v();
                        ++p;
                        break block15;
                    }
                    case 'C': {
                        baseType = CharType.v();
                        ++p;
                        break block15;
                    }
                    case 'D': {
                        baseType = DoubleType.v();
                        ++p;
                        break block15;
                    }
                    case 'F': {
                        baseType = FloatType.v();
                        ++p;
                        break block15;
                    }
                    case 'I': {
                        baseType = IntType.v();
                        ++p;
                        break block15;
                    }
                    case 'J': {
                        baseType = LongType.v();
                        ++p;
                        break block15;
                    }
                    case 'L': {
                        int index;
                        for (index = p + 1; index < d.length && d[index] != ';'; ++index) {
                            if (d[index] != '/') continue;
                            d[index] = 46;
                        }
                        if (index >= d.length) {
                            throw new RuntimeException("Class reference has no ending ;");
                        }
                        String className = new String(d, p + 1, index - p - 1);
                        baseType = RefType.v(className);
                        p = index + 1;
                        break block15;
                    }
                    case 'S': {
                        baseType = ShortType.v();
                        ++p;
                        break block15;
                    }
                    case 'Z': {
                        baseType = BooleanType.v();
                        ++p;
                        break block15;
                    }
                    case 'V': {
                        baseType = VoidType.v();
                        ++p;
                        break block15;
                    }
                    default: {
                        throw new RuntimeException("Unknown field type!");
                    }
                }
            }
            if (baseType == null) continue;
            Type t2 = isArray ? ArrayType.v(baseType, numDimensions) : baseType;
            conversionTypes.add((ByteType)t2);
        }
        ret = conversionTypes.toArray(new Type[0]);
        return ret;
    }

    public static byte[] toUtf8(String s2) {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(s2.length());
            DataOutputStream d = new DataOutputStream(bs);
            d.writeUTF(s2);
            return bs.toByteArray();
        }
        catch (IOException e) {
            logger.debug("Some sort of IO exception in toUtf8 with " + s2);
            return null;
        }
    }
}

