/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import soot.PatchingChain;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.GotoStmt;
import soot.jimple.Jimple;
import soot.util.Chain;

public class UnitPatchingChain
extends PatchingChain<Unit> {
    public UnitPatchingChain(Chain<Unit> aChain) {
        super(aChain);
    }

    public void insertOnEdge(Collection<? extends Unit> toInsert, Unit point_src, Unit point_tgt) {
        if (toInsert == null) {
            throw new RuntimeException("Tried to insert a null Collection into the Chain!");
        }
        if (point_src == null && point_tgt == null) {
            throw new RuntimeException("insertOnEdge failed! Both source unit and target points are null.");
        }
        if (toInsert.isEmpty()) {
            return;
        }
        if (point_src == null) {
            assert (point_tgt != null);
            Unit firstInserted = toInsert.iterator().next();
            point_tgt.redirectJumpsToThisTo(firstInserted);
            this.innerChain.insertBefore(toInsert, point_tgt);
            return;
        }
        if (point_tgt == null) {
            assert (point_src != null);
            this.innerChain.insertAfter(toInsert, point_src);
            return;
        }
        if (this.getSuccOf(point_src) == point_tgt) {
            Unit firstInserted = toInsert.iterator().next();
            for (UnitBox box : point_src.getUnitBoxes()) {
                if (box.getUnit() != point_tgt) continue;
                box.setUnit(firstInserted);
            }
            this.innerChain.insertAfter(toInsert, point_src);
            return;
        }
        Unit firstInserted = toInsert.iterator().next();
        boolean validEdgeFound = false;
        Unit originalPred = this.getPredOf(point_tgt);
        for (UnitBox box : point_src.getUnitBoxes()) {
            if (box.getUnit() != point_tgt) continue;
            if (point_src instanceof GotoStmt) {
                box.setUnit(firstInserted);
                this.innerChain.insertAfter(toInsert, point_src);
                GotoStmt goto_unit = Jimple.v().newGotoStmt(point_tgt);
                if (toInsert instanceof List) {
                    List l = (List)toInsert;
                    this.innerChain.insertAfter(goto_unit, (Unit)l.get(l.size() - 1));
                } else {
                    this.innerChain.insertAfter(goto_unit, (Unit)toInsert.toArray()[toInsert.size() - 1]);
                }
                return;
            }
            box.setUnit(firstInserted);
            validEdgeFound = true;
        }
        if (validEdgeFound) {
            this.innerChain.insertBefore(toInsert, point_tgt);
            if (originalPred != point_src) {
                if (originalPred instanceof GotoStmt) {
                    return;
                }
                GotoStmt goto_unit = Jimple.v().newGotoStmt(point_tgt);
                this.innerChain.insertBefore(Collections.singletonList(goto_unit), firstInserted);
            }
            return;
        }
        Unit succ = this.getSuccOf(point_src);
        if (succ instanceof GotoStmt && succ.getUnitBoxes().get(0).getUnit() == point_tgt) {
            succ.redirectJumpsToThisTo(firstInserted);
            this.innerChain.insertBefore(toInsert, succ);
            return;
        }
        throw new RuntimeException("insertOnEdge failed! No such edge found. The edge on which you want to insert an instrumentation is invalid.");
    }

    public void insertOnEdge(List<Unit> toInsert, Unit point_src, Unit point_tgt) {
        this.insertOnEdge((Collection<? extends Unit>)toInsert, point_src, point_tgt);
    }

    public void insertOnEdge(Chain<Unit> toInsert, Unit point_src, Unit point_tgt) {
        this.insertOnEdge((Collection<? extends Unit>)toInsert, point_src, point_tgt);
    }

    public void insertOnEdge(Unit toInsert, Unit point_src, Unit point_tgt) {
        this.insertOnEdge(Collections.singleton(toInsert), point_src, point_tgt);
    }
}

