/*
 * Decompiled with CFR 0.152.
 */
package soot;

import soot.ShortType;
import soot.Type;
import soot.jimple.ConstantSwitch;
import soot.jimple.IntConstant;
import soot.util.Switch;

public class ShortConstant
extends IntConstant {
    private static final long serialVersionUID = 0L;
    private static final int MAX_CACHE = 128;
    private static final int MIN_CACHE = -127;
    private static final int ABS_MIN_CACHE = Math.abs(-127);
    private static final ShortConstant[] CACHED = new ShortConstant[129 + ABS_MIN_CACHE];

    public ShortConstant(short value) {
        super(value);
    }

    public ShortConstant(int value) {
        super((short)value);
    }

    public static ShortConstant v(int value) {
        if (value >= -127 && value <= 128) {
            int idx = value + ABS_MIN_CACHE;
            ShortConstant c = CACHED[idx];
            if (c != null) {
                return c;
            }
            ShortConstant.CACHED[idx] = c = new ShortConstant(value);
            return c;
        }
        return new ShortConstant(value);
    }

    public short getShort() {
        return (short)this.value;
    }

    @Override
    public Type getType() {
        return ShortType.v();
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseShortConstant(this);
    }
}

