/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.util.ArrayDeque;
import soot.AnySubType;
import soot.G;
import soot.ModuleRefType;
import soot.ModuleUtil;
import soot.RefLikeType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootResolver;
import soot.Type;
import soot.TypeSwitch;
import soot.UnknownType;
import soot.options.Options;
import soot.util.Switch;

public class RefType
extends RefLikeType
implements Comparable<RefType> {
    private String className;
    private AnySubType anySubType;
    protected volatile SootClass sootClass;

    public RefType(Singletons.Global g2) {
        this.className = "";
    }

    protected RefType(String className) {
        if (!className.isEmpty()) {
            if (className.charAt(0) == '[') {
                throw new RuntimeException("Attempt to create RefType whose name starts with [ --> " + className);
            }
            if (className.indexOf(47) >= 0) {
                throw new RuntimeException("Attempt to create RefType containing a / --> " + className);
            }
            if (className.indexOf(59) >= 0) {
                throw new RuntimeException("Attempt to create RefType containing a ; --> " + className);
            }
        }
        this.className = className;
    }

    public static RefType v() {
        G g2 = G.v();
        if (g2.soot_ModuleUtil().isInModuleMode()) {
            return g2.soot_ModuleRefType();
        }
        return g2.soot_RefType();
    }

    public static RefType v(String className) {
        if (ModuleUtil.module_mode()) {
            return ModuleRefType.v(className);
        }
        return Scene.v().getOrAddRefType(className);
    }

    public static RefType v(SootClass c) {
        if (ModuleUtil.module_mode()) {
            return ModuleRefType.v(c.getName(), Optional.fromNullable(c.moduleName));
        }
        return RefType.v(c.getName());
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public int compareTo(RefType t2) {
        return this.toString().compareTo(t2.toString());
    }

    public SootClass getSootClass() {
        if (this.sootClass == null) {
            this.sootClass = SootResolver.v().makeClassRef(this.className);
        }
        return this.sootClass;
    }

    public boolean hasSootClass() {
        return this.sootClass != null;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSootClass(SootClass sootClass) {
        this.sootClass = sootClass;
    }

    public boolean equals(Object t2) {
        return t2 instanceof RefType && this.className.equals(((RefType)t2).className);
    }

    @Override
    public String toString() {
        return this.className;
    }

    @Override
    public String toQuotedString() {
        return Scene.v().quotedNameOf(this.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    public void apply(Switch sw) {
        ((TypeSwitch)sw).caseRefType(this);
    }

    @Override
    public Type merge(Type other, Scene cm) {
        if (other.equals(UnknownType.v()) || this.equals(other)) {
            return this;
        }
        if (!(other instanceof RefType)) {
            throw new RuntimeException("illegal type merge: " + this + " and " + other);
        }
        SootClass javalangObject = cm.getObjectType().getSootClass();
        ArrayDeque<SootClass> thisHierarchy = new ArrayDeque<SootClass>();
        ArrayDeque<SootClass> otherHierarchy = new ArrayDeque<SootClass>();
        SootClass sc = cm.getSootClass(this.className);
        while (sc != null) {
            thisHierarchy.addFirst(sc);
            if (sc == javalangObject) break;
            if ((sc = sc.getSuperclassUnsafe()) != null) continue;
            sc = javalangObject;
        }
        sc = cm.getSootClass(((RefType)other).className);
        while (sc != null) {
            otherHierarchy.addFirst(sc);
            if (sc == javalangObject) break;
            if ((sc = sc.getSuperclassUnsafe()) != null) continue;
            sc = javalangObject;
        }
        SootClass commonClass = null;
        while (!otherHierarchy.isEmpty() && !thisHierarchy.isEmpty() && otherHierarchy.getFirst() == thisHierarchy.getFirst()) {
            commonClass = (SootClass)otherHierarchy.removeFirst();
            thisHierarchy.removeFirst();
        }
        if (commonClass == null) {
            throw new RuntimeException("Could not find a common superclass for " + this + " and " + other);
        }
        return commonClass.getType();
    }

    @Override
    public Type getArrayElementType() {
        if (Options.v().src_prec() == 7 && ("System.Object".equals(this.className) || "System.ICloneable".equals(this.className))) {
            return Scene.v().getObjectType();
        }
        if ("java.lang.Object".equals(this.className) || "java.io.Serializable".equals(this.className) || "java.io.Clonable".equals(this.className)) {
            return Scene.v().getObjectType();
        }
        throw new RuntimeException("Attempt to get array base type of a non-array");
    }

    public AnySubType getAnySubType() {
        return this.anySubType;
    }

    public void setAnySubType(AnySubType anySubType) {
        this.anySubType = anySubType;
    }

    @Override
    public boolean isAllowedInFinalCode() {
        return true;
    }
}

