/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.HasPhaseOptions;
import soot.PhaseOptions;
import soot.Transform;
import soot.options.Options;

public abstract class Pack
implements HasPhaseOptions,
Iterable<Transform> {
    private final List<Transform> opts = new ArrayList<Transform>();
    private final String name;

    @Override
    public String getPhaseName() {
        return this.name;
    }

    public Pack(String name) {
        this.name = name;
    }

    @Override
    public Iterator<Transform> iterator() {
        return this.opts.iterator();
    }

    public void add(Transform t2) {
        if (!t2.getPhaseName().startsWith(this.getPhaseName() + ".")) {
            throw new RuntimeException("Transforms in pack '" + this.getPhaseName() + "' must have a phase name that starts with '" + this.getPhaseName() + ".'.");
        }
        PhaseOptions.v().getPM().notifyAddPack();
        if (this.get(t2.getPhaseName()) != null) {
            throw new RuntimeException("Phase " + t2.getPhaseName() + " already in pack");
        }
        this.opts.add(t2);
    }

    public void insertAfter(Transform t2, String phaseName) {
        PhaseOptions.v().getPM().notifyAddPack();
        for (Transform tr : this.opts) {
            if (!tr.getPhaseName().equals(phaseName)) continue;
            this.opts.add(this.opts.indexOf(tr) + 1, t2);
            return;
        }
        throw new RuntimeException("phase " + phaseName + " not found!");
    }

    public void insertBefore(Transform t2, String phaseName) {
        PhaseOptions.v().getPM().notifyAddPack();
        for (Transform tr : this.opts) {
            if (!tr.getPhaseName().equals(phaseName)) continue;
            this.opts.add(this.opts.indexOf(tr), t2);
            return;
        }
        throw new RuntimeException("phase " + phaseName + " not found!");
    }

    public Transform get(String phaseName) {
        for (Transform tr : this.opts) {
            if (!tr.getPhaseName().equals(phaseName)) continue;
            return tr;
        }
        return null;
    }

    public boolean remove(String phaseName) {
        for (Transform tr : this.opts) {
            if (!tr.getPhaseName().equals(phaseName)) continue;
            this.opts.remove(tr);
            return true;
        }
        return false;
    }

    protected void internalApply() {
        throw new RuntimeException("wrong type of pack");
    }

    protected void internalApply(Body b) {
        throw new RuntimeException("wrong type of pack");
    }

    public final void apply() {
        Map<String, String> options = PhaseOptions.v().getPhaseOptions(this);
        if (!PhaseOptions.getBoolean(options, "enabled")) {
            return;
        }
        this.internalApply();
    }

    public final void apply(Body b) {
        Map<String, String> options = PhaseOptions.v().getPhaseOptions(this);
        if (!PhaseOptions.getBoolean(options, "enabled")) {
            return;
        }
        this.internalApply(b);
    }

    @Override
    public String getDeclaredOptions() {
        return Options.getDeclaredOptionsForPhase(this.getPhaseName());
    }

    @Override
    public String getDefaultOptions() {
        return Options.getDefaultOptionsForPhase(this.getPhaseName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(" { ");
        for (int i = 0; i < this.opts.size(); ++i) {
            sb.append(this.opts.get(i).getPhaseName());
            if (i < this.opts.size() - 1) {
                sb.append(",");
            }
            sb.append(" ");
        }
        sb.append(" }");
        return sb.toString();
    }
}

