/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LocalGenerator;
import soot.LongType;
import soot.MethodSource;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.VoidType;
import soot.asm.AsmUtil;
import soot.jimple.ClassConstant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.MethodHandle;
import soot.jimple.MethodType;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.tagkit.ArtificialEntityTag;
import soot.util.HashChain;

public class LambdaMetaFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LambdaMetaFactory.class);
    private final Wrapper wrapper = new Wrapper();
    private int uniq = 0;

    public LambdaMetaFactory(Singletons.Global g2) {
    }

    public static LambdaMetaFactory v() {
        return G.v().soot_LambdaMetaFactory();
    }

    public SootMethodRef makeLambdaHelper(List<? extends Value> bootstrapArgs, int tag, String name, Type[] invokedType, SootClass enclosingClass) {
        SootClass declClass;
        Value v;
        int i;
        int count;
        int argsSize = bootstrapArgs.size();
        if (argsSize < 3 || !(bootstrapArgs.get(0) instanceof MethodType) || !(bootstrapArgs.get(1) instanceof MethodHandle) || !(bootstrapArgs.get(2) instanceof MethodType) || argsSize > 3 && !(bootstrapArgs.get(3) instanceof IntConstant)) {
            LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.metaFactory: {}", (Object)bootstrapArgs);
            return null;
        }
        MethodType samMethodType = (MethodType)bootstrapArgs.get(0);
        MethodHandle implMethod = (MethodHandle)bootstrapArgs.get(1);
        this.resolveHandle(implMethod);
        MethodType instantiatedMethodType = (MethodType)bootstrapArgs.get(2);
        int flags = 0;
        if (argsSize > 3) {
            flags = ((IntConstant)bootstrapArgs.get((int)3)).value;
        }
        boolean serializable = flags & true;
        ArrayList<ClassConstant> markerInterfaces = new ArrayList<ClassConstant>();
        ArrayList<MethodType> bridges = new ArrayList<MethodType>();
        int va = 4;
        if ((flags & 2) != 0) {
            if (va == argsSize || !(bootstrapArgs.get(va) instanceof IntConstant)) {
                LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                return null;
            }
            count = ((IntConstant)bootstrapArgs.get((int)va++)).value;
            for (i = 0; i < count; ++i) {
                if (va >= argsSize) {
                    LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                    return null;
                }
                if (!((v = bootstrapArgs.get(va++)) instanceof ClassConstant)) {
                    LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                    return null;
                }
                markerInterfaces.add((ClassConstant)v);
            }
        }
        if ((flags & 4) != 0) {
            if (va == argsSize || !(bootstrapArgs.get(va) instanceof IntConstant)) {
                LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                return null;
            }
            count = ((IntConstant)bootstrapArgs.get((int)va++)).value;
            for (i = 0; i < count; ++i) {
                if (va >= argsSize) {
                    LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                    return null;
                }
                if (!((v = bootstrapArgs.get(va++)) instanceof MethodType)) {
                    LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                    return null;
                }
                bridges.add((MethodType)v);
            }
        }
        List<Type> capTypes = Arrays.asList(invokedType).subList(0, invokedType.length - 1);
        if (!(invokedType[invokedType.length - 1] instanceof RefType)) {
            LOGGER.warn("unexpected interface type: " + invokedType[invokedType.length - 1]);
            return null;
        }
        SootClass functionalInterfaceToImplement = ((RefType)invokedType[invokedType.length - 1]).getSootClass();
        String enclosingClassname = enclosingClass.getName();
        boolean readableClassnames = true;
        String implMethodName = implMethod.getMethodRef().getName();
        String dummyName = "<init>".equals(implMethodName) ? "init" : implMethodName;
        dummyName = dummyName.replace('$', '_');
        String prefix = enclosingClassname == null || enclosingClassname.isEmpty() ? "soot.dummy." : enclosingClassname + "$";
        String className = prefix + dummyName + "__" + this.uniqSupply();
        SootClass tclass = Scene.v().makeSootClass(className);
        tclass.setModifiers(17);
        tclass.setSuperclass(Scene.v().getObjectType().getSootClass());
        tclass.addInterface(functionalInterfaceToImplement);
        tclass.addTag(new ArtificialEntityTag());
        if (serializable) {
            tclass.addInterface(RefType.v("java.io.Serializable").getSootClass());
        }
        for (int i2 = 0; i2 < markerInterfaces.size(); ++i2) {
            String internal = ((ClassConstant)markerInterfaces.get(i2)).getValue();
            RefType refType = (RefType)AsmUtil.toBaseType(internal, Optional.fromNullable(tclass.moduleName));
            SootClass interfaceClass = refType.getSootClass();
            if (interfaceClass.equals(functionalInterfaceToImplement)) continue;
            tclass.addInterface(interfaceClass);
        }
        ArrayList<SootField> capFields = new ArrayList<SootField>(capTypes.size());
        int e = capTypes.size();
        for (int i3 = 0; i3 < e; ++i3) {
            SootField f = Scene.v().makeSootField("cap" + i3, capTypes.get(i3), 0);
            capFields.add(f);
            tclass.addField(f);
        }
        if (MethodHandle.Kind.REF_INVOKE_STATIC.getValue() == implMethod.getKind() && (declClass = implMethod.getMethodRef().getDeclaringClass()).getName().equals(enclosingClassname)) {
            SootMethod method = implMethod.getMethodRef().resolve();
            method.setModifiers(method.getModifiers() & 0xFFFFFFFD | 1);
        }
        ThunkMethodSource ms = new ThunkMethodSource(capFields, samMethodType, implMethod, instantiatedMethodType);
        SootMethod tboot = Scene.v().makeSootMethod("bootstrap$", capTypes, functionalInterfaceToImplement.getType(), 9);
        tclass.addMethod(tboot);
        tboot.setSource(ms);
        SootMethod tctor = Scene.v().makeSootMethod("<init>", capTypes, VoidType.v(), 1);
        tclass.addMethod(tctor);
        tctor.setSource(ms);
        this.addDispatch(name, tclass, samMethodType, instantiatedMethodType, capFields, implMethod);
        for (MethodType bridgeType : bridges) {
            this.addDispatch(name, tclass, bridgeType, instantiatedMethodType, capFields, implMethod);
        }
        for (SootMethod m4 : tclass.getMethods()) {
            m4.retrieveActiveBody();
        }
        this.addClassAndInvalidateHierarchy(tclass);
        if (enclosingClass.isApplicationClass()) {
            tclass.setApplicationClass();
        }
        return tboot.makeRef();
    }

    protected void addClassAndInvalidateHierarchy(SootClass tclass) {
        Scene.v().addClass(tclass);
        Scene.v().releaseFastHierarchy();
    }

    private synchronized void resolveHandle(MethodHandle implMethod) {
        Scene scene = Scene.v();
        SootMethodRef methodRef = implMethod.getMethodRef();
        scene.forceResolve(methodRef.getDeclaringClass().getName(), 1);
        Stream.concat(Stream.of(methodRef.getReturnType()), methodRef.getParameterTypes().stream()).filter(t2 -> t2 instanceof RefType).forEach(t2 -> scene.forceResolve(((RefType)t2).getSootClass().getName(), 1));
    }

    private void addDispatch(String name, SootClass tclass, MethodType implMethodType, MethodType instantiatedMethodType, List<SootField> capFields, MethodHandle implMethod) {
        ThunkMethodSource ms = new ThunkMethodSource(capFields, implMethodType, implMethod, instantiatedMethodType);
        SootMethod m4 = Scene.v().makeSootMethod(name, implMethodType.getParameterTypes(), implMethodType.getReturnType(), 1);
        tclass.addMethod(m4);
        m4.setSource(ms);
    }

    private synchronized long uniqSupply() {
        return ++this.uniq;
    }

    private class ThunkMethodSource
    implements MethodSource {
        private final List<SootField> capFields;
        private final MethodType implMethodType;
        private final MethodHandle implMethod;
        private final MethodType instantiatedMethodType;

        public ThunkMethodSource(List<SootField> capFields, MethodType implMethodType, MethodHandle implMethod, MethodType instantiatedMethodType) {
            this.capFields = capFields;
            this.implMethodType = implMethodType;
            this.implMethod = implMethod;
            this.instantiatedMethodType = instantiatedMethodType;
        }

        @Override
        public Body getBody(SootMethod m4, String phaseName) {
            if (!"jb".equals(phaseName)) {
                throw new Error("unsupported body type: " + phaseName);
            }
            SootClass tclass = m4.getDeclaringClass();
            JimpleBody jb = Jimple.v().newBody(m4);
            if (null != m4.getName()) {
                switch (m4.getName()) {
                    case "<init>": {
                        this.getInitBody(tclass, jb);
                        break;
                    }
                    case "bootstrap$": {
                        this.getBootstrapBody(tclass, jb);
                        break;
                    }
                    default: {
                        this.getInvokeBody(tclass, jb);
                    }
                }
            }
            LocalNameStandardizer.v().transform(jb, "jb.lns", PhaseOptions.v().getPhaseOptions("jb.lns"));
            return jb;
        }

        private void getInitBody(SootClass tclass, JimpleBody jb) {
            Jimple jimp = Jimple.v();
            UnitPatchingChain us = jb.getUnits();
            LocalGenerator lc = Scene.v().createLocalGenerator(jb);
            Local l = lc.generateLocal(tclass.getType());
            us.add(jimp.newIdentityStmt(l, jimp.newThisRef(tclass.getType())));
            HashChain<Local> capLocals = new HashChain<Local>();
            int i = 0;
            for (SootField f : this.capFields) {
                Local l2 = lc.generateLocal(f.getType());
                us.add(jimp.newIdentityStmt(l2, jimp.newParameterRef(f.getType(), i)));
                capLocals.add(l2);
                ++i;
            }
            us.add(jimp.newInvokeStmt(jimp.newSpecialInvokeExpr(l, Scene.v().makeConstructorRef(Scene.v().getObjectType().getSootClass(), Collections.emptyList()), Collections.emptyList())));
            Iterator localItr = capLocals.iterator();
            for (SootField f : this.capFields) {
                Local l2 = (Local)localItr.next();
                us.add(jimp.newAssignStmt(jimp.newInstanceFieldRef(l, f.makeRef()), l2));
            }
            us.add(jimp.newReturnVoidStmt());
        }

        private void getBootstrapBody(SootClass tclass, JimpleBody jb) {
            Jimple jimp = Jimple.v();
            UnitPatchingChain us = jb.getUnits();
            LocalGenerator lc = Scene.v().createLocalGenerator(jb);
            ArrayList<Local> capValues = new ArrayList<Local>();
            ArrayList<Type> capTypes = new ArrayList<Type>();
            int i = 0;
            for (SootField capField : this.capFields) {
                Type type = capField.getType();
                capTypes.add(type);
                Local p = lc.generateLocal(type);
                us.add(jimp.newIdentityStmt(p, jimp.newParameterRef(type, i)));
                capValues.add(p);
                ++i;
            }
            Local l = lc.generateLocal(tclass.getType());
            us.add(jimp.newAssignStmt(l, jimp.newNewExpr(tclass.getType())));
            us.add(jimp.newInvokeStmt(jimp.newSpecialInvokeExpr(l, Scene.v().makeConstructorRef(tclass, capTypes), capValues)));
            us.add(jimp.newReturnStmt(l));
        }

        private void getInvokeBody(SootClass tclass, JimpleBody jb) {
            Jimple jimp = Jimple.v();
            UnitPatchingChain us = jb.getUnits();
            LocalGenerator lc = Scene.v().createLocalGenerator(jb);
            Local this_ = lc.generateLocal(tclass.getType());
            us.add(jimp.newIdentityStmt(this_, jimp.newThisRef(tclass.getType())));
            HashChain<Object> samParamLocals = new HashChain<Object>();
            int i = 0;
            for (Type ty : this.implMethodType.getParameterTypes()) {
                Local l = lc.generateLocal(ty);
                us.add(jimp.newIdentityStmt(l, jimp.newParameterRef(ty, i)));
                samParamLocals.add(l);
                ++i;
            }
            Iterator<Type> iptItr = this.instantiatedMethodType.getParameterTypes().iterator();
            HashChain<Local> instParamLocals = new HashChain<Local>();
            for (Object l : samParamLocals) {
                Type ipt = iptItr.next();
                instParamLocals.add(this.narrowingReferenceConversion((Local)l, ipt, jb, us, lc));
            }
            ArrayList<Local> args = new ArrayList<Local>();
            for (SootField f : this.capFields) {
                Local l = lc.generateLocal(f.getType());
                us.add(jimp.newAssignStmt(l, jimp.newInstanceFieldRef(this_, f.makeRef())));
                args.add(l);
            }
            int kind = this.implMethod.getKind();
            boolean needsReceiver = false;
            if (MethodHandle.Kind.REF_INVOKE_INTERFACE.getValue() == kind || MethodHandle.Kind.REF_INVOKE_VIRTUAL.getValue() == kind || MethodHandle.Kind.REF_INVOKE_SPECIAL.getValue() == kind) {
                needsReceiver = true;
            }
            Iterator iplItr = instParamLocals.iterator();
            if (this.capFields.isEmpty() && iplItr.hasNext() && needsReceiver) {
                args.add(this.adapt((Local)iplItr.next(), this.implMethod.getMethodRef().getDeclaringClass().getType(), jb, us, lc));
            }
            int j = args.size();
            if (needsReceiver) {
                j = args.size() - 1;
            }
            while (iplItr.hasNext()) {
                Local pl = (Local)iplItr.next();
                args.add(this.adapt(pl, this.implMethod.getMethodRef().getParameterType(j), jb, us, lc));
                ++j;
            }
            this.invokeImplMethod(jb, us, lc, args);
        }

        private Local adapt(Local fromLocal, Type to, JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc) {
            Type from = fromLocal.getType();
            if (from.equals(to)) {
                return fromLocal;
            }
            if (from instanceof ArrayType || from instanceof RefType && to instanceof RefType) {
                return this.wideningReferenceConversion(fromLocal);
            }
            if (from instanceof PrimType) {
                if (to instanceof PrimType) {
                    return this.wideningPrimitiveConversion(fromLocal, to, jb, us, lc);
                }
                return this.wideningReferenceConversion(this.box(fromLocal, jb, us, lc));
            }
            if (!(to instanceof PrimType)) {
                throw new IllegalArgumentException("Expected 'to' to be a PrimType");
            }
            if (LambdaMetaFactory.this.wrapper.wrapperTypes.get(from) == null) {
                RefType boxedType = LambdaMetaFactory.this.wrapper.primitiveTypes.get((PrimType)to);
                Local castLocal = lc.generateLocal(boxedType);
                us.add(Jimple.v().newAssignStmt(castLocal, Jimple.v().newCastExpr(fromLocal, boxedType)));
                fromLocal = castLocal;
            }
            return this.wideningPrimitiveConversion(this.unbox(fromLocal, jb, us, lc), to, jb, us, lc);
        }

        private Local box(Local fromLocal, JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc) {
            PrimType primitiveType = (PrimType)fromLocal.getType();
            SootMethod valueOfMethod = LambdaMetaFactory.this.wrapper.valueOf.get(primitiveType);
            Local lBox = lc.generateLocal(primitiveType.boxedType());
            if (lBox == null || valueOfMethod == null || us == null) {
                throw new NullPointerException(String.format("%s,%s,%s,%s", valueOfMethod, primitiveType, LambdaMetaFactory.this.wrapper.valueOf.entrySet(), LambdaMetaFactory.this.wrapper.valueOf.get(primitiveType)));
            }
            us.add(Jimple.v().newAssignStmt(lBox, Jimple.v().newStaticInvokeExpr(valueOfMethod.makeRef(), (Value)fromLocal)));
            return lBox;
        }

        private Local unbox(Local fromLocal, JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc) {
            RefType wrapperType = (RefType)fromLocal.getType();
            Local lUnbox = lc.generateLocal(LambdaMetaFactory.this.wrapper.wrapperTypes.get(wrapperType));
            us.add(Jimple.v().newAssignStmt(lUnbox, Jimple.v().newVirtualInvokeExpr(fromLocal, LambdaMetaFactory.this.wrapper.primitiveValue.get(wrapperType).makeRef())));
            return lUnbox;
        }

        private Local wideningReferenceConversion(Local fromLocal) {
            return fromLocal;
        }

        private Local narrowingReferenceConversion(Local fromLocal, Type to, JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc) {
            Type fromTy = fromLocal.getType();
            if (fromTy.equals(to) || !(fromTy instanceof RefType) && !(fromTy instanceof ArrayType) || !(to instanceof RefType) && !(to instanceof ArrayType)) {
                return fromLocal;
            }
            Local l2 = lc.generateLocal(to);
            us.add(Jimple.v().newAssignStmt(l2, Jimple.v().newCastExpr(fromLocal, to)));
            return l2;
        }

        private Local wideningPrimitiveConversion(Local fromLocal, Type to, JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc) {
            if (!(fromLocal.getType() instanceof PrimType)) {
                throw new IllegalArgumentException("Expected source to have primitive type");
            }
            if (!(to instanceof PrimType)) {
                throw new IllegalArgumentException("Expected target to have primitive type");
            }
            Local l2 = lc.generateLocal(to);
            us.add(Jimple.v().newAssignStmt(l2, Jimple.v().newCastExpr(fromLocal, to)));
            return l2;
        }

        private void invokeImplMethod(JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc, List<Local> args) {
            Value value = this._invokeImplMethod(jb, us, lc, args);
            if (VoidType.v().equals(this.implMethodType.getReturnType())) {
                if (value instanceof InvokeExpr) {
                    us.add(Jimple.v().newInvokeStmt(value));
                }
                us.add(Jimple.v().newReturnVoidStmt());
            } else if (VoidType.v().equals(this.implMethod.getMethodRef().getReturnType())) {
                us.add(Jimple.v().newReturnStmt(value));
            } else {
                Local ret = lc.generateLocal(value.getType());
                us.add(Jimple.v().newAssignStmt(ret, value));
                us.add(Jimple.v().newReturnStmt(this.adapt(ret, this.implMethodType.getReturnType(), jb, us, lc)));
            }
        }

        private Value _invokeImplMethod(JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc, List<Local> args) {
            SootMethodRef methodRef = this.implMethod.getMethodRef();
            switch (MethodHandle.Kind.getKind(this.implMethod.getKind())) {
                case REF_INVOKE_STATIC: {
                    return Jimple.v().newStaticInvokeExpr(methodRef, args);
                }
                case REF_INVOKE_INTERFACE: {
                    return Jimple.v().newInterfaceInvokeExpr(args.get(0), methodRef, this.rest(args));
                }
                case REF_INVOKE_VIRTUAL: {
                    return Jimple.v().newVirtualInvokeExpr(args.get(0), methodRef, this.rest(args));
                }
                case REF_INVOKE_SPECIAL: {
                    SootClass currentClass = jb.getMethod().getDeclaringClass();
                    SootClass calledClass = methodRef.getDeclaringClass();
                    if (currentClass == calledClass || Scene.v().getOrMakeFastHierarchy().canStoreClass(currentClass.getSuperclass(), calledClass)) {
                        return Jimple.v().newSpecialInvokeExpr(args.get(0), methodRef, this.rest(args));
                    }
                    SootMethod m4 = this.implMethod.getMethodRef().resolve();
                    if (!m4.isPublic()) {
                        int mod = 1 | m4.getModifiers();
                        mod &= 0xFFFFFFFD;
                        m4.setModifiers(mod &= 0xFFFFFFFB);
                    }
                    if (methodRef.getDeclaringClass().isInterface()) {
                        return Jimple.v().newInterfaceInvokeExpr(args.get(0), methodRef, this.rest(args));
                    }
                    return Jimple.v().newVirtualInvokeExpr(args.get(0), methodRef, this.rest(args));
                }
                case REF_INVOKE_CONSTRUCTOR: {
                    Jimple jimp = Jimple.v();
                    RefType type = methodRef.getDeclaringClass().getType();
                    Local newLocal = lc.generateLocal(type);
                    us.add(jimp.newAssignStmt(newLocal, jimp.newNewExpr(type)));
                    us.add(jimp.newInvokeStmt(jimp.newSpecialInvokeExpr(newLocal, methodRef, args)));
                    return newLocal;
                }
            }
            throw new IllegalArgumentException("Unexpected MethodHandle.Kind " + this.implMethod.getKind());
        }

        private List<Local> rest(List<Local> args) {
            int first = 1;
            int last = args.size();
            if (last < first) {
                return Collections.emptyList();
            }
            return args.subList(first, last);
        }
    }

    private static class Wrapper {
        final Map<RefType, PrimType> wrapperTypes;
        final Map<PrimType, RefType> primitiveTypes;
        final Map<PrimType, SootMethod> valueOf;
        final Map<RefType, SootMethod> primitiveValue;

        public Wrapper() {
            PrimType[] primTypes;
            Scene sc = Scene.v();
            HashMap<RefType, PrimType> wrapperTypesTmp = new HashMap<RefType, PrimType>();
            HashMap<PrimType, RefType> primitiveTypesTmp = new HashMap<PrimType, RefType>();
            HashMap<PrimType, SootMethod> valueOfTmp = new HashMap<PrimType, SootMethod>();
            HashMap<RefType, SootMethod> primitiveValueTmp = new HashMap<RefType, SootMethod>();
            for (PrimType primTy : primTypes = new PrimType[]{BooleanType.v(), ByteType.v(), CharType.v(), DoubleType.v(), FloatType.v(), IntType.v(), LongType.v(), ShortType.v()}) {
                RefType wrapTy = primTy.boxedType();
                wrapperTypesTmp.put(wrapTy, primTy);
                primitiveTypesTmp.put(primTy, wrapTy);
                SootClass wrapCls = wrapTy.getSootClass();
                valueOfTmp.put(primTy, sc.makeMethodRef(wrapCls, "valueOf", Collections.singletonList(primTy), wrapTy, true).resolve());
                primitiveValueTmp.put(wrapTy, sc.makeMethodRef(wrapCls, primTy.toString() + "Value", Collections.emptyList(), primTy, false).resolve());
            }
            this.wrapperTypes = Collections.unmodifiableMap(wrapperTypesTmp);
            this.primitiveTypes = Collections.unmodifiableMap(primitiveTypesTmp);
            this.valueOf = Collections.unmodifiableMap(valueOfTmp);
            this.primitiveValue = Collections.unmodifiableMap(primitiveValueTmp);
        }
    }
}

