/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import soot.JastAddJ.PathPart;

public class ZipFilePart
extends PathPart {
    private Set<String> set = new HashSet<String>();
    private File file;

    @Override
    public boolean hasPackage(String name) {
        return this.set.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFilePart(File file) throws IOException {
        this.file = file;
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String pathName = new File(entry.getName()).getParent();
                if (pathName != null) {
                    pathName = pathName.replace(File.separatorChar, '.');
                }
                if (!this.set.contains(pathName)) {
                    int pos = 0;
                    while (pathName != null && -1 != (pos = pathName.indexOf(46, pos + 1))) {
                        String n = pathName.substring(0, pos);
                        if (this.set.contains(n)) continue;
                        this.set.add(n);
                    }
                    this.set.add(pathName);
                }
                this.set.add(entry.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean selectCompilationUnit(String canonicalName) throws IOException {
        ZipFile zipFile = null;
        boolean success = false;
        try {
            ZipEntry zipEntry;
            zipFile = new ZipFile(this.file);
            Object name = canonicalName.replace('.', '/');
            name = (String)name + this.fileSuffix();
            if (this.set.contains(name) && (zipEntry = zipFile.getEntry((String)name)) != null && !zipEntry.isDirectory()) {
                this.is = new ZipEntryInputStreamWrapper(zipFile, zipEntry);
                this.age = zipEntry.getTime();
                this.pathName = zipFile.getName();
                this.relativeName = (String)name + this.fileSuffix();
                this.fullName = canonicalName;
                success = true;
            }
        }
        finally {
            if (zipFile != null && !success) {
                zipFile.close();
            }
        }
        return success;
    }

    public static class ZipEntryInputStreamWrapper
    extends InputStream {
        private ZipFile zipFile;
        private InputStream entryInputStream;

        public ZipEntryInputStreamWrapper(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
            this.zipFile = zipFile;
            this.entryInputStream = zipFile.getInputStream(zipEntry);
        }

        @Override
        public int read() throws IOException {
            return this.entryInputStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.entryInputStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.entryInputStream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.entryInputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.entryInputStream.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.entryInputStream.close();
            }
            finally {
                if (this.zipFile != null) {
                    this.zipFile.close();
                    this.zipFile = null;
                }
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.entryInputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.entryInputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.entryInputStream.markSupported();
        }
    }
}

