/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.AssignSimpleExpr;
import soot.JastAddJ.Body;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.Constant;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.EnumConstant;
import soot.JastAddJ.EnumDecl;
import soot.JastAddJ.FieldDeclaration;
import soot.JastAddJ.InstanceInitializer;
import soot.JastAddJ.NameType;
import soot.JastAddJ.ParameterDeclaration;
import soot.JastAddJ.Program;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.StaticInitializer;
import soot.JastAddJ.SwitchStmt;
import soot.JastAddJ.TryStmt;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.JastAddJ.VariableDeclaration;
import soot.Local;
import soot.Scene;
import soot.SootFieldRef;
import soot.Type;
import soot.Value;

public class VarAccess
extends Access
implements Cloneable {
    protected String tokenString_ID;
    public int IDstart;
    public int IDend;
    protected int isConstant_visited = -1;
    protected boolean isConstant_computed = false;
    protected boolean isConstant_initialized = false;
    protected boolean isConstant_value;
    protected Map isDAafter_Variable_values;
    protected boolean decls_computed = false;
    protected SimpleSet decls_value;
    protected boolean decl_computed = false;
    protected Variable decl_value;
    protected boolean isFieldAccess_computed = false;
    protected boolean isFieldAccess_value;
    protected boolean type_computed = false;
    protected TypeDecl type_value;
    protected Map base_Body_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.isConstant_visited = -1;
        this.isConstant_computed = false;
        this.isConstant_initialized = false;
        this.isDAafter_Variable_values = null;
        this.decls_computed = false;
        this.decls_value = null;
        this.decl_computed = false;
        this.decl_value = null;
        this.isFieldAccess_computed = false;
        this.type_computed = false;
        this.type_value = null;
        this.base_Body_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public VarAccess clone() throws CloneNotSupportedException {
        VarAccess node = (VarAccess)super.clone();
        node.isConstant_visited = -1;
        node.isConstant_computed = false;
        node.isConstant_initialized = false;
        node.isDAafter_Variable_values = null;
        node.decls_computed = false;
        node.decls_value = null;
        node.decl_computed = false;
        node.decl_value = null;
        node.isFieldAccess_computed = false;
        node.type_computed = false;
        node.type_value = null;
        node.base_Body_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public VarAccess copy() {
        try {
            VarAccess node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public VarAccess fullCopy() {
        VarAccess tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void definiteAssignment() {
        Variable v;
        if (this.isSource()) {
            FieldDeclaration f;
            if (this.decl() instanceof VariableDeclaration) {
                v = (VariableDeclaration)this.decl();
                if (!((VariableDeclaration)v).isValue()) {
                    if (((VariableDeclaration)v).isBlankFinal()) {
                        if (!this.isDAbefore(v)) {
                            this.error("Final variable " + ((VariableDeclaration)v).name() + " is not assigned before used");
                        }
                    } else if (!this.isDAbefore(v)) {
                        this.error("Local variable " + ((VariableDeclaration)v).name() + " is not assigned before used");
                    }
                }
            } else if (this.decl() instanceof FieldDeclaration && !this.isQualified() && (f = (FieldDeclaration)this.decl()).isFinal() && !f.hasInit() && !this.isDAbefore(f)) {
                this.error("Final field " + f + " is not assigned before used");
            }
        }
        if (!this.isDest()) return;
        v = this.decl();
        if (v.isFinal() && v.isBlank() && !this.hostType().instanceOf(v.hostType())) {
            this.error("The final variable is not a blank final in this context, so it may not be assigned.");
            return;
        } else if (v.isFinal() && this.isQualified() && (!this.qualifier().isThisAccess() || ((Access)this.qualifier()).isQualified())) {
            this.error("the blank final field " + v.name() + " may only be assigned by simple name");
            return;
        } else {
            if (v instanceof VariableDeclaration) {
                VariableDeclaration var = (VariableDeclaration)v;
                if (!var.isValue() && var.getParent().getParent().getParent() instanceof SwitchStmt && var.isFinal()) {
                    if (!this.isDUbefore(var)) {
                        this.error("Final variable " + var.name() + " may only be assigned once");
                    }
                } else if (var.isValue()) {
                    if (var.hasInit() || !this.isDUbefore(var)) {
                        this.error("Final variable " + var.name() + " may only be assigned once");
                    }
                } else if (var.isBlankFinal() && (var.hasInit() || !this.isDUbefore(var))) {
                    this.error("Final variable " + var.name() + " may only be assigned once");
                }
                if (var.isFinal() && !var.hasInit() && this.isDUbefore(var)) return;
            }
            if (v instanceof FieldDeclaration) {
                FieldDeclaration f = (FieldDeclaration)v;
                if (!f.isFinal()) return;
                if (f.hasInit()) {
                    this.error("initialized field " + f.name() + " can not be assigned");
                    return;
                } else {
                    BodyDecl bodyDecl = this.enclosingBodyDecl();
                    if (!(bodyDecl instanceof ConstructorDecl || bodyDecl instanceof InstanceInitializer || bodyDecl instanceof StaticInitializer || bodyDecl instanceof FieldDeclaration)) {
                        this.error("final field " + f.name() + " may only be assigned in constructors and initializers");
                        return;
                    } else {
                        if (this.isDUbefore(f)) return;
                        this.error("Final field " + f.name() + " may only be assigned once");
                    }
                }
                return;
            } else {
                if (!v.isParameter() || !v.isFinal()) return;
                this.error("Final parameter " + v.name() + " may not be assigned");
            }
        }
    }

    @Override
    protected boolean checkDUeverywhere(Variable v) {
        if (this.isDest() && this.decl() == v) {
            return false;
        }
        return super.checkDUeverywhere(v);
    }

    @Override
    public void nameCheck() {
        Variable v;
        if (this.decls().isEmpty() && (!this.isQualified() || !this.qualifier().type().isUnknown() || this.qualifier().isPackageAccess())) {
            this.error("no field named " + this.name() + " is accessible");
        }
        if (this.decls().size() > 1) {
            StringBuffer s2 = new StringBuffer();
            s2.append("several fields named " + this.name());
            Iterator iter = this.decls().iterator();
            while (iter.hasNext()) {
                Variable v2 = (Variable)iter.next();
                s2.append("\n    " + v2.type().typeName() + "." + v2.name() + " declared in " + v2.hostType().typeName());
            }
            this.error(s2.toString());
        }
        if (this.inExplicitConstructorInvocation() && !this.isQualified() && this.decl().isInstanceVariable() && this.hostType() == this.decl().hostType()) {
            this.error("instance variable " + this.name() + " may not be accessed in an explicit constructor invocation");
        }
        if (!((v = this.decl()).isFinal() || v.isClassVariable() || v.isInstanceVariable() || v.hostType() == this.hostType())) {
            this.error("A parameter/variable used but not declared in an inner class must be declared final");
        }
        if ((this.decl().isInstanceVariable() || this.decl().isClassVariable()) && !this.isQualified() && this.hostType() != null && !this.hostType().declaredBeforeUse(this.decl(), this) && this.inSameInitializer() && !this.simpleAssignment() && this.inDeclaringClass()) {
            BodyDecl b = this.closestBodyDecl(this.hostType());
            this.error("variable " + this.decl().name() + " is used in " + b + " before it is declared");
        }
    }

    public BodyDecl closestBodyDecl(TypeDecl t2) {
        ASTNode node = this;
        while (!(node.getParent().getParent() instanceof Program) && node.getParent().getParent() != t2) {
            node = node.getParent();
        }
        if (node instanceof BodyDecl) {
            return (BodyDecl)node;
        }
        return null;
    }

    public VarAccess(String name, int start, int end) {
        this(name);
        this.start = this.IDstart = start;
        this.end = this.IDend = end;
    }

    @Override
    public void toString(StringBuffer s2) {
        s2.append(this.name());
    }

    @Override
    public void checkModifiers() {
        FieldDeclaration f;
        if (this.decl() instanceof FieldDeclaration && (f = (FieldDeclaration)this.decl()).isDeprecated() && !this.withinDeprecatedAnnotation() && this.hostType().topLevelType() != f.hostType().topLevelType() && !this.withinSuppressWarnings("deprecation")) {
            this.warning(f.name() + " in " + f.hostType().typeName() + " has been deprecated");
        }
    }

    @Override
    protected void checkEnum(EnumDecl enumDecl) {
        super.checkEnum(enumDecl);
        if (this.decl().isStatic() && this.decl().hostType() == enumDecl && !this.isConstant()) {
            this.error("may not reference a static field of an enum type from here");
        }
    }

    private TypeDecl refined_InnerClasses_VarAccess_fieldQualifierType() {
        TypeDecl typeDecl;
        if (this.hasPrevExpr()) {
            return this.prevExpr().type();
        }
        for (typeDecl = this.hostType(); typeDecl != null && !typeDecl.hasField(this.name()); typeDecl = typeDecl.enclosingType()) {
        }
        if (typeDecl != null) {
            return typeDecl;
        }
        return this.decl().hostType();
    }

    @Override
    public void collectEnclosingVariables(HashSet set, TypeDecl typeDecl) {
        Variable v = this.decl();
        if (!v.isInstanceVariable() && !v.isClassVariable() && v.hostType() == typeDecl) {
            set.add(v);
        }
        super.collectEnclosingVariables(set, typeDecl);
    }

    @Override
    public void transformation() {
        Variable v = this.decl();
        if (v instanceof FieldDeclaration) {
            FieldDeclaration f = (FieldDeclaration)v;
            if (this.requiresAccessor()) {
                TypeDecl typeDecl = this.fieldQualifierType();
                if (this.isSource()) {
                    f.createAccessor(typeDecl);
                }
                if (this.isDest()) {
                    f.createAccessorWrite(typeDecl);
                }
            }
        }
        super.transformation();
    }

    public Value refined_Expressions_VarAccess_eval(Body b) {
        Variable v = this.decl();
        if (v instanceof VariableDeclaration) {
            VariableDeclaration decl = (VariableDeclaration)v;
            if (decl.hostType() == this.hostType()) {
                return decl.local;
            }
            return this.emitLoadLocalInNestedClass(b, decl);
        }
        if (v instanceof ParameterDeclaration) {
            ParameterDeclaration decl = (ParameterDeclaration)v;
            if (decl.hostType() == this.hostType()) {
                return decl.local;
            }
            return this.emitLoadLocalInNestedClass(b, decl);
        }
        if (v instanceof FieldDeclaration) {
            FieldDeclaration f = (FieldDeclaration)v;
            if (f.hostType().isArrayDecl() && f.name().equals("length")) {
                return b.newLengthExpr(this.asImmediate(b, this.createLoadQualifier(b)), this);
            }
            if (f.isStatic()) {
                if (this.isQualified() && !this.qualifier().isTypeAccess()) {
                    b.newTemp(this.qualifier().eval(b));
                }
                if (this.requiresAccessor()) {
                    ArrayList list = new ArrayList();
                    return b.newStaticInvokeExpr(f.createAccessor(this.fieldQualifierType()).sootRef(), list, (ASTNode)this);
                }
                return b.newStaticFieldRef(this.sootRef(), this);
            }
            if (this.requiresAccessor()) {
                Local base = this.base(b);
                ArrayList<Local> list = new ArrayList<Local>();
                list.add(base);
                return b.newStaticInvokeExpr(f.createAccessor(this.fieldQualifierType()).sootRef(), list, (ASTNode)this);
            }
            Local base = this.createLoadQualifier(b);
            return b.newInstanceFieldRef(base, this.sootRef(), this);
        }
        return super.eval(b);
    }

    public Value refined_Expressions_VarAccess_emitStore(Body b, Value lvalue, Value rvalue, ASTNode location) {
        Variable v = this.decl();
        if (v instanceof FieldDeclaration) {
            FieldDeclaration f = (FieldDeclaration)v;
            if (this.requiresAccessor()) {
                if (f.isStatic()) {
                    ArrayList<Value> list = new ArrayList<Value>();
                    list.add(rvalue);
                    return this.asLocal(b, b.newStaticInvokeExpr(f.createAccessorWrite(this.fieldQualifierType()).sootRef(), list, location));
                }
                Local base = this.base(b);
                ArrayList<Local> list = new ArrayList<Local>();
                list.add(base);
                list.add(this.asLocal(b, rvalue, lvalue.getType()));
                return this.asLocal(b, b.newStaticInvokeExpr(f.createAccessorWrite(this.fieldQualifierType()).sootRef(), list, location));
            }
        }
        return super.emitStore(b, lvalue, rvalue, location);
    }

    @Override
    public void collectTypesToSignatures(Collection<Type> set) {
        super.collectTypesToSignatures(set);
        if (this.decl() instanceof FieldDeclaration) {
            this.addDependencyIfNeeded(set, this.fieldQualifierType());
        }
    }

    public VarAccess() {
    }

    @Override
    public void init$Children() {
    }

    public VarAccess(String p0) {
        this.setID(p0);
    }

    public VarAccess(Symbol p0) {
        this.setID(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setID(String value) {
        this.tokenString_ID = value;
    }

    public void setID(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol2.value;
        this.IDstart = symbol2.getStart();
        this.IDend = symbol2.getEnd();
    }

    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    protected TypeDecl refined_GenericsCodegen_VarAccess_fieldQualifierType() {
        TypeDecl typeDecl = this.refined_InnerClasses_VarAccess_fieldQualifierType();
        return typeDecl == null ? null : typeDecl.erasure();
    }

    @Override
    public Value eval(Body b) {
        Variable v = this.decl();
        if (v instanceof FieldDeclaration) {
            Value result;
            FieldDeclaration f = ((FieldDeclaration)v).erasedField();
            if (f.hostType().isArrayDecl() && f.name().equals("length")) {
                return b.newLengthExpr(this.asImmediate(b, this.createLoadQualifier(b)), this);
            }
            if (f.isStatic()) {
                if (this.isQualified() && !this.qualifier().isTypeAccess()) {
                    b.newTemp(this.qualifier().eval(b));
                }
                if (this.requiresAccessor()) {
                    ArrayList list = new ArrayList();
                    result = b.newStaticInvokeExpr(f.createAccessor(this.fieldQualifierType().erasure()).sootRef(), list, (ASTNode)this);
                } else {
                    result = b.newStaticFieldRef(this.sootRef(), this);
                }
            } else if (this.requiresAccessor()) {
                Local base = this.base(b);
                ArrayList<Local> list = new ArrayList<Local>();
                list.add(base);
                result = b.newStaticInvokeExpr(f.createAccessor(this.fieldQualifierType().erasure()).sootRef(), list, (ASTNode)this);
            } else {
                Local base = this.createLoadQualifier(b);
                result = b.newInstanceFieldRef(base, this.sootRef(), this);
            }
            if (f.type() != v.type()) {
                result = f.type().emitCastTo(b, result, v.type(), this);
            }
            return result;
        }
        return this.refined_Expressions_VarAccess_eval(b);
    }

    private SootFieldRef sootRef() {
        FieldDeclaration decl = ((FieldDeclaration)this.decl()).erasedField();
        SootFieldRef ref = Scene.v().makeFieldRef(this.fieldQualifierType().getSootClassDecl(), decl.name(), decl.type().getSootType(), decl.isStatic());
        return ref;
    }

    @Override
    public Value emitStore(Body b, Value lvalue, Value rvalue, ASTNode location) {
        Variable v = this.decl();
        if (v instanceof FieldDeclaration) {
            FieldDeclaration f = ((FieldDeclaration)v).erasedField();
            if (this.requiresAccessor()) {
                if (f.isStatic()) {
                    ArrayList<Value> list = new ArrayList<Value>();
                    list.add(rvalue);
                    return this.asLocal(b, b.newStaticInvokeExpr(f.createAccessorWrite(this.fieldQualifierType().erasure()).sootRef(), list, (ASTNode)this));
                }
                Local base = this.base(b);
                ArrayList<Local> list = new ArrayList<Local>();
                list.add(base);
                list.add(this.asLocal(b, rvalue, lvalue.getType()));
                return this.asLocal(b, b.newStaticInvokeExpr(f.createAccessorWrite(this.fieldQualifierType().erasure()).sootRef(), list, (ASTNode)this));
            }
        }
        return this.refined_Expressions_VarAccess_emitStore(b, lvalue, rvalue, location);
    }

    public Local createLoadQualifier(Body b) {
        Variable v = this.decl();
        if (v instanceof FieldDeclaration) {
            FieldDeclaration f = ((FieldDeclaration)v).erasedField();
            if (this.hasPrevExpr()) {
                Local qualifier = this.asLocal(b, this.prevExpr().eval(b));
                return qualifier;
            }
            if (f.isInstanceVariable()) {
                return this.emitThis(b, this.fieldQualifierType().erasure());
            }
        }
        throw new Error("createLoadQualifier not supported for " + v.getClass().getName());
    }

    protected TypeDecl fieldQualifierType() {
        TypeDecl typeDecl = this.refined_GenericsCodegen_VarAccess_fieldQualifierType();
        if (typeDecl != null) {
            return typeDecl;
        }
        return this.decl().hostType();
    }

    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        return this.type().cast(this.decl().getInit().constant());
    }

    @Override
    public boolean isConstant() {
        if (this.isConstant_computed) {
            return this.isConstant_value;
        }
        ASTNode$State state = this.state();
        if (!this.isConstant_initialized) {
            this.isConstant_initialized = true;
            this.isConstant_value = false;
        }
        if (!state.IN_CIRCLE) {
            state.IN_CIRCLE = true;
            int num = state.boundariesCrossed;
            boolean isFinal = this.is$Final();
            do {
                this.isConstant_visited = state.CIRCLE_INDEX;
                state.CHANGE = false;
                boolean new_isConstant_value = this.isConstant_compute();
                if (new_isConstant_value != this.isConstant_value) {
                    state.CHANGE = true;
                }
                this.isConstant_value = new_isConstant_value;
                ++state.CIRCLE_INDEX;
            } while (state.CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.isConstant_computed = true;
            } else {
                state.RESET_CYCLE = true;
                this.isConstant_compute();
                state.RESET_CYCLE = false;
                this.isConstant_computed = false;
                this.isConstant_initialized = false;
            }
            state.IN_CIRCLE = false;
            return this.isConstant_value;
        }
        if (this.isConstant_visited != state.CIRCLE_INDEX) {
            this.isConstant_visited = state.CIRCLE_INDEX;
            if (state.RESET_CYCLE) {
                this.isConstant_computed = false;
                this.isConstant_initialized = false;
                this.isConstant_visited = -1;
                return this.isConstant_value;
            }
            boolean new_isConstant_value = this.isConstant_compute();
            if (new_isConstant_value != this.isConstant_value) {
                state.CHANGE = true;
            }
            this.isConstant_value = new_isConstant_value;
            return this.isConstant_value;
        }
        return this.isConstant_value;
    }

    private boolean isConstant_compute() {
        Variable v = this.decl();
        if (v instanceof FieldDeclaration) {
            FieldDeclaration f = (FieldDeclaration)v;
            return f.isConstant() && (!this.isQualified() || this.isQualified() && this.qualifier().isTypeAccess());
        }
        boolean result = v.isFinal() && v.hasInit() && v.getInit().isConstant() && (v.type().isPrimitive() || v.type().isString());
        return result && (!this.isQualified() || this.isQualified() && this.qualifier().isTypeAccess());
    }

    @Override
    public Variable varDecl() {
        ASTNode$State state = this.state();
        return this.decl();
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.isDAbefore(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        return this.isDUbefore(v);
    }

    @Override
    public boolean unassignedEverywhere(Variable v, TryStmt stmt) {
        ASTNode$State state = this.state();
        if (this.isDest() && this.decl() == v && this.enclosingStmt().reachable()) {
            return false;
        }
        return super.unassignedEverywhere(v, stmt);
    }

    public SimpleSet decls() {
        if (this.decls_computed) {
            return this.decls_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decls_value = this.decls_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decls_computed = true;
        }
        return this.decls_value;
    }

    private SimpleSet decls_compute() {
        SimpleSet set = this.lookupVariable(this.name());
        if (set.size() == 1) {
            Variable v = (Variable)set.iterator().next();
            if (!this.isQualified() && this.inStaticContext() ? v.isInstanceVariable() && !this.hostType().memberFields(v.name()).isEmpty() : this.isQualified() && this.qualifier().staticContextQualifier() && v.isInstanceVariable()) {
                return SimpleSet.emptySet;
            }
        }
        return set;
    }

    public Variable decl() {
        if (this.decl_computed) {
            return this.decl_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decl_value = this.decl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decl_computed = true;
        }
        return this.decl_value;
    }

    private Variable decl_compute() {
        SimpleSet decls = this.decls();
        if (decls.size() == 1) {
            return (Variable)decls.iterator().next();
        }
        return this.unknownField();
    }

    public boolean inSameInitializer() {
        ASTNode$State state = this.state();
        BodyDecl b = this.closestBodyDecl(this.decl().hostType());
        if (b == null) {
            return false;
        }
        if (b instanceof FieldDeclaration && ((FieldDeclaration)b).isStatic() == this.decl().isStatic()) {
            return true;
        }
        if (b instanceof InstanceInitializer && !this.decl().isStatic()) {
            return true;
        }
        return b instanceof StaticInitializer && this.decl().isStatic();
    }

    public boolean simpleAssignment() {
        ASTNode$State state = this.state();
        return this.isDest() && this.getParent() instanceof AssignSimpleExpr;
    }

    public boolean inDeclaringClass() {
        ASTNode$State state = this.state();
        return this.hostType() == this.decl().hostType();
    }

    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        return this.getClass().getName() + " [" + this.getID() + "]";
    }

    public String name() {
        ASTNode$State state = this.state();
        return this.getID();
    }

    @Override
    public boolean isFieldAccess() {
        if (this.isFieldAccess_computed) {
            return this.isFieldAccess_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isFieldAccess_value = this.isFieldAccess_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isFieldAccess_computed = true;
        }
        return this.isFieldAccess_value;
    }

    private boolean isFieldAccess_compute() {
        return this.decl().isClassVariable() || this.decl().isInstanceVariable();
    }

    @Override
    public NameType predNameType() {
        ASTNode$State state = this.state();
        return NameType.AMBIGUOUS_NAME;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.decl().type();
    }

    @Override
    public boolean isVariable() {
        ASTNode$State state = this.state();
        return true;
    }

    @Override
    public boolean isEnumConstant() {
        ASTNode$State state = this.state();
        return this.varDecl() instanceof EnumConstant;
    }

    public boolean requiresAccessor() {
        ASTNode$State state = this.state();
        Variable v = this.decl();
        if (!(v instanceof FieldDeclaration)) {
            return false;
        }
        FieldDeclaration f = (FieldDeclaration)v;
        if (f.isPrivate() && !this.hostType().hasField(v.name())) {
            return true;
        }
        return f.isProtected() && !f.hostPackage().equals(this.hostPackage()) && !this.hostType().hasField(v.name());
    }

    public Local base(Body b) {
        Body _parameters = b;
        if (this.base_Body_values == null) {
            this.base_Body_values = new HashMap(4);
        }
        if (this.base_Body_values.containsKey(_parameters)) {
            return (Local)this.base_Body_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        Local base_Body_value = this.base_compute(b);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.base_Body_values.put(_parameters, base_Body_value);
        }
        return base_Body_value;
    }

    private Local base_compute(Body b) {
        return this.asLocal(b, this.createLoadQualifier(b));
    }

    @Override
    public Collection<TypeDecl> throwTypes() {
        ASTNode$State state = this.state();
        return this.decl().throwTypes();
    }

    @Override
    public boolean isVariable(Variable var) {
        ASTNode$State state = this.state();
        return this.decl() == var;
    }

    @Override
    public boolean inExplicitConstructorInvocation() {
        ASTNode$State state = this.state();
        boolean inExplicitConstructorInvocation_value = this.getParent().Define_boolean_inExplicitConstructorInvocation(this, null);
        return inExplicitConstructorInvocation_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

