/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.Annotation;
import soot.JastAddJ.Block;
import soot.JastAddJ.Body;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.ClassDecl;
import soot.JastAddJ.ConstructorAccess;
import soot.JastAddJ.ConstructorDeclSubstituted;
import soot.JastAddJ.Expr;
import soot.JastAddJ.ExprStmt;
import soot.JastAddJ.FieldDeclaration;
import soot.JastAddJ.InstanceInitializer;
import soot.JastAddJ.List;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.Modifier;
import soot.JastAddJ.Modifiers;
import soot.JastAddJ.NameType;
import soot.JastAddJ.Opt;
import soot.JastAddJ.ParameterDeclaration;
import soot.JastAddJ.Parameterization;
import soot.JastAddJ.ReturnStmt;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.Stmt;
import soot.JastAddJ.SuperConstructorAccess;
import soot.JastAddJ.TypeAccess;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.VarAccess;
import soot.JastAddJ.Variable;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.VoidType;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.tagkit.AnnotationTag;
import soot.tagkit.ParamNamesTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;

public class ConstructorDecl
extends BodyDecl
implements Cloneable {
    private boolean isDefaultConstructor = false;
    protected boolean addEnclosingVariables = true;
    public SootMethod sootMethod;
    protected String tokenString_ID;
    public int IDstart;
    public int IDend;
    protected Map accessibleFrom_TypeDecl_values;
    protected Map isDAafter_Variable_values;
    protected Map isDUafter_Variable_values;
    protected Map throwsException_TypeDecl_values;
    protected boolean name_computed = false;
    protected String name_value;
    protected boolean signature_computed = false;
    protected String signature_value;
    protected Map sameSignature_ConstructorDecl_values;
    protected Map moreSpecificThan_ConstructorDecl_values;
    protected Map parameterDeclaration_String_values;
    protected Map circularThisInvocation_ConstructorDecl_values;
    protected boolean sourceConstructorDecl_computed = false;
    protected ConstructorDecl sourceConstructorDecl_value;
    protected boolean sootMethod_computed = false;
    protected SootMethod sootMethod_value;
    protected boolean sootRef_computed = false;
    protected SootMethodRef sootRef_value;
    protected boolean localNumOfFirstParameter_computed = false;
    protected int localNumOfFirstParameter_value;
    protected boolean offsetFirstEnclosingVariable_computed = false;
    protected int offsetFirstEnclosingVariable_value;
    protected Map handlesException_TypeDecl_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.accessibleFrom_TypeDecl_values = null;
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.throwsException_TypeDecl_values = null;
        this.name_computed = false;
        this.name_value = null;
        this.signature_computed = false;
        this.signature_value = null;
        this.sameSignature_ConstructorDecl_values = null;
        this.moreSpecificThan_ConstructorDecl_values = null;
        this.parameterDeclaration_String_values = null;
        this.circularThisInvocation_ConstructorDecl_values = null;
        this.sourceConstructorDecl_computed = false;
        this.sourceConstructorDecl_value = null;
        this.sootMethod_computed = false;
        this.sootMethod_value = null;
        this.sootRef_computed = false;
        this.sootRef_value = null;
        this.localNumOfFirstParameter_computed = false;
        this.offsetFirstEnclosingVariable_computed = false;
        this.handlesException_TypeDecl_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ConstructorDecl clone() throws CloneNotSupportedException {
        ConstructorDecl node = (ConstructorDecl)super.clone();
        node.accessibleFrom_TypeDecl_values = null;
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.throwsException_TypeDecl_values = null;
        node.name_computed = false;
        node.name_value = null;
        node.signature_computed = false;
        node.signature_value = null;
        node.sameSignature_ConstructorDecl_values = null;
        node.moreSpecificThan_ConstructorDecl_values = null;
        node.parameterDeclaration_String_values = null;
        node.circularThisInvocation_ConstructorDecl_values = null;
        node.sourceConstructorDecl_computed = false;
        node.sourceConstructorDecl_value = null;
        node.sootMethod_computed = false;
        node.sootMethod_value = null;
        node.sootRef_computed = false;
        node.sootRef_value = null;
        node.localNumOfFirstParameter_computed = false;
        node.offsetFirstEnclosingVariable_computed = false;
        node.handlesException_TypeDecl_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ConstructorDecl copy() {
        try {
            ConstructorDecl node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public ConstructorDecl fullCopy() {
        ConstructorDecl tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public boolean applicable(List argList) {
        if (this.getNumParameter() != argList.getNumChild()) {
            return false;
        }
        for (int i = 0; i < this.getNumParameter(); ++i) {
            TypeDecl parameter;
            TypeDecl arg = ((Expr)argList.getChild(i)).type();
            if (arg.instanceOf(parameter = this.getParameter(i).type())) continue;
            return false;
        }
        return true;
    }

    public void setDefaultConstructor() {
        this.isDefaultConstructor = true;
    }

    @Override
    public void checkModifiers() {
        super.checkModifiers();
    }

    @Override
    public void nameCheck() {
        super.nameCheck();
        if (!this.hostType().name().equals(this.name())) {
            this.error("constructor " + this.name() + " does not have the same name as the simple name of the host class " + this.hostType().name());
        }
        if (this.hostType().lookupConstructor(this) != this) {
            this.error("constructor with signature " + this.signature() + " is multiply declared in type " + this.hostType().typeName());
        }
        if (this.circularThisInvocation(this)) {
            this.error("The constructor " + this.signature() + " may not directly or indirectly invoke itself");
        }
    }

    @Override
    public void toString(StringBuffer s2) {
        int i;
        if (this.isDefaultConstructor()) {
            return;
        }
        s2.append(this.indent());
        this.getModifiers().toString(s2);
        s2.append(this.name() + "(");
        if (this.getNumParameter() > 0) {
            this.getParameter(0).toString(s2);
            for (i = 1; i < this.getNumParameter(); ++i) {
                s2.append(", ");
                this.getParameter(i).toString(s2);
            }
        }
        s2.append(")");
        if (this.getNumException() > 0) {
            s2.append(" throws ");
            this.getException(0).toString(s2);
            for (i = 1; i < this.getNumException(); ++i) {
                s2.append(", ");
                this.getException(i).toString(s2);
            }
        }
        s2.append(" {");
        if (this.hasConstructorInvocation()) {
            this.getConstructorInvocation().toString(s2);
        }
        for (i = 0; i < this.getBlock().getNumStmt(); ++i) {
            this.getBlock().getStmt(i).toString(s2);
        }
        s2.append(this.indent());
        s2.append("}");
    }

    @Override
    public void typeCheck() {
        TypeDecl exceptionType = this.typeThrowable();
        for (int i = 0; i < this.getNumException(); ++i) {
            TypeDecl typeDecl = this.getException(i).type();
            if (typeDecl.instanceOf(exceptionType)) continue;
            this.error(this.signature() + " throws non throwable type " + typeDecl.fullName());
        }
    }

    @Override
    protected void transformEnumConstructors() {
        Modifiers newModifiers = new Modifiers(new List<Modifier>());
        for (int i = 0; i < this.getModifiers().getNumModifier(); ++i) {
            String modifier = this.getModifiers().getModifier(i).getID();
            if (modifier.equals("public") || modifier.equals("private") || modifier.equals("protected")) continue;
            newModifiers.addModifier(new Modifier(modifier));
        }
        newModifiers.addModifier(new Modifier("private"));
        this.setModifiers(newModifiers);
        if (!this.hasConstructorInvocation()) {
            this.setConstructorInvocation(new ExprStmt(new SuperConstructorAccess("super", new List<Expr>())));
        }
        super.transformEnumConstructors();
        this.getParameterList().insertChild(new ParameterDeclaration(new TypeAccess("java.lang", "String"), "@p0"), 0);
        this.getParameterList().insertChild(new ParameterDeclaration(new TypeAccess("int"), "@p1"), 1);
    }

    @Override
    public BodyDecl substitutedBodyDecl(Parameterization parTypeDecl) {
        ConstructorDeclSubstituted c = new ConstructorDeclSubstituted(this.getModifiers().fullCopy(), this.getID(), (List<ParameterDeclaration>)this.getParameterList().substitute(parTypeDecl), (List<Access>)this.getExceptionList().substitute(parTypeDecl), new Opt<Stmt>(), new Block(), this);
        return c;
    }

    public void addEnclosingVariables() {
        if (!this.addEnclosingVariables) {
            return;
        }
        this.addEnclosingVariables = false;
        this.hostType().addEnclosingVariables();
        for (Variable v : this.hostType().enclosingVariables()) {
            this.getParameterList().add(new ParameterDeclaration(v.type(), "val$" + v.name()));
        }
    }

    public ConstructorDecl createAccessor() {
        ConstructorDecl c = (ConstructorDecl)this.hostType().getAccessor(this, "constructor");
        if (c != null) {
            return c;
        }
        this.addEnclosingVariables();
        Modifiers modifiers = new Modifiers(new List<Modifier>());
        modifiers.addModifier(new Modifier("synthetic"));
        modifiers.addModifier(new Modifier("public"));
        List parameters = this.createAccessorParameters();
        List<Access> exceptionList = new List<Access>();
        for (int i = 0; i < this.getNumException(); ++i) {
            exceptionList.add(this.getException(i).type().createQualifiedAccess());
        }
        List<Expr> args = new List<Expr>();
        for (int i = 0; i < parameters.getNumChildNoTransform() - 1; ++i) {
            args.add(new VarAccess(((ParameterDeclaration)parameters.getChildNoTransform(i)).name()));
        }
        ConstructorAccess access = new ConstructorAccess("this", args);
        access.addEnclosingVariables = false;
        c = new ConstructorDecl(modifiers, this.name(), (List<ParameterDeclaration>)parameters, exceptionList, new Opt<Stmt>(new ExprStmt(access)), new Block(new List<ReturnStmt>().add(new ReturnStmt(new Opt<Expr>()))));
        c = this.hostType().addConstructor(c);
        c.addEnclosingVariables = false;
        this.hostType().addAccessor(this, "constructor", c);
        return c;
    }

    protected List createAccessorParameters() {
        List<ParameterDeclaration> parameters = new List<ParameterDeclaration>();
        for (int i = 0; i < this.getNumParameter(); ++i) {
            parameters.add(new ParameterDeclaration(this.getParameter(i).type(), this.getParameter(i).name()));
        }
        parameters.add(new ParameterDeclaration(this.createAnonymousJavaTypeDecl().createBoundAccess(), "p" + this.getNumParameter()));
        return parameters;
    }

    protected TypeDecl createAnonymousJavaTypeDecl() {
        ClassDecl classDecl = new ClassDecl(new Modifiers(new List<Modifier>().add(new Modifier("synthetic"))), "" + this.hostType().nextAnonymousIndex(), new Opt<Access>(), new List<Access>(), new List<BodyDecl>());
        classDecl = this.hostType().addMemberClass(classDecl);
        this.hostType().addNestedType(classDecl);
        return classDecl;
    }

    @Override
    public void transformation() {
        this.addEnclosingVariables();
        super.transformation();
    }

    @Override
    public void jimplify1phase2() {
        String name = "<init>";
        ArrayList<Type> parameters = new ArrayList<Type>();
        ArrayList<String> paramnames = new ArrayList<String>();
        TypeDecl typeDecl = this.hostType();
        if (typeDecl.needsEnclosing()) {
            parameters.add(typeDecl.enclosingType().getSootType());
        }
        if (typeDecl.needsSuperEnclosing()) {
            ClassDecl superClass = ((ClassDecl)typeDecl).superclass();
            parameters.add(superClass.enclosingType().getSootType());
        }
        for (int i = 0; i < this.getNumParameter(); ++i) {
            parameters.add(this.getParameter(i).type().getSootType());
            paramnames.add(this.getParameter(i).name());
        }
        VoidType returnType = VoidType.v();
        int modifiers = this.sootTypeModifiers();
        ArrayList<SootClass> throwtypes = new ArrayList<SootClass>();
        for (int i = 0; i < this.getNumException(); ++i) {
            throwtypes.add(this.getException(i).type().getSootClassDecl());
        }
        String signature = SootMethod.getSubSignature(name, parameters, returnType);
        if (!this.hostType().getSootClassDecl().declaresMethod(signature)) {
            SootMethod m4 = Scene.v().makeSootMethod(name, parameters, returnType, modifiers, throwtypes);
            this.hostType().getSootClassDecl().addMethod(m4);
            m4.addTag(new ParamNamesTag(paramnames));
            this.sootMethod = m4;
        } else {
            this.sootMethod = this.hostType().getSootClassDecl().getMethod(signature);
        }
        this.addAttributes();
    }

    @Override
    public void addAttributes() {
        super.addAttributes();
        ArrayList c = new ArrayList();
        this.getModifiers().addRuntimeVisibleAnnotationsAttribute(c);
        this.getModifiers().addRuntimeInvisibleAnnotationsAttribute(c);
        this.addRuntimeVisibleParameterAnnotationsAttribute(c);
        this.addRuntimeInvisibleParameterAnnotationsAttribute(c);
        this.addSourceLevelParameterAnnotationsAttribute(c);
        this.getModifiers().addSourceOnlyAnnotations(c);
        for (Tag tag : c) {
            this.sootMethod.addTag(tag);
        }
    }

    public void addRuntimeVisibleParameterAnnotationsAttribute(Collection c) {
        boolean foundVisibleAnnotations = false;
        ArrayList<VisibilityAnnotationTag> annotations = new ArrayList<VisibilityAnnotationTag>(this.getNumParameter());
        for (int i = 0; i < this.getNumParameter(); ++i) {
            Collection a = this.getParameter(i).getModifiers().runtimeVisibleAnnotations();
            if (!a.isEmpty()) {
                foundVisibleAnnotations = true;
            }
            VisibilityAnnotationTag tag = new VisibilityAnnotationTag(0);
            for (Annotation annotation : a) {
                ArrayList elements = new ArrayList(1);
                annotation.appendAsAttributeTo(elements);
                tag.addAnnotation((AnnotationTag)elements.get(0));
            }
            annotations.add(tag);
        }
        if (foundVisibleAnnotations) {
            VisibilityParameterAnnotationTag tag = new VisibilityParameterAnnotationTag(annotations.size(), 0);
            Iterator iter = annotations.iterator();
            while (iter.hasNext()) {
                tag.addVisibilityAnnotation((VisibilityAnnotationTag)iter.next());
            }
            c.add(tag);
        }
    }

    public void addRuntimeInvisibleParameterAnnotationsAttribute(Collection c) {
        boolean foundVisibleAnnotations = false;
        ArrayList<VisibilityAnnotationTag> annotations = new ArrayList<VisibilityAnnotationTag>(this.getNumParameter());
        for (int i = 0; i < this.getNumParameter(); ++i) {
            Collection a = this.getParameter(i).getModifiers().runtimeInvisibleAnnotations();
            if (!a.isEmpty()) {
                foundVisibleAnnotations = true;
            }
            VisibilityAnnotationTag tag = new VisibilityAnnotationTag(1);
            for (Annotation annotation : a) {
                ArrayList elements = new ArrayList(1);
                annotation.appendAsAttributeTo(elements);
                tag.addAnnotation((AnnotationTag)elements.get(0));
            }
            annotations.add(tag);
        }
        if (foundVisibleAnnotations) {
            VisibilityParameterAnnotationTag tag = new VisibilityParameterAnnotationTag(annotations.size(), 1);
            Iterator iter = annotations.iterator();
            while (iter.hasNext()) {
                tag.addVisibilityAnnotation((VisibilityAnnotationTag)iter.next());
            }
            c.add(tag);
        }
    }

    public void addSourceLevelParameterAnnotationsAttribute(Collection c) {
        boolean foundVisibleAnnotations = false;
        ArrayList annotations = new ArrayList(this.getNumParameter());
        for (int i = 0; i < this.getNumParameter(); ++i) {
            this.getParameter(i).getModifiers().addSourceOnlyAnnotations(c);
        }
    }

    public ConstructorDecl() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[5];
        this.setChild(new List(), 1);
        this.setChild(new List(), 2);
        this.setChild(new Opt(), 3);
    }

    public ConstructorDecl(Modifiers p0, String p1, List<ParameterDeclaration> p2, List<Access> p3, Opt<Stmt> p4, Block p5) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
        this.setChild(p5, 4);
    }

    public ConstructorDecl(Modifiers p0, Symbol p1, List<ParameterDeclaration> p2, List<Access> p3, Opt<Stmt> p4, Block p5) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
        this.setChild(p5, 4);
    }

    @Override
    protected int numChildren() {
        return 5;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    public void setModifiers(Modifiers node) {
        this.setChild(node, 0);
    }

    public Modifiers getModifiers() {
        return (Modifiers)this.getChild(0);
    }

    public Modifiers getModifiersNoTransform() {
        return (Modifiers)this.getChildNoTransform(0);
    }

    public void setID(String value) {
        this.tokenString_ID = value;
    }

    public void setID(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol2.value;
        this.IDstart = symbol2.getStart();
        this.IDend = symbol2.getEnd();
    }

    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    public void setParameterList(List<ParameterDeclaration> list) {
        this.setChild(list, 1);
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public int getNumParameterNoTransform() {
        return this.getParameterListNoTransform().getNumChildNoTransform();
    }

    public ParameterDeclaration getParameter(int i) {
        return (ParameterDeclaration)this.getParameterList().getChild(i);
    }

    public void addParameter(ParameterDeclaration node) {
        List<ParameterDeclaration> list = this.parent == null || state == null ? this.getParameterListNoTransform() : this.getParameterList();
        list.addChild(node);
    }

    public void addParameterNoTransform(ParameterDeclaration node) {
        List<ParameterDeclaration> list = this.getParameterListNoTransform();
        list.addChild(node);
    }

    public void setParameter(ParameterDeclaration node, int i) {
        List<ParameterDeclaration> list = this.getParameterList();
        list.setChild(node, i);
    }

    public List<ParameterDeclaration> getParameters() {
        return this.getParameterList();
    }

    public List<ParameterDeclaration> getParametersNoTransform() {
        return this.getParameterListNoTransform();
    }

    public List<ParameterDeclaration> getParameterList() {
        List list = (List)this.getChild(1);
        list.getNumChild();
        return list;
    }

    public List<ParameterDeclaration> getParameterListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public void setExceptionList(List<Access> list) {
        this.setChild(list, 2);
    }

    public int getNumException() {
        return this.getExceptionList().getNumChild();
    }

    public int getNumExceptionNoTransform() {
        return this.getExceptionListNoTransform().getNumChildNoTransform();
    }

    public Access getException(int i) {
        return (Access)this.getExceptionList().getChild(i);
    }

    public void addException(Access node) {
        List<Access> list = this.parent == null || state == null ? this.getExceptionListNoTransform() : this.getExceptionList();
        list.addChild(node);
    }

    public void addExceptionNoTransform(Access node) {
        List<Access> list = this.getExceptionListNoTransform();
        list.addChild(node);
    }

    public void setException(Access node, int i) {
        List<Access> list = this.getExceptionList();
        list.setChild(node, i);
    }

    public List<Access> getExceptions() {
        return this.getExceptionList();
    }

    public List<Access> getExceptionsNoTransform() {
        return this.getExceptionListNoTransform();
    }

    public List<Access> getExceptionList() {
        List list = (List)this.getChild(2);
        list.getNumChild();
        return list;
    }

    public List<Access> getExceptionListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    public void setConstructorInvocationOpt(Opt<Stmt> opt) {
        this.setChild(opt, 3);
    }

    public boolean hasConstructorInvocation() {
        return this.getConstructorInvocationOpt().getNumChild() != 0;
    }

    public Stmt getConstructorInvocation() {
        return (Stmt)this.getConstructorInvocationOpt().getChild(0);
    }

    public void setConstructorInvocation(Stmt node) {
        this.getConstructorInvocationOpt().setChild(node, 0);
    }

    public Opt<Stmt> getConstructorInvocationOpt() {
        return (Opt)this.getChild(3);
    }

    public Opt<Stmt> getConstructorInvocationOptNoTransform() {
        return (Opt)this.getChildNoTransform(3);
    }

    public void setBlock(Block node) {
        this.setChild(node, 4);
    }

    public Block getBlock() {
        return (Block)this.getChild(4);
    }

    public Block getBlockNoTransform() {
        return (Block)this.getChildNoTransform(4);
    }

    @Override
    public void jimplify2() {
        if (!this.generate() || this.sootMethod().hasActiveBody()) {
            return;
        }
        JimpleBody body = Jimple.v().newBody(this.sootMethod());
        this.sootMethod().setActiveBody(body);
        Body b = new Body(this.hostType(), body, this);
        b.setLine(this);
        for (int i = 0; i < this.getNumParameter(); ++i) {
            this.getParameter(i).jimplify2(b);
        }
        boolean needsInit = true;
        if (this.hasConstructorInvocation()) {
            ExprStmt exprStmt;
            Expr expr;
            this.getConstructorInvocation().jimplify2(b);
            Stmt stmt = this.getConstructorInvocation();
            if (stmt instanceof ExprStmt && !(expr = (exprStmt = (ExprStmt)stmt).getExpr()).isSuperConstructorAccess()) {
                needsInit = false;
            }
        }
        if (this.hostType().needsEnclosing()) {
            TypeDecl type = this.hostType().enclosingType();
            b.add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(b.emitThis(this.hostType()), this.hostType().getSootField("this$0", type).makeRef()), this.asLocal(b, Jimple.v().newParameterRef(type.getSootType(), 0))));
        }
        for (Variable v : this.hostType().enclosingVariables()) {
            ParameterDeclaration p = (ParameterDeclaration)this.parameterDeclaration("val$" + v.name()).iterator().next();
            b.add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(b.emitThis(this.hostType()), Scene.v().makeFieldRef(this.hostType().getSootClassDecl(), "val$" + v.name(), v.type().getSootType(), false)), p.local));
        }
        if (needsInit) {
            TypeDecl typeDecl = this.hostType();
            for (int i = 0; i < typeDecl.getNumBodyDecl(); ++i) {
                BodyDecl bodyDecl = typeDecl.getBodyDecl(i);
                if (bodyDecl instanceof FieldDeclaration && bodyDecl.generate()) {
                    FieldDeclaration f = (FieldDeclaration)bodyDecl;
                    if (f.isStatic() || !f.hasInit()) continue;
                    Local base = b.emitThis(this.hostType());
                    Local l = this.asLocal(b, f.getInit().type().emitCastTo(b, f.getInit(), f.type()), f.type().getSootType());
                    b.setLine(f);
                    b.add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(base, f.sootRef()), l));
                    continue;
                }
                if (!(bodyDecl instanceof InstanceInitializer) || !bodyDecl.generate()) continue;
                bodyDecl.jimplify2(b);
            }
        }
        this.getBlock().jimplify2(b);
        b.add(Jimple.v().newReturnVoidStmt());
    }

    private boolean refined_ConstructorDecl_ConstructorDecl_moreSpecificThan_ConstructorDecl(ConstructorDecl m4) {
        for (int i = 0; i < this.getNumParameter(); ++i) {
            if (this.getParameter(i).type().instanceOf(m4.getParameter(i).type())) continue;
            return false;
        }
        return true;
    }

    public boolean accessibleFrom(TypeDecl type) {
        TypeDecl _parameters = type;
        if (this.accessibleFrom_TypeDecl_values == null) {
            this.accessibleFrom_TypeDecl_values = new HashMap(4);
        }
        if (this.accessibleFrom_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.accessibleFrom_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean accessibleFrom_TypeDecl_value = this.accessibleFrom_compute(type);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.accessibleFrom_TypeDecl_values.put(_parameters, accessibleFrom_TypeDecl_value);
        }
        return accessibleFrom_TypeDecl_value;
    }

    private boolean accessibleFrom_compute(TypeDecl type) {
        if (!this.hostType().accessibleFrom(type)) {
            return false;
        }
        if (this.isPublic()) {
            return true;
        }
        if (this.isProtected()) {
            return true;
        }
        if (this.isPrivate()) {
            return this.hostType().topLevelType() == type.topLevelType();
        }
        return this.hostPackage().equals(type.hostPackage());
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getBlock().isDAafter(v) && this.getBlock().checkReturnDA(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getBlock().isDUafter(v) && this.getBlock().checkReturnDU(v);
    }

    public boolean throwsException(TypeDecl exceptionType) {
        TypeDecl _parameters = exceptionType;
        if (this.throwsException_TypeDecl_values == null) {
            this.throwsException_TypeDecl_values = new HashMap(4);
        }
        if (this.throwsException_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.throwsException_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean throwsException_TypeDecl_value = this.throwsException_compute(exceptionType);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.throwsException_TypeDecl_values.put(_parameters, throwsException_TypeDecl_value);
        }
        return throwsException_TypeDecl_value;
    }

    private boolean throwsException_compute(TypeDecl exceptionType) {
        for (int i = 0; i < this.getNumException(); ++i) {
            if (!exceptionType.instanceOf(this.getException(i).type())) continue;
            return true;
        }
        return false;
    }

    public String name() {
        if (this.name_computed) {
            return this.name_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.name_value = this.name_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.name_computed = true;
        }
        return this.name_value;
    }

    private String name_compute() {
        return this.getID();
    }

    public String signature() {
        if (this.signature_computed) {
            return this.signature_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.signature_value = this.signature_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.signature_computed = true;
        }
        return this.signature_value;
    }

    private String signature_compute() {
        StringBuffer s2 = new StringBuffer();
        s2.append(this.name() + "(");
        for (int i = 0; i < this.getNumParameter(); ++i) {
            s2.append(this.getParameter(i));
            if (i == this.getNumParameter() - 1) continue;
            s2.append(", ");
        }
        s2.append(")");
        return s2.toString();
    }

    public boolean sameSignature(ConstructorDecl c) {
        ConstructorDecl _parameters = c;
        if (this.sameSignature_ConstructorDecl_values == null) {
            this.sameSignature_ConstructorDecl_values = new HashMap(4);
        }
        if (this.sameSignature_ConstructorDecl_values.containsKey(_parameters)) {
            return (Boolean)this.sameSignature_ConstructorDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean sameSignature_ConstructorDecl_value = this.sameSignature_compute(c);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.sameSignature_ConstructorDecl_values.put(_parameters, sameSignature_ConstructorDecl_value);
        }
        return sameSignature_ConstructorDecl_value;
    }

    private boolean sameSignature_compute(ConstructorDecl c) {
        if (!this.name().equals(c.name())) {
            return false;
        }
        if (c.getNumParameter() != this.getNumParameter()) {
            return false;
        }
        for (int i = 0; i < this.getNumParameter(); ++i) {
            if (c.getParameter(i).type().equals(this.getParameter(i).type())) continue;
            return false;
        }
        return true;
    }

    public boolean moreSpecificThan(ConstructorDecl m4) {
        ConstructorDecl _parameters = m4;
        if (this.moreSpecificThan_ConstructorDecl_values == null) {
            this.moreSpecificThan_ConstructorDecl_values = new HashMap(4);
        }
        if (this.moreSpecificThan_ConstructorDecl_values.containsKey(_parameters)) {
            return (Boolean)this.moreSpecificThan_ConstructorDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean moreSpecificThan_ConstructorDecl_value = this.moreSpecificThan_compute(m4);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.moreSpecificThan_ConstructorDecl_values.put(_parameters, moreSpecificThan_ConstructorDecl_value);
        }
        return moreSpecificThan_ConstructorDecl_value;
    }

    private boolean moreSpecificThan_compute(ConstructorDecl m4) {
        if (!this.isVariableArity() && !m4.isVariableArity()) {
            return this.refined_ConstructorDecl_ConstructorDecl_moreSpecificThan_ConstructorDecl(m4);
        }
        int num = Math.max(this.getNumParameter(), m4.getNumParameter());
        for (int i = 0; i < num; ++i) {
            TypeDecl t2;
            TypeDecl t1 = i < this.getNumParameter() - 1 ? this.getParameter(i).type() : this.getParameter(this.getNumParameter() - 1).type().componentType();
            TypeDecl typeDecl = t2 = i < m4.getNumParameter() - 1 ? m4.getParameter(i).type() : m4.getParameter(m4.getNumParameter() - 1).type().componentType();
            if (t1.instanceOf(t2)) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultConstructor() {
        ASTNode$State state = this.state();
        return this.isDefaultConstructor;
    }

    public SimpleSet parameterDeclaration(String name) {
        String _parameters = name;
        if (this.parameterDeclaration_String_values == null) {
            this.parameterDeclaration_String_values = new HashMap(4);
        }
        if (this.parameterDeclaration_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.parameterDeclaration_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet parameterDeclaration_String_value = this.parameterDeclaration_compute(name);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.parameterDeclaration_String_values.put(_parameters, parameterDeclaration_String_value);
        }
        return parameterDeclaration_String_value;
    }

    private SimpleSet parameterDeclaration_compute(String name) {
        for (int i = 0; i < this.getNumParameter(); ++i) {
            if (!this.getParameter(i).name().equals(name)) continue;
            return this.getParameter(i);
        }
        return SimpleSet.emptySet;
    }

    public boolean isSynthetic() {
        ASTNode$State state = this.state();
        return this.getModifiers().isSynthetic();
    }

    public boolean isPublic() {
        ASTNode$State state = this.state();
        return this.getModifiers().isPublic();
    }

    public boolean isPrivate() {
        ASTNode$State state = this.state();
        return this.getModifiers().isPrivate();
    }

    public boolean isProtected() {
        ASTNode$State state = this.state();
        return this.getModifiers().isProtected();
    }

    public boolean circularThisInvocation(ConstructorDecl decl) {
        ASTNode$State.CircularValue _value;
        ConstructorDecl _parameters = decl;
        if (this.circularThisInvocation_ConstructorDecl_values == null) {
            this.circularThisInvocation_ConstructorDecl_values = new HashMap(4);
        }
        if (this.circularThisInvocation_ConstructorDecl_values.containsKey(_parameters)) {
            Object _o = this.circularThisInvocation_ConstructorDecl_values.get(_parameters);
            if (!(_o instanceof ASTNode$State.CircularValue)) {
                return (Boolean)_o;
            }
            _value = (ASTNode$State.CircularValue)_o;
        } else {
            _value = new ASTNode$State.CircularValue();
            this.circularThisInvocation_ConstructorDecl_values.put(_parameters, _value);
            _value.value = true;
        }
        ASTNode$State state = this.state();
        if (!state.IN_CIRCLE) {
            boolean new_circularThisInvocation_ConstructorDecl_value;
            state.IN_CIRCLE = true;
            int num = state.boundariesCrossed;
            boolean isFinal = this.is$Final();
            do {
                _value.visited = new Integer(state.CIRCLE_INDEX);
                state.CHANGE = false;
                new_circularThisInvocation_ConstructorDecl_value = this.circularThisInvocation_compute(decl);
                if (new_circularThisInvocation_ConstructorDecl_value != (Boolean)_value.value) {
                    state.CHANGE = true;
                    _value.value = new_circularThisInvocation_ConstructorDecl_value;
                }
                ++state.CIRCLE_INDEX;
            } while (state.CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.circularThisInvocation_ConstructorDecl_values.put(_parameters, new_circularThisInvocation_ConstructorDecl_value);
            } else {
                this.circularThisInvocation_ConstructorDecl_values.remove(_parameters);
                state.RESET_CYCLE = true;
                this.circularThisInvocation_compute(decl);
                state.RESET_CYCLE = false;
            }
            state.IN_CIRCLE = false;
            return new_circularThisInvocation_ConstructorDecl_value;
        }
        if (!new Integer(state.CIRCLE_INDEX).equals(_value.visited)) {
            _value.visited = new Integer(state.CIRCLE_INDEX);
            boolean new_circularThisInvocation_ConstructorDecl_value = this.circularThisInvocation_compute(decl);
            if (state.RESET_CYCLE) {
                this.circularThisInvocation_ConstructorDecl_values.remove(_parameters);
            } else if (new_circularThisInvocation_ConstructorDecl_value != (Boolean)_value.value) {
                state.CHANGE = true;
                _value.value = new_circularThisInvocation_ConstructorDecl_value;
            }
            return new_circularThisInvocation_ConstructorDecl_value;
        }
        return (Boolean)_value.value;
    }

    private boolean circularThisInvocation_compute(ConstructorDecl decl) {
        Expr e;
        if (this.hasConstructorInvocation() && (e = ((ExprStmt)this.getConstructorInvocation()).getExpr()) instanceof ConstructorAccess) {
            ConstructorDecl constructorDecl = ((ConstructorAccess)e).decl();
            if (constructorDecl == decl) {
                return true;
            }
            return constructorDecl.circularThisInvocation(decl);
        }
        return false;
    }

    public TypeDecl type() {
        ASTNode$State state = this.state();
        return this.unknownType();
    }

    @Override
    public boolean isVoid() {
        ASTNode$State state = this.state();
        return true;
    }

    @Override
    public boolean hasAnnotationSuppressWarnings(String s2) {
        ASTNode$State state = this.state();
        return this.getModifiers().hasAnnotationSuppressWarnings(s2);
    }

    @Override
    public boolean isDeprecated() {
        ASTNode$State state = this.state();
        return this.getModifiers().hasDeprecatedAnnotation();
    }

    public ConstructorDecl sourceConstructorDecl() {
        if (this.sourceConstructorDecl_computed) {
            return this.sourceConstructorDecl_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.sourceConstructorDecl_value = this.sourceConstructorDecl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.sourceConstructorDecl_computed = true;
        }
        return this.sourceConstructorDecl_value;
    }

    private ConstructorDecl sourceConstructorDecl_compute() {
        return this;
    }

    public boolean applicableBySubtyping(List argList) {
        ASTNode$State state = this.state();
        if (this.getNumParameter() != argList.getNumChild()) {
            return false;
        }
        for (int i = 0; i < this.getNumParameter(); ++i) {
            TypeDecl arg = ((Expr)argList.getChild(i)).type();
            if (arg.instanceOf(this.getParameter(i).type())) continue;
            return false;
        }
        return true;
    }

    public boolean applicableByMethodInvocationConversion(List argList) {
        ASTNode$State state = this.state();
        if (this.getNumParameter() != argList.getNumChild()) {
            return false;
        }
        for (int i = 0; i < this.getNumParameter(); ++i) {
            TypeDecl arg = ((Expr)argList.getChild(i)).type();
            if (arg.methodInvocationConversionTo(this.getParameter(i).type())) continue;
            return false;
        }
        return true;
    }

    public boolean applicableVariableArity(List argList) {
        TypeDecl arg;
        int i;
        ASTNode$State state = this.state();
        for (i = 0; i < this.getNumParameter() - 1; ++i) {
            arg = ((Expr)argList.getChild(i)).type();
            if (arg.methodInvocationConversionTo(this.getParameter(i).type())) continue;
            return false;
        }
        for (i = this.getNumParameter() - 1; i < argList.getNumChild(); ++i) {
            arg = ((Expr)argList.getChild(i)).type();
            if (arg.methodInvocationConversionTo(this.lastParameter().type().componentType())) continue;
            return false;
        }
        return true;
    }

    public boolean potentiallyApplicable(List argList) {
        ASTNode$State state = this.state();
        if (this.isVariableArity() && argList.getNumChild() < this.arity() - 1) {
            return false;
        }
        return this.isVariableArity() || this.arity() == argList.getNumChild();
    }

    public int arity() {
        ASTNode$State state = this.state();
        return this.getNumParameter();
    }

    public boolean isVariableArity() {
        ASTNode$State state = this.state();
        return this.getNumParameter() == 0 ? false : this.getParameter(this.getNumParameter() - 1).isVariableArity();
    }

    public ParameterDeclaration lastParameter() {
        ASTNode$State state = this.state();
        return this.getParameter(this.getNumParameter() - 1);
    }

    public boolean needsEnclosing() {
        ASTNode$State state = this.state();
        return this.hostType().needsEnclosing();
    }

    public boolean needsSuperEnclosing() {
        ASTNode$State state = this.state();
        return this.hostType().needsSuperEnclosing();
    }

    public TypeDecl enclosing() {
        ASTNode$State state = this.state();
        return this.hostType().enclosing();
    }

    public TypeDecl superEnclosing() {
        ASTNode$State state = this.state();
        return this.hostType().superEnclosing();
    }

    public int sootTypeModifiers() {
        ASTNode$State state = this.state();
        int result = 0;
        if (this.isPublic()) {
            result |= 1;
        }
        if (this.isProtected()) {
            result |= 4;
        }
        if (this.isPrivate()) {
            result |= 2;
        }
        return result;
    }

    public SootMethod sootMethod() {
        if (this.sootMethod_computed) {
            return this.sootMethod_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.sootMethod_value = this.sootMethod_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.sootMethod_computed = true;
        }
        return this.sootMethod_value;
    }

    private SootMethod sootMethod_compute() {
        ArrayList<Type> list = new ArrayList<Type>();
        TypeDecl typeDecl = this.hostType();
        if (typeDecl.needsEnclosing()) {
            list.add(typeDecl.enclosingType().getSootType());
        }
        if (typeDecl.needsSuperEnclosing()) {
            ClassDecl superClass = ((ClassDecl)typeDecl).superclass();
            list.add(superClass.enclosingType().getSootType());
        }
        for (int i = 0; i < this.getNumParameter(); ++i) {
            list.add(this.getParameter(i).type().getSootType());
        }
        return this.hostType().getSootClassDecl().getMethod("<init>", list, VoidType.v());
    }

    public SootMethodRef sootRef() {
        if (this.sootRef_computed) {
            return this.sootRef_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.sootRef_value = this.sootRef_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.sootRef_computed = true;
        }
        return this.sootRef_value;
    }

    private SootMethodRef sootRef_compute() {
        ArrayList<Type> parameters = new ArrayList<Type>();
        TypeDecl typeDecl = this.hostType();
        if (typeDecl.needsEnclosing()) {
            parameters.add(typeDecl.enclosingType().getSootType());
        }
        if (typeDecl.needsSuperEnclosing()) {
            ClassDecl superClass = ((ClassDecl)typeDecl).superclass();
            parameters.add(superClass.enclosingType().getSootType());
        }
        for (int i = 0; i < this.getNumParameter(); ++i) {
            parameters.add(this.getParameter(i).type().getSootType());
        }
        SootMethodRef ref = Scene.v().makeConstructorRef(this.hostType().getSootClassDecl(), parameters);
        return ref;
    }

    public int localNumOfFirstParameter() {
        if (this.localNumOfFirstParameter_computed) {
            return this.localNumOfFirstParameter_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.localNumOfFirstParameter_value = this.localNumOfFirstParameter_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.localNumOfFirstParameter_computed = true;
        }
        return this.localNumOfFirstParameter_value;
    }

    private int localNumOfFirstParameter_compute() {
        int i = 0;
        if (this.hostType().needsEnclosing()) {
            ++i;
        }
        if (this.hostType().needsSuperEnclosing()) {
            ++i;
        }
        return i;
    }

    public int offsetFirstEnclosingVariable() {
        if (this.offsetFirstEnclosingVariable_computed) {
            return this.offsetFirstEnclosingVariable_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.offsetFirstEnclosingVariable_value = this.offsetFirstEnclosingVariable_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.offsetFirstEnclosingVariable_computed = true;
        }
        return this.offsetFirstEnclosingVariable_value;
    }

    private int offsetFirstEnclosingVariable_compute() {
        return this.getNumParameter() == 0 ? this.localNumOfFirstParameter() : this.getParameter(this.getNumParameter() - 1).localNum() + this.getParameter(this.getNumParameter() - 1).type().variableSize();
    }

    public ConstructorDecl erasedConstructor() {
        ASTNode$State state = this.state();
        return this;
    }

    @Override
    public boolean hasAnnotationSafeVarargs() {
        ASTNode$State state = this.state();
        return this.getModifiers().hasAnnotationSafeVarargs();
    }

    @Override
    public boolean hasIllegalAnnotationSafeVarargs() {
        ASTNode$State state = this.state();
        return this.hasAnnotationSafeVarargs() && !this.isVariableArity();
    }

    public boolean handlesException(TypeDecl exceptionType) {
        TypeDecl _parameters = exceptionType;
        if (this.handlesException_TypeDecl_values == null) {
            this.handlesException_TypeDecl_values = new HashMap(4);
        }
        if (this.handlesException_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.handlesException_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean handlesException_TypeDecl_value = this.getParent().Define_boolean_handlesException(this, null, exceptionType);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.handlesException_TypeDecl_values.put(_parameters, handlesException_TypeDecl_value);
        }
        return handlesException_TypeDecl_value;
    }

    public TypeDecl unknownType() {
        ASTNode$State state = this.state();
        TypeDecl unknownType_value = this.getParent().Define_TypeDecl_unknownType(this, null);
        return unknownType_value;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getBlockNoTransform()) {
            return this.hasConstructorInvocation() ? this.getConstructorInvocation().isDAafter(v) : this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getBlockNoTransform()) {
            return this.hasConstructorInvocation() ? this.getConstructorInvocation().isDUafter(v) : this.isDUbefore(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_handlesException(ASTNode caller, ASTNode child, TypeDecl exceptionType) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return this.throwsException(exceptionType) || this.handlesException(exceptionType);
        }
        if (caller == this.getBlockNoTransform()) {
            return this.throwsException(exceptionType) || this.handlesException(exceptionType);
        }
        return this.getParent().Define_boolean_handlesException(this, caller, exceptionType);
    }

    @Override
    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            ArrayList<MethodDecl> c = new ArrayList<MethodDecl>();
            for (MethodDecl m4 : this.lookupMethod(name)) {
                if (this.hostType().memberMethods(name).contains(m4) && !m4.isStatic()) continue;
                c.add(m4);
            }
            return c;
        }
        return this.getParent().Define_Collection_lookupMethod(this, caller, name);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.parameterDeclaration(name);
        }
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            SimpleSet set = this.parameterDeclaration(name);
            if (!set.isEmpty()) {
                return set;
            }
            Iterator iter = this.lookupVariable(name).iterator();
            while (iter.hasNext()) {
                Variable v = (Variable)iter.next();
                if (this.hostType().memberFields(name).contains(v) && !v.isStatic()) continue;
                set = set.add(v);
            }
            return set;
        }
        if (caller == this.getBlockNoTransform()) {
            SimpleSet set = this.parameterDeclaration(name);
            if (!set.isEmpty()) {
                return set;
            }
            return this.lookupVariable(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    @Override
    public boolean Define_boolean_mayBePublic(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBePublic(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeProtected(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeProtected(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBePrivate(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBePrivate(this, caller);
    }

    @Override
    public ASTNode Define_ASTNode_enclosingBlock(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return this;
        }
        return this.getParent().Define_ASTNode_enclosingBlock(this, caller);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return NameType.EXPRESSION_NAME;
        }
        if (caller == this.getExceptionListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.TYPE_NAME;
        }
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public TypeDecl Define_TypeDecl_enclosingInstance(ASTNode caller, ASTNode child) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return this.unknownType();
        }
        return this.getParent().Define_TypeDecl_enclosingInstance(this, caller);
    }

    @Override
    public boolean Define_boolean_inExplicitConstructorInvocation(ASTNode caller, ASTNode child) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_inExplicitConstructorInvocation(this, caller);
    }

    @Override
    public boolean Define_boolean_inStaticContext(ASTNode caller, ASTNode child) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return false;
        }
        if (caller == this.getBlockNoTransform()) {
            return false;
        }
        return this.getParent().Define_boolean_inStaticContext(this, caller);
    }

    @Override
    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return !this.hasConstructorInvocation() ? true : this.getConstructorInvocation().canCompleteNormally();
        }
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    @Override
    public boolean Define_boolean_isMethodParameter(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return false;
        }
        return this.getParent().Define_boolean_isMethodParameter(this, caller);
    }

    @Override
    public boolean Define_boolean_isConstructorParameter(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return true;
        }
        return this.getParent().Define_boolean_isConstructorParameter(this, caller);
    }

    @Override
    public boolean Define_boolean_isExceptionHandlerParameter(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return false;
        }
        return this.getParent().Define_boolean_isExceptionHandlerParameter(this, caller);
    }

    @Override
    public boolean Define_boolean_mayUseAnnotationTarget(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getModifiersNoTransform()) {
            return name.equals("CONSTRUCTOR");
        }
        return this.getParent().Define_boolean_mayUseAnnotationTarget(this, caller, name);
    }

    @Override
    public boolean Define_boolean_variableArityValid(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return i == this.getNumParameter() - 1;
        }
        return this.getParent().Define_boolean_variableArityValid(this, caller);
    }

    @Override
    public int Define_int_localNum(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int index = caller.getIndexOfChild(child);
            if (index == 0) {
                return this.localNumOfFirstParameter();
            }
            return this.getParameter(index - 1).localNum() + this.getParameter(index - 1).type().variableSize();
        }
        return this.getParent().Define_int_localNum(this, caller);
    }

    @Override
    public boolean Define_boolean_enclosedByExceptionHandler(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return this.getNumException() != 0;
        }
        return this.getParent().Define_boolean_enclosedByExceptionHandler(this, caller);
    }

    @Override
    public boolean Define_boolean_inhModifiedInScope(ASTNode caller, ASTNode child, Variable var) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.getBlock().modifiedInScope(var);
        }
        return this.getParent().Define_boolean_inhModifiedInScope(this, caller, var);
    }

    @Override
    public boolean Define_boolean_isCatchParam(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return false;
        }
        return this.getParent().Define_boolean_isCatchParam(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        if (!this.hasConstructorInvocation() && !this.hostType().isObject()) {
            ++this.state().duringImplicitConstructor;
            ConstructorDecl result = this.rewriteRule0();
            --this.state().duringImplicitConstructor;
            return result;
        }
        return super.rewriteTo();
    }

    private ConstructorDecl rewriteRule0() {
        this.setConstructorInvocation(new ExprStmt(new SuperConstructorAccess("super", new List<Expr>())));
        return this;
    }
}

