/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import soot.JastAddJ.Access;
import soot.JastAddJ.Annotation;
import soot.JastAddJ.BytecodeParser;
import soot.JastAddJ.CONSTANT_Class_Info;
import soot.JastAddJ.CONSTANT_Info;
import soot.JastAddJ.ClassDecl;
import soot.JastAddJ.ElementAnnotationValue;
import soot.JastAddJ.ElementArrayValue;
import soot.JastAddJ.ElementConstantValue;
import soot.JastAddJ.ElementValue;
import soot.JastAddJ.ElementValuePair;
import soot.JastAddJ.Expr;
import soot.JastAddJ.FieldDescriptor;
import soot.JastAddJ.InterfaceDecl;
import soot.JastAddJ.List;
import soot.JastAddJ.MemberClassDecl;
import soot.JastAddJ.MemberInterfaceDecl;
import soot.JastAddJ.MemberTypeDecl;
import soot.JastAddJ.Program;
import soot.JastAddJ.Signatures;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.TypeDescriptor;
import soot.JastAddJ.VarAccess;

public class Attributes {
    protected BytecodeParser p;
    protected boolean isSynthetic;

    protected Attributes(BytecodeParser parser2) {
        this.p = parser2;
        this.isSynthetic = false;
    }

    protected void processAttribute(String attribute_name, int attribute_length) {
        if (attribute_name.equals("Synthetic")) {
            this.isSynthetic = true;
        } else {
            this.p.skip(attribute_length);
        }
    }

    protected void attributes() {
        int attributes_count = this.p.u2();
        for (int j = 0; j < attributes_count; ++j) {
            int attribute_name_index = this.p.u2();
            int attribute_length = this.p.u4();
            String attribute_name = this.p.getCONSTANT_Utf8_Info(attribute_name_index).string();
            this.processAttribute(attribute_name, attribute_length);
        }
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    protected ElementValue readElementValue() {
        char c = (char)this.p.u1();
        switch (c) {
            case 'e': {
                int type_name_index = this.p.u2();
                String type_name = this.p.getCONSTANT_Utf8_Info(type_name_index).string();
                Access typeAccess = this.p.fromClassName(type_name.substring(1, type_name.length() - 1));
                int const_name_index = this.p.u2();
                String const_name = this.p.getCONSTANT_Utf8_Info(const_name_index).string();
                return new ElementConstantValue(typeAccess.qualifiesAccess(new VarAccess(const_name)));
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 's': {
                int const_value_index = this.p.u2();
                Expr e = this.p.getCONSTANT_Info(const_value_index).expr();
                return new ElementConstantValue(e);
            }
            case 'c': {
                int class_info_index = this.p.u2();
                String descriptor = this.p.getCONSTANT_Utf8_Info(class_info_index).string();
                Access e = new TypeDescriptor(this.p, descriptor).type();
                return new ElementConstantValue(e);
            }
            case '@': {
                return new ElementAnnotationValue(this.readAnnotation());
            }
            case '[': {
                int index = this.p.u2();
                List<ElementValue> list = new List<ElementValue>();
                for (int i = 0; i < index; ++i) {
                    list.add(this.readElementValue());
                }
                return new ElementArrayValue(list);
            }
        }
        throw new Error("AnnotationDefault tag " + c + " not supported");
    }

    protected Annotation readAnnotation() {
        Access typeAccess = new FieldDescriptor(this.p, "").type();
        int num_element_value_pairs = this.p.u2();
        List<ElementValuePair> list = new List<ElementValuePair>();
        for (int i = 0; i < num_element_value_pairs; ++i) {
            int element_name_index = this.p.u2();
            String element_name = this.p.getCONSTANT_Utf8_Info(element_name_index).string();
            ElementValue element_value = this.readElementValue();
            list.add(new ElementValuePair(element_name, element_value));
        }
        return new Annotation("Annotation", typeAccess, list);
    }

    public static class TypeAttributes
    extends Attributes {
        TypeDecl typeDecl;
        TypeDecl outerTypeDecl;
        Program classPath;
        private boolean isInnerClass;

        public TypeAttributes(BytecodeParser p, TypeDecl typeDecl, TypeDecl outerTypeDecl, Program classPath) {
            super(p);
            this.typeDecl = typeDecl;
            this.outerTypeDecl = outerTypeDecl;
            this.classPath = classPath;
            this.attributes();
        }

        public boolean isInnerClass() {
            return this.isInnerClass;
        }

        @Override
        protected void processAttribute(String attribute_name, int attribute_length) {
            if (attribute_name.equals("InnerClasses")) {
                this.innerClasses();
            } else if (attribute_name.equals("Signature")) {
                int signature_index = this.p.u2();
                String s2 = this.p.getCONSTANT_Utf8_Info(signature_index).string();
                Signatures.ClassSignature classSignature = new Signatures.ClassSignature(s2);
                this.typeDecl = this.typeDecl.makeGeneric(classSignature);
            } else if (attribute_name.equals("RuntimeVisibleAnnotations")) {
                int num_annotations = this.p.u2();
                for (int j = 0; j < num_annotations; ++j) {
                    Annotation a = this.readAnnotation();
                    this.typeDecl.getModifiers().addModifier(a);
                }
            } else if (attribute_name.equals("RuntimeInvisibleAnnotations")) {
                int num_annotations = this.p.u2();
                for (int j = 0; j < num_annotations; ++j) {
                    Annotation a = this.readAnnotation();
                    this.typeDecl.getModifiers().addModifier(a);
                }
            } else {
                super.processAttribute(attribute_name, attribute_length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void innerClasses() {
            int number_of_classes = this.p.u2();
            for (int i = 0; i < number_of_classes; ++i) {
                String outer_class_name;
                int inner_class_info_index = this.p.u2();
                int outer_class_info_index = this.p.u2();
                int inner_name_index = this.p.u2();
                int inner_class_access_flags = this.p.u2();
                if (inner_class_info_index <= 0) continue;
                CONSTANT_Class_Info inner_class_info = this.p.getCONSTANT_Class_Info(inner_class_info_index);
                String inner_class_name = inner_class_info.name();
                String inner_name = inner_class_name.substring(inner_class_name.lastIndexOf("$") + 1);
                if (outer_class_info_index > 0) {
                    CONSTANT_Class_Info outer_class_info = this.p.getCONSTANT_Class_Info(outer_class_info_index);
                    if (inner_class_info == null || outer_class_info == null) {
                        System.out.println("Null");
                    }
                    outer_class_name = outer_class_info.name();
                } else {
                    outer_class_name = inner_class_name.substring(0, inner_class_name.lastIndexOf("$"));
                }
                if (inner_class_info.name().equals(this.p.classInfo.name())) {
                    this.typeDecl.setID(inner_name);
                    this.typeDecl.setModifiers(BytecodeParser.modifiers(inner_class_access_flags & 0x41F));
                    if (this.p.outerClassName != null && this.p.outerClassName.equals(outer_class_name)) {
                        MemberTypeDecl m4 = null;
                        if (this.typeDecl instanceof ClassDecl) {
                            m4 = new MemberClassDecl((ClassDecl)this.typeDecl);
                            this.outerTypeDecl.addBodyDecl(m4);
                        } else if (this.typeDecl instanceof InterfaceDecl) {
                            m4 = new MemberInterfaceDecl((InterfaceDecl)this.typeDecl);
                            this.outerTypeDecl.addBodyDecl(m4);
                        }
                    } else {
                        this.isInnerClass = true;
                    }
                }
                if (!outer_class_name.equals(this.p.classInfo.name())) continue;
                try {
                    InputStream is = null;
                    try {
                        is = this.classPath.getInputStream(inner_class_name);
                        if (is != null) {
                            BytecodeParser p = new BytecodeParser(is, this.p.name);
                            p.parse(this.typeDecl, outer_class_name, this.classPath, (inner_class_access_flags & 8) == 0);
                            continue;
                        }
                        this.p.println("Error: ClassFile " + inner_class_name + " not found");
                        continue;
                    }
                    catch (Error e) {
                        if (e.getMessage().startsWith("Could not find nested type")) continue;
                        throw e;
                    }
                    finally {
                        if (is != null) {
                            is.close();
                            is = null;
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    System.out.println("Error: " + inner_class_name + " not found");
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class MethodAttributes
    extends Attributes {
        protected List exceptionList;
        protected ElementValue elementValue;
        public Signatures.MethodSignature methodSignature;
        public ArrayList annotations;
        public ArrayList[] parameterAnnotations;

        public MethodAttributes(BytecodeParser p) {
            super(p);
            this.attributes();
        }

        @Override
        protected void processAttribute(String attribute_name, int attribute_length) {
            if (attribute_name.equals("Exceptions")) {
                this.parseExceptions();
            } else if (attribute_name.equals("AnnotationDefault")) {
                this.annotationDefault();
            } else if (attribute_name.equals("Signature")) {
                int signature_index = this.p.u2();
                String s2 = this.p.getCONSTANT_Utf8_Info(signature_index).string();
                this.methodSignature = new Signatures.MethodSignature(s2);
            } else if (attribute_name.equals("RuntimeVisibleAnnotations")) {
                int num_annotations = this.p.u2();
                if (this.annotations == null) {
                    this.annotations = new ArrayList();
                }
                for (int j = 0; j < num_annotations; ++j) {
                    this.annotations.add(this.readAnnotation());
                }
            } else if (attribute_name.equals("RuntimeInvisibleAnnotations")) {
                int num_annotations = this.p.u2();
                if (this.annotations == null) {
                    this.annotations = new ArrayList();
                }
                for (int j = 0; j < num_annotations; ++j) {
                    this.annotations.add(this.readAnnotation());
                }
            } else if (attribute_name.equals("RuntimeVisibleParameterAnnotations")) {
                int num_parameters = this.p.u1();
                if (this.parameterAnnotations == null) {
                    this.parameterAnnotations = new ArrayList[num_parameters];
                }
                for (int i = 0; i < num_parameters; ++i) {
                    if (this.parameterAnnotations[i] == null) {
                        this.parameterAnnotations[i] = new ArrayList();
                    }
                    int num_annotations = this.p.u2();
                    for (int j = 0; j < num_annotations; ++j) {
                        this.parameterAnnotations[i].add(this.readAnnotation());
                    }
                }
            } else if (attribute_name.equals("RuntimeInvisibleParameterAnnotations")) {
                int num_parameters = this.p.u1();
                if (this.parameterAnnotations == null) {
                    this.parameterAnnotations = new ArrayList[num_parameters];
                }
                for (int i = 0; i < num_parameters; ++i) {
                    if (this.parameterAnnotations[i] == null) {
                        this.parameterAnnotations[i] = new ArrayList();
                    }
                    int num_annotations = this.p.u2();
                    for (int j = 0; j < num_annotations; ++j) {
                        this.parameterAnnotations[i].add(this.readAnnotation());
                    }
                }
            } else {
                super.processAttribute(attribute_name, attribute_length);
            }
        }

        private void parseExceptions() {
            int number_of_exceptions = this.p.u2();
            this.exceptionList = new List();
            for (int i = 0; i < number_of_exceptions; ++i) {
                CONSTANT_Class_Info exception = this.p.getCONSTANT_Class_Info(this.p.u2());
                this.exceptionList.add(exception.access());
            }
        }

        public List exceptionList() {
            return this.exceptionList != null ? this.exceptionList : new List();
        }

        public ElementValue elementValue() {
            return this.elementValue;
        }

        private void annotationDefault() {
            this.elementValue = this.readElementValue();
        }
    }

    public static class FieldAttributes
    extends Attributes {
        protected CONSTANT_Info constantValue;
        public ArrayList annotations;
        public Signatures.FieldSignature fieldSignature;

        public FieldAttributes(BytecodeParser p) {
            super(p);
            this.attributes();
        }

        @Override
        protected void processAttribute(String attribute_name, int attribute_length) {
            if (attribute_name.equals("ConstantValue") && attribute_length == 2) {
                int constantvalue_index = this.p.u2();
                this.constantValue = this.p.getCONSTANT_Info(constantvalue_index);
            } else if (attribute_name.equals("RuntimeVisibleAnnotations")) {
                int num_annotations = this.p.u2();
                if (this.annotations == null) {
                    this.annotations = new ArrayList();
                }
                for (int j = 0; j < num_annotations; ++j) {
                    this.annotations.add(this.readAnnotation());
                }
            } else if (attribute_name.equals("RuntimeInvisibleAnnotations")) {
                int num_annotations = this.p.u2();
                if (this.annotations == null) {
                    this.annotations = new ArrayList();
                }
                for (int j = 0; j < num_annotations; ++j) {
                    this.annotations.add(this.readAnnotation());
                }
            } else if (attribute_name.equals("Signature")) {
                int signature_index = this.p.u2();
                String s2 = this.p.getCONSTANT_Utf8_Info(signature_index).string();
                this.fieldSignature = new Signatures.FieldSignature(s2);
            } else {
                super.processAttribute(attribute_name, attribute_length);
            }
        }

        public CONSTANT_Info constantValue() {
            return this.constantValue;
        }
    }
}

