/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ClassProvider;
import soot.ClassSource;
import soot.DexClassSource;
import soot.SourceLocator;
import soot.dexpler.DexFileProvider;
import soot.dexpler.Util;
import soot.options.Options;

public class DexClassProvider
implements ClassProvider {
    private static final Logger logger = LoggerFactory.getLogger(DexClassProvider.class);

    public static Set<String> classesOfDex(DexFile dexFile) {
        HashSet<String> classes = new HashSet<String>();
        for (ClassDef classDef : dexFile.getClasses()) {
            classes.add(Util.dottedClassName(classDef.getType()));
        }
        return classes;
    }

    @Override
    public ClassSource find(String className) {
        this.ensureDexIndex();
        File file = SourceLocator.v().dexClassIndex().get(className);
        return file == null ? null : new DexClassSource(className, file);
    }

    protected void ensureDexIndex() {
        Set<String> extensions;
        SourceLocator loc = SourceLocator.v();
        Map<String, File> index = loc.dexClassIndex();
        if (index == null) {
            index = new HashMap<String, File>();
            this.buildDexIndex(index, loc.classPath());
            loc.setDexClassIndex(index);
        }
        if ((extensions = loc.getDexClassPathExtensions()) != null) {
            this.buildDexIndex(index, new ArrayList<String>(extensions));
            loc.clearDexClassPathExtensions();
        }
    }

    private void buildDexIndex(Map<String, File> index, List<String> classPath) {
        for (String path : classPath) {
            try {
                File dexFile = new File(path);
                if (!dexFile.exists()) continue;
                for (DexFileProvider.DexContainer<? extends DexFile> container2 : DexFileProvider.v().getDexFromSource(dexFile)) {
                    for (String className : DexClassProvider.classesOfDex(container2.getBase().getDexFile())) {
                        if (!index.containsKey(className)) {
                            index.put(className, container2.getFilePath());
                            continue;
                        }
                        if (!Options.v().verbose()) continue;
                        logger.debug(String.format("Warning: Duplicate of class '%s' found in dex file '%s' from source '%s'. Omitting class.", className, container2.getDexName(), container2.getFilePath().getCanonicalPath()));
                    }
                }
            }
            catch (IOException e) {
                logger.warn("IO error while processing dex file '" + path + "'");
                logger.debug("Exception: " + e);
            }
            catch (Exception e) {
                logger.warn("exception while processing dex file '" + path + "'");
                logger.debug("Exception: " + e);
            }
        }
    }
}

