/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.math.BigDecimal;
import soot.DecimalType;
import soot.Type;
import soot.jimple.ConstantSwitch;
import soot.jimple.IntConstant;
import soot.jimple.NumericConstant;
import soot.jimple.RealConstant;
import soot.util.Switch;

public class DecimalConstant
extends RealConstant {
    private static final long serialVersionUID = 0L;
    public BigDecimal value;

    public DecimalConstant(BigDecimal value) {
        this.value = value;
    }

    public static DecimalConstant v(BigDecimal b) {
        return new DecimalConstant(b);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toPlainString();
    }

    @Override
    public Type getType() {
        return DecimalType.v();
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseDecimalConstant(this);
    }

    private void assertInstanceOf(NumericConstant constant) {
        if (!(constant instanceof DecimalConstant)) {
            throw new IllegalArgumentException("DecimalConstant expected");
        }
    }

    @Override
    public NumericConstant add(NumericConstant c) {
        this.assertInstanceOf(c);
        return DecimalConstant.v(this.value.add(((DecimalConstant)c).value));
    }

    @Override
    public NumericConstant subtract(NumericConstant c) {
        this.assertInstanceOf(c);
        return DecimalConstant.v(this.value.subtract(((DecimalConstant)c).value));
    }

    @Override
    public NumericConstant multiply(NumericConstant c) {
        this.assertInstanceOf(c);
        return DecimalConstant.v(this.value.multiply(((DecimalConstant)c).value));
    }

    @Override
    public NumericConstant divide(NumericConstant c) {
        this.assertInstanceOf(c);
        return DecimalConstant.v(this.value.divide(((DecimalConstant)c).value));
    }

    @Override
    public NumericConstant remainder(NumericConstant c) {
        this.assertInstanceOf(c);
        return DecimalConstant.v(this.value.remainder(((DecimalConstant)c).value));
    }

    @Override
    public NumericConstant equalEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(this.value.compareTo(((DecimalConstant)c).value) == 0 ? 1 : 0);
    }

    @Override
    public NumericConstant notEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(this.value.compareTo(((DecimalConstant)c).value) != 0 ? 1 : 0);
    }

    @Override
    public boolean isLessThan(NumericConstant c) {
        this.assertInstanceOf(c);
        return this.value.compareTo(((DecimalConstant)c).value) < 0;
    }

    @Override
    public NumericConstant lessThan(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(this.value.compareTo(((DecimalConstant)c).value) < 0 ? 1 : 0);
    }

    @Override
    public NumericConstant lessThanOrEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(this.value.compareTo(((DecimalConstant)c).value) <= 0 ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThan(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(this.value.compareTo(((DecimalConstant)c).value) > 0 ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThanOrEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(this.value.compareTo(((DecimalConstant)c).value) >= 0 ? 1 : 0);
    }

    @Override
    public IntConstant cmpg(RealConstant constant) {
        this.assertInstanceOf(constant);
        BigDecimal cValue = ((DecimalConstant)constant).value;
        return IntConstant.v(this.value.compareTo(cValue));
    }

    @Override
    public IntConstant cmpl(RealConstant constant) {
        this.assertInstanceOf(constant);
        BigDecimal cValue = ((DecimalConstant)constant).value;
        return IntConstant.v(-this.value.compareTo(cValue));
    }

    @Override
    public NumericConstant negate() {
        return DecimalConstant.v(this.value.negate());
    }

    @Override
    public Number getNumericValue() {
        return this.value;
    }
}

