/*
 * Decompiled with CFR 0.152.
 */
package soot;

import soot.CharType;
import soot.Type;
import soot.jimple.IntConstant;

public class CharConstant
extends IntConstant {
    private static final long serialVersionUID = 0L;
    private static final int MAX_CACHE = 128;
    private static final int MIN_CACHE = -127;
    private static final int ABS_MIN_CACHE = Math.abs(-127);
    private static final CharConstant[] CACHED = new CharConstant[129 + ABS_MIN_CACHE];

    public CharConstant(char value) {
        super(value);
    }

    public CharConstant(int value) {
        super((char)value);
    }

    public static CharConstant v(int value) {
        if (value >= -127 && value <= 128) {
            int idx = value + ABS_MIN_CACHE;
            CharConstant c = CACHED[idx];
            if (c != null) {
                return c;
            }
            CharConstant.CACHED[idx] = c = new CharConstant(value);
            return c;
        }
        return new CharConstant(value);
    }

    public char getChar() {
        return (char)this.value;
    }

    @Override
    public Type getType() {
        return CharType.v();
    }
}

