/*
 * Decompiled with CFR 0.152.
 */
package soot;

import soot.BooleanType;
import soot.Type;
import soot.jimple.IntConstant;

public class BooleanConstant
extends IntConstant {
    private static final String FALSE_CONSTANT = "false";
    private static final String TRUE_CONSTANT = "true";
    private static final long serialVersionUID = 0L;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    public static final BooleanConstant TRUE_C = new BooleanConstant(true);
    public static final BooleanConstant FALSE_C = new BooleanConstant(false);

    public BooleanConstant(boolean value) {
        super(value ? 1 : 0);
    }

    public static BooleanConstant v(boolean b) {
        if (b) {
            return TRUE_C;
        }
        return FALSE_C;
    }

    @Override
    public String toString() {
        if (this.value == 1) {
            return TRUE_CONSTANT;
        }
        return FALSE_CONSTANT;
    }

    public boolean getBoolean() {
        return this.value == 1;
    }

    @Override
    public Type getType() {
        return BooleanType.v();
    }
}

