/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.PrimType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Timers;
import soot.Type;
import soot.TypeSwitch;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.baf.DoubleWordType;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityStmt;
import soot.options.Options;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Attribute;
import soot.tagkit.Base64;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;
import soot.toolkits.graph.Block;
import soot.util.StringTools;

public abstract class AbstractJasminClass {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJasminClass.class);
    protected Map<Unit, String> unitToLabel;
    protected Map<Local, Integer> localToSlot;
    protected Map<Unit, Integer> subroutineToReturnAddressSlot;
    protected List<String> code;
    protected boolean isEmittingMethodCode;
    protected int labelCount;
    protected boolean isNextGotoAJsr;
    protected int returnAddressSlot;
    protected int currentStackHeight = 0;
    protected int maxStackHeight = 0;
    protected Map<Local, Object> localToGroup;
    protected Map<Object, Integer> groupToColorCount;
    protected Map<Local, Integer> localToColor;
    protected Map<Block, Integer> blockToStackHeight = new HashMap<Block, Integer>();
    protected Map<Block, Integer> blockToLogicalStackHeight = new HashMap<Block, Integer>();

    public static String slashify(String s2) {
        return s2.replace('.', '/');
    }

    public static int sizeOfType(Type t2) {
        if (t2 instanceof DoubleWordType || t2 instanceof LongType || t2 instanceof DoubleType) {
            return 2;
        }
        if (t2 instanceof VoidType) {
            return 0;
        }
        return 1;
    }

    public static int argCountOf(SootMethodRef m4) {
        int argCount = 0;
        for (Type t2 : m4.parameterTypes()) {
            argCount += AbstractJasminClass.sizeOfType(t2);
        }
        return argCount;
    }

    public static String jasminDescriptorOf(Type type) {
        TypeSwitch<String> sw = new TypeSwitch<String>(){

            @Override
            public void caseBooleanType(BooleanType t2) {
                this.setResult("Z");
            }

            @Override
            public void caseByteType(ByteType t2) {
                this.setResult("B");
            }

            @Override
            public void caseCharType(CharType t2) {
                this.setResult("C");
            }

            @Override
            public void caseDoubleType(DoubleType t2) {
                this.setResult("D");
            }

            @Override
            public void caseFloatType(FloatType t2) {
                this.setResult("F");
            }

            @Override
            public void caseIntType(IntType t2) {
                this.setResult("I");
            }

            @Override
            public void caseLongType(LongType t2) {
                this.setResult("J");
            }

            @Override
            public void caseShortType(ShortType t2) {
                this.setResult("S");
            }

            @Override
            public void defaultCase(Type t2) {
                throw new RuntimeException("Invalid type: " + t2);
            }

            @Override
            public void caseArrayType(ArrayType t2) {
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < t2.numDimensions; ++i) {
                    buffer.append('[');
                }
                buffer.append(AbstractJasminClass.jasminDescriptorOf(t2.baseType));
                this.setResult(buffer.toString());
            }

            @Override
            public void caseRefType(RefType t2) {
                this.setResult("L" + t2.getClassName().replace('.', '/') + ";");
            }

            @Override
            public void caseVoidType(VoidType t2) {
                this.setResult("V");
            }
        };
        type.apply(sw);
        return (String)sw.getResult();
    }

    public static String jasminDescriptorOf(SootMethodRef m4) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        for (Type t2 : m4.parameterTypes()) {
            buffer.append(AbstractJasminClass.jasminDescriptorOf(t2));
        }
        buffer.append(')');
        buffer.append(AbstractJasminClass.jasminDescriptorOf(m4.returnType()));
        return buffer.toString();
    }

    protected void emit(String s2) {
        this.okayEmit(s2);
    }

    protected void okayEmit(String s2) {
        if (this.isEmittingMethodCode && !s2.endsWith(":")) {
            this.code.add("    " + s2);
        } else {
            this.code.add(s2);
        }
    }

    private String getVisibilityAnnotationAttr(VisibilityAnnotationTag tag) {
        if (tag == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        switch (tag.getVisibility()) {
            case 0: {
                sb.append(".runtime_visible_annotation\n");
                break;
            }
            case 1: {
                sb.append(".runtime_invisible_annotation\n");
                break;
            }
            default: {
                return "";
            }
        }
        if (tag.hasAnnotations()) {
            for (AnnotationTag annot : tag.getAnnotations()) {
                sb.append(".annotation ");
                sb.append(StringTools.getQuotedStringOf(annot.getType())).append('\n');
                for (AnnotationElem ae : annot.getElems()) {
                    sb.append(this.getElemAttr(ae));
                }
                sb.append(".end .annotation\n");
            }
        }
        sb.append(".end .annotation_attr\n");
        return sb.toString();
    }

    private String getVisibilityParameterAnnotationAttr(VisibilityParameterAnnotationTag tag) {
        StringBuilder sb = new StringBuilder();
        sb.append(".param ");
        if (tag.getKind() == 0) {
            sb.append(".runtime_visible_annotation\n");
        } else {
            sb.append(".runtime_invisible_annotation\n");
        }
        ArrayList<VisibilityAnnotationTag> vis_list = tag.getVisibilityAnnotations();
        if (vis_list != null) {
            for (VisibilityAnnotationTag vat : vis_list) {
                VisibilityAnnotationTag safeVat = vat == null ? SafeVisibilityAnnotationTags.get(tag.getKind()) : vat;
                sb.append(this.getVisibilityAnnotationAttr(safeVat));
            }
        }
        sb.append(".end .param\n");
        return sb.toString();
    }

    private String getElemAttr(AnnotationElem elem) {
        StringBuilder result = new StringBuilder(".elem ");
        switch (elem.getKind()) {
            case 'Z': {
                result.append(".bool_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                if (elem instanceof AnnotationIntElem) {
                    result.append(((AnnotationIntElem)elem).getValue());
                } else {
                    result.append(((AnnotationBooleanElem)elem).getValue() ? 1 : 0);
                }
                result.append('\n');
                break;
            }
            case 'S': {
                result.append(".short_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append(((AnnotationIntElem)elem).getValue());
                result.append('\n');
                break;
            }
            case 'B': {
                result.append(".byte_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append(((AnnotationIntElem)elem).getValue());
                result.append('\n');
                break;
            }
            case 'C': {
                result.append(".char_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append(((AnnotationIntElem)elem).getValue());
                result.append('\n');
                break;
            }
            case 'I': {
                result.append(".int_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append(((AnnotationIntElem)elem).getValue());
                result.append('\n');
                break;
            }
            case 'J': {
                result.append(".long_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append(((AnnotationLongElem)elem).getValue());
                result.append('\n');
                break;
            }
            case 'F': {
                result.append(".float_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append(((AnnotationFloatElem)elem).getValue());
                result.append('\n');
                break;
            }
            case 'D': {
                result.append(".doub_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append(((AnnotationDoubleElem)elem).getValue());
                result.append('\n');
                break;
            }
            case 's': {
                result.append(".str_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append(StringTools.getQuotedStringOf(((AnnotationStringElem)elem).getValue()));
                result.append('\n');
                break;
            }
            case 'e': {
                result.append(".enum_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append(StringTools.getQuotedStringOf(((AnnotationEnumElem)elem).getTypeName()));
                result.append(' ');
                result.append(StringTools.getQuotedStringOf(((AnnotationEnumElem)elem).getConstantName()));
                result.append('\n');
                break;
            }
            case 'c': {
                result.append(".cls_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append(StringTools.getQuotedStringOf(((AnnotationClassElem)elem).getDesc()));
                result.append('\n');
                break;
            }
            case '[': {
                result.append(".arr_kind ");
                result.append('\"').append(elem.getName()).append("\" ");
                result.append('\n');
                AnnotationArrayElem arrayElem = (AnnotationArrayElem)elem;
                for (int i = 0; i < arrayElem.getNumValues(); ++i) {
                    result.append(this.getElemAttr(arrayElem.getValueAt(i)));
                }
                result.append(".end .arr_elem\n");
                break;
            }
            case '@': {
                result.append(".ann_kind ");
                result.append('\"').append(elem.getName()).append("\"\n");
                AnnotationTag annot = ((AnnotationAnnotationElem)elem).getValue();
                result.append(".annotation ");
                result.append(StringTools.getQuotedStringOf(annot.getType())).append('\n');
                for (AnnotationElem ae : annot.getElems()) {
                    result.append(this.getElemAttr(ae));
                }
                result.append(".end .annotation\n");
                result.append(".end .annot_elem\n");
                break;
            }
            default: {
                throw new RuntimeException("Unknown Elem Attr Kind: " + elem.getKind());
            }
        }
        return result.toString();
    }

    public AbstractJasminClass(SootClass sootClass) {
        Iterator<SootField> sigTag;
        EnclosingMethodTag eMethTag;
        List<InnerClassTag> specs;
        InnerClassAttribute ica;
        SourceFileTag tag2;
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.start();
        }
        if (Options.v().verbose()) {
            logger.debug("[" + sootClass.getName() + "] Constructing baf.JasminClass...");
        }
        this.code = new LinkedList<String>();
        int modifiers = sootClass.getModifiers();
        if (!Options.v().no_output_source_file_attribute() && (tag2 = (SourceFileTag)sootClass.getTag("SourceFileTag")) != null) {
            Iterator<InnerClassTag> srcName = tag2.getSourceFile();
            if (File.separatorChar == '\\') {
                srcName = ((String)((Object)srcName)).replace('\\', '/');
            }
            srcName = StringTools.getEscapedStringOf((String)((Object)srcName));
            if (!Options.v().android_jars().isEmpty() && !((String)((Object)srcName)).isEmpty() && Character.isDigit(((String)((Object)srcName)).charAt(0))) {
                srcName = "n_" + (String)((Object)srcName);
            }
            srcName = ((String)((Object)srcName)).replace(" ", "-");
            if (!((String)((Object)(srcName = ((String)((Object)srcName)).replace("\"", "")))).isEmpty()) {
                this.emit(".source " + (String)((Object)srcName));
            }
        }
        if (Modifier.isInterface(modifiers)) {
            this.emit(".interface " + Modifier.toString(modifiers -= 512) + " " + AbstractJasminClass.slashify(sootClass.getName()));
        } else {
            this.emit(".class " + Modifier.toString(modifiers) + " " + AbstractJasminClass.slashify(sootClass.getName()));
        }
        if (sootClass.hasSuperclass()) {
            this.emit(".super " + AbstractJasminClass.slashify(sootClass.getSuperclass().getName()));
        } else {
            this.emit(".no_super");
        }
        this.emit("");
        for (SootClass inter : sootClass.getInterfaces()) {
            this.emit(".implements " + AbstractJasminClass.slashify(inter.getName()));
        }
        for (Tag tag : sootClass.getTags()) {
            if (!(tag instanceof Attribute)) continue;
            this.emit(".class_attribute " + tag.getName() + " \"" + String.valueOf(Base64.encode(((Attribute)tag).getValue())) + "\"");
        }
        if (sootClass.hasTag("SyntheticTag") || Modifier.isSynthetic(sootClass.getModifiers())) {
            this.emit(".synthetic\n");
        }
        if (!Options.v().no_output_inner_classes_attribute() && (ica = (InnerClassAttribute)sootClass.getTag("InnerClassAttribute")) != null && !(specs = ica.getSpecs()).isEmpty()) {
            this.emit(".inner_class_attr ");
            for (InnerClassTag innerClassTag : specs) {
                StringBuilder str = new StringBuilder(".inner_class_spec_attr ");
                str.append('\"').append(innerClassTag.getInnerClass()).append("\" ");
                str.append('\"').append(innerClassTag.getOuterClass()).append("\" ");
                str.append('\"').append(innerClassTag.getShortName()).append("\" ");
                str.append(Modifier.toString(innerClassTag.getAccessFlags()));
                str.append(" .end .inner_class_spec_attr");
                this.emit(str.toString());
            }
            this.emit(".end .inner_class_attr\n");
        }
        if ((eMethTag = (EnclosingMethodTag)sootClass.getTag("EnclosingMethodTag")) != null) {
            StringBuilder encMeth = new StringBuilder(".enclosing_method_attr ");
            encMeth.append('\"').append(eMethTag.getEnclosingClass()).append("\" ");
            encMeth.append('\"').append(eMethTag.getEnclosingMethod()).append("\" ");
            encMeth.append('\"').append(eMethTag.getEnclosingMethodSig()).append("\"\n");
            this.emit(encMeth.toString());
        }
        if (sootClass.hasTag("DeprecatedTag")) {
            this.emit(".deprecated\n");
        }
        if ((sigTag = (SignatureTag)sootClass.getTag("SignatureTag")) != null) {
            this.emit(".signature_attr \"" + ((SignatureTag)((Object)sigTag)).getSignature() + "\"\n");
        }
        for (Tag t2 : sootClass.getTags()) {
            if (!"VisibilityAnnotationTag".equals(t2.getName())) continue;
            this.emit(this.getVisibilityAnnotationAttr((VisibilityAnnotationTag)t2));
        }
        for (SootField field : sootClass.getFields()) {
            SignatureTag signatureTag;
            StringBuilder fieldString = new StringBuilder();
            fieldString.append(".field ").append(Modifier.toString(field.getModifiers()));
            fieldString.append(" \"").append(field.getName()).append("\" ");
            fieldString.append(AbstractJasminClass.jasminDescriptorOf(field.getType()));
            block19: for (Tag t3 : field.getTags()) {
                switch (t3.getName()) {
                    case "StringConstantValueTag": {
                        fieldString.append(" = ");
                        fieldString.append(StringTools.getQuotedStringOf(((StringConstantValueTag)t3).getStringValue()));
                        break block19;
                    }
                    case "IntegerConstantValueTag": {
                        fieldString.append(" = ");
                        fieldString.append(((IntegerConstantValueTag)t3).getIntValue());
                        break block19;
                    }
                    case "LongConstantValueTag": {
                        fieldString.append(" = ");
                        fieldString.append(((LongConstantValueTag)t3).getLongValue());
                        break block19;
                    }
                    case "FloatConstantValueTag": {
                        fieldString.append(" = ");
                        fieldString.append(this.floatToString(((FloatConstantValueTag)t3).getFloatValue()));
                        break block19;
                    }
                    case "DoubleConstantValueTag": {
                        fieldString.append(" = ");
                        fieldString.append(this.doubleToString(((DoubleConstantValueTag)t3).getDoubleValue()));
                        break block19;
                    }
                    default: {
                        continue block19;
                    }
                }
            }
            if (field.hasTag("SyntheticTag") || Modifier.isSynthetic(field.getModifiers())) {
                fieldString.append(" .synthetic");
            }
            fieldString.append('\n');
            if (field.hasTag("DeprecatedTag")) {
                fieldString.append(".deprecated\n");
            }
            if ((signatureTag = (SignatureTag)field.getTag("SignatureTag")) != null) {
                fieldString.append(".signature_attr ");
                fieldString.append('\"').append(signatureTag.getSignature()).append("\"\n");
            }
            for (Tag t2 : field.getTags()) {
                if (!"VisibilityAnnotationTag".equals(t2.getName())) continue;
                fieldString.append(this.getVisibilityAnnotationAttr((VisibilityAnnotationTag)t2));
            }
            this.emit(fieldString.toString());
            for (Tag tag3 : field.getTags()) {
                if (!(tag3 instanceof Attribute)) continue;
                this.emit(".field_attribute " + tag3.getName() + " \"" + String.valueOf(Base64.encode(((Attribute)tag3).getValue())) + "\"");
            }
        }
        if (sootClass.getFieldCount() != 0) {
            this.emit("");
        }
        Iterator<SootMethod> methodIt = sootClass.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod next = methodIt.next();
            this.emitMethod(next);
            this.emit("");
        }
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.end();
        }
    }

    protected void assignColorsToLocals(Body body) {
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Assigning colors to locals...");
        }
        if (Options.v().time()) {
            Timers.v().packTimer.start();
        }
        this.localToGroup = new HashMap<Local, Object>(body.getLocalCount() * 2 + 1, 0.7f);
        this.groupToColorCount = new HashMap<Object, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        this.localToColor = new HashMap<Local, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        for (Local l : body.getLocals()) {
            PrimType g2 = AbstractJasminClass.sizeOfType(l.getType()) == 1 ? IntType.v() : LongType.v();
            this.localToGroup.put(l, g2);
            this.groupToColorCount.putIfAbsent(g2, 0);
        }
        for (Unit s2 : body.getUnits()) {
            Value leftOp;
            if (!(s2 instanceof IdentityStmt) || !((leftOp = ((IdentityStmt)s2).getLeftOp()) instanceof Local)) continue;
            Local l = (Local)leftOp;
            Object group = this.localToGroup.get(l);
            int count = this.groupToColorCount.get(group);
            this.localToColor.put(l, count);
            this.groupToColorCount.put(group, count + 1);
        }
    }

    protected void emitMethod(SootMethod method) {
        AnnotationDefaultTag annotDefTag;
        SignatureTag sigTag;
        if (method.isPhantom()) {
            return;
        }
        this.emit(".method " + Modifier.toString(method.getModifiers()) + " " + method.getName() + AbstractJasminClass.jasminDescriptorOf(method.makeRef()));
        for (SootClass exceptClass : method.getExceptions()) {
            this.emit(".throws " + exceptClass.getName());
        }
        if (method.hasTag("SyntheticTag") || Modifier.isSynthetic(method.getModifiers())) {
            this.emit(".synthetic");
        }
        if (method.hasTag("DeprecatedTag")) {
            this.emit(".deprecated");
        }
        if ((sigTag = (SignatureTag)method.getTag("SignatureTag")) != null) {
            this.emit(".signature_attr \"" + sigTag.getSignature() + "\"");
        }
        if ((annotDefTag = (AnnotationDefaultTag)method.getTag("AnnotationDefaultTag")) != null) {
            this.emit(".annotation_default " + this.getElemAttr(annotDefTag.getDefaultVal()) + ".end .annotation_default");
        }
        for (Tag t2 : method.getTags()) {
            String name = t2.getName();
            if ("VisibilityAnnotationTag".equals(name)) {
                this.emit(this.getVisibilityAnnotationAttr((VisibilityAnnotationTag)t2));
                continue;
            }
            if (!"VisibilityParameterAnnotationTag".equals(name)) continue;
            this.emit(this.getVisibilityParameterAnnotationAttr((VisibilityParameterAnnotationTag)t2));
        }
        if (method.isConcrete()) {
            if (!method.hasActiveBody()) {
                throw new RuntimeException("method: " + method.getName() + " has no active body!");
            }
            this.emitMethodBody(method);
        }
        this.emit(".end method");
        for (Tag tag : method.getTags()) {
            if (!(tag instanceof Attribute)) continue;
            this.emit(".method_attribute " + tag.getName() + " \"" + String.valueOf(Base64.encode(tag.getValue())) + "\"");
        }
    }

    protected abstract void emitMethodBody(SootMethod var1);

    public void print(PrintWriter out) {
        for (String s2 : this.code) {
            out.println(s2);
        }
    }

    protected String doubleToString(DoubleConstant v) {
        String s2;
        switch (s2 = v.toString()) {
            case "#Infinity": {
                return "+DoubleInfinity";
            }
            case "#-Infinity": {
                return "-DoubleInfinity";
            }
            case "#NaN": {
                return "+DoubleNaN";
            }
        }
        return s2;
    }

    protected String doubleToString(double d) {
        String s2;
        switch (s2 = Double.toString(d)) {
            case "NaN": {
                return "+DoubleNaN";
            }
            case "Infinity": {
                return "+DoubleInfinity";
            }
            case "-Infinity": {
                return "-DoubleInfinity";
            }
        }
        return s2;
    }

    protected String floatToString(FloatConstant v) {
        String s2;
        switch (s2 = v.toString()) {
            case "#InfinityF": {
                return "+FloatInfinity";
            }
            case "#-InfinityF": {
                return "-FloatInfinity";
            }
            case "#NaNF": {
                return "+FloatNaN";
            }
        }
        return s2;
    }

    protected String floatToString(float d) {
        String s2;
        switch (s2 = Float.toString(d)) {
            case "NaN": {
                return "+FloatNaN";
            }
            case "Infinity": {
                return "+FloatInfinity";
            }
            case "-Infinity": {
                return "-FloatInfinity";
            }
        }
        return s2;
    }

    private static class SafeVisibilityAnnotationTags {
        private static final Map<Integer, VisibilityAnnotationTag> safeVats = new HashMap<Integer, VisibilityAnnotationTag>();

        static VisibilityAnnotationTag get(int kind) {
            VisibilityAnnotationTag safeVat = safeVats.get(kind);
            if (safeVat == null) {
                safeVat = new VisibilityAnnotationTag(kind);
                safeVats.put(kind, safeVat);
            }
            return safeVat;
        }

        private SafeVisibilityAnnotationTags() {
        }
    }
}

