/*
 * Decompiled with CFR 0.152.
 */
package qilin.util.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import qilin.util.graph.DirectedGraph;
import qilin.util.graph.MergedNode;
import qilin.util.graph.StronglyConnectedComponents;

public class SCCMergedGraph<N>
implements DirectedGraph<MergedNode<N>> {
    private Set<MergedNode<N>> nodes;
    private final Map<N, MergedNode<N>> nodeMap = new HashMap<N, MergedNode<N>>();

    public SCCMergedGraph(DirectedGraph<N> graph) {
        this.init(graph);
    }

    public MergedNode<N> getMergedNode(N contentNode) {
        return this.nodeMap.get(contentNode);
    }

    @Override
    public Collection<MergedNode<N>> allNodes() {
        return this.nodes;
    }

    @Override
    public Collection<MergedNode<N>> predsOf(MergedNode<N> node) {
        return node.getPreds();
    }

    @Override
    public Collection<MergedNode<N>> succsOf(MergedNode<N> node) {
        return node.getSuccs();
    }

    private void init(DirectedGraph<N> graph) {
        this.nodes = new HashSet<MergedNode<N>>();
        StronglyConnectedComponents<N> scc = new StronglyConnectedComponents<N>(graph);
        scc.getComponents().forEach(component -> {
            MergedNode node2 = new MergedNode(component);
            component.forEach(n -> this.nodeMap.put(n, node2));
            this.nodes.add(node2);
        });
        this.nodes.forEach(node -> node.getContent().stream().map(graph::succsOf).flatMap(Collection::stream).map(this.nodeMap::get).filter(succ -> succ != node).forEach(succ -> {
            node.addSucc(succ);
            succ.addPred(node);
        }));
    }
}

