/*
 * Decompiled with CFR 0.152.
 */
package qilin.util.graph;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import qilin.util.graph.DirectedGraph;

public class Reachability<N> {
    private final DirectedGraph<N> graph;
    private final Map<N, Set<N>> reachableNodes = new HashMap<N, Set<N>>();
    private final Map<N, Set<N>> reachToNodes = new HashMap<N, Set<N>>();

    public Reachability(DirectedGraph<N> graph) {
        this.graph = graph;
    }

    public Set<N> reachableNodesFrom(N source) {
        if (!this.reachableNodes.containsKey(source)) {
            HashSet visited = new HashSet();
            ArrayDeque<N> stack = new ArrayDeque<N>();
            stack.push(source);
            while (!stack.isEmpty()) {
                Object node = stack.pop();
                visited.add(node);
                this.graph.succsOf(node).stream().filter(n -> !visited.contains(n)).forEach(stack::push);
            }
            this.reachableNodes.put(source, visited);
        }
        return this.reachableNodes.get(source);
    }

    public Set<N> nodesReach(N target) {
        if (!this.reachToNodes.containsKey(target)) {
            HashSet visited = new HashSet();
            ArrayDeque<N> stack = new ArrayDeque<N>();
            stack.push(target);
            while (!stack.isEmpty()) {
                Object node = stack.pop();
                visited.add(node);
                this.graph.predsOf(node).stream().filter(n -> !visited.contains(n)).forEach(stack::push);
            }
            this.reachToNodes.put(target, visited);
        }
        return this.reachToNodes.get(target);
    }

    public Set<N> passedNodes(N source, N target) {
        Set<N> reachableFromSource = this.reachableNodesFrom(source);
        Set<N> reachToTarget = this.nodesReach(target);
        HashSet<N> ret = new HashSet<N>(reachableFromSource);
        ret.retainAll(reachToTarget);
        return ret;
    }
}

