/*
 * Decompiled with CFR 0.152.
 */
package qilin.util.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import qilin.util.graph.DirectedGraph;

public class ConcurrentDirectedGraphImpl<N>
implements DirectedGraph<N> {
    protected Set<N> nodes = ConcurrentHashMap.newKeySet();
    protected Map<N, Set<N>> preds = new ConcurrentHashMap<N, Set<N>>();
    protected Map<N, Set<N>> succs = new ConcurrentHashMap<N, Set<N>>();

    public void addNode(N node) {
        this.nodes.add(node);
    }

    public void addEdge(N from, N to) {
        this.addNode(from);
        this.addNode(to);
        this.preds.computeIfAbsent(to, k -> ConcurrentHashMap.newKeySet()).add(from);
        this.succs.computeIfAbsent(from, k -> ConcurrentHashMap.newKeySet()).add(to);
    }

    @Override
    public Collection<N> allNodes() {
        return this.nodes;
    }

    @Override
    public Collection<N> predsOf(N n) {
        return this.preds.getOrDefault(n, Collections.emptySet());
    }

    @Override
    public Collection<N> succsOf(N n) {
        return this.succs.getOrDefault(n, Collections.emptySet());
    }
}

