/*
 * Decompiled with CFR 0.152.
 */
package qilin.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UnionFindSet<E> {
    private final Map<E, Entry> entries = new HashMap<E, Entry>();
    private int nrsets;

    public UnionFindSet(Collection<E> elems) {
        elems.forEach(elem -> this.entries.put(elem, new Entry(elem)));
        this.nrsets = this.entries.size();
    }

    public boolean union(E e1, E e2) {
        Entry root2;
        Entry root1 = this.findRoot(this.entries.get(e1));
        if (root1 == (root2 = this.findRoot(this.entries.get(e2)))) {
            return false;
        }
        if (root1.rank < root2.rank) {
            root1.parent = root2;
        } else if (root1.rank > root2.rank) {
            root2.parent = root1;
        } else {
            root2.parent = root1;
            ++root2.rank;
        }
        --this.nrsets;
        return true;
    }

    public boolean isConnected(E e1, E e2) {
        Entry root2;
        Entry root1 = this.findRoot(this.entries.get(e1));
        return root1 == (root2 = this.findRoot(this.entries.get(e2)));
    }

    public E find(E e) {
        Entry ent = this.findRoot(this.entries.get(e));
        return ent.elem;
    }

    public int numberOfSets() {
        return this.nrsets;
    }

    public Collection<Set<E>> getDisjointSets() {
        return this.entries.keySet().stream().collect(Collectors.groupingBy(this::find, Collectors.toSet())).values();
    }

    private Entry findRoot(Entry ent) {
        if (ent.parent != ent) {
            ent.parent = this.findRoot(ent.parent);
        }
        return ent.parent;
    }

    private class Entry {
        private final E elem;
        private Entry parent;
        private int rank;

        private Entry(E elem) {
            this.elem = elem;
            this.parent = this;
            this.rank = 0;
        }
    }
}

