/*
 * Decompiled with CFR 0.152.
 */
package qilin.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.core.VirtualCalls;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.context.ContextElement;
import qilin.core.context.ContextElements;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextAllocNode;
import qilin.core.pag.ContextField;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.Parm;
import qilin.core.pag.ValNode;
import qilin.core.pag.VarNode;
import qilin.core.pag.VirtualCallSite;
import qilin.core.sets.PointsToSet;
import qilin.core.sets.PointsToSetInternal;
import qilin.util.DataFactory;
import qilin.util.queue.UniqueQueue;
import soot.AnySubType;
import soot.ArrayType;
import soot.Body;
import soot.Context;
import soot.Hierarchy;
import soot.Kind;
import soot.MethodOrMethodContext;
import soot.NullType;
import soot.PrimType;
import soot.Printer;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.JimpleBody;
import soot.jimple.NewArrayExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.NumberedString;
import soot.util.dot.DotGraph;
import soot.util.dot.DotGraphNode;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public final class PTAUtils {
    private static final Logger logger = LoggerFactory.getLogger(PTAUtils.class);
    static final String output_dir = CoreConfig.v().getOutConfig().outDir;
    static Map<String, Node> nodes = new TreeMap<String, Node>();
    private static final RefType clRunnable = RefType.v("java.lang.Runnable");
    private static final String[] NO_CONTEXT = new String[]{"java.lang.Throwable", "java.lang.StringBuffer", "java.lang.StringBuilder"};
    private static Set<SootClass> ignoreList = null;
    private static final Map<SootMethod, Body> methodToBody = DataFactory.createMap();

    public static Map<LocalVarNode, Set<AllocNode>> calcStaticThisPTS(PTA pta) {
        HashMap<LocalVarNode, Set<AllocNode>> pts = new HashMap<LocalVarNode, Set<AllocNode>>();
        HashSet<SootMethod> workList = new HashSet<SootMethod>();
        PAG pag = pta.getPag();
        for (SootMethod method : pta.getNakedReachableMethods()) {
            if (!PTAUtils.isFakeMainMethod(method) && (method.isPhantom() || method.isStatic())) continue;
            MethodPAG srcmpag = pag.getMethodPAG(method);
            LocalVarNode thisRef = (LocalVarNode)srcmpag.nodeFactory().caseThis();
            PointsToSet other = pta.reachingObjects(thisRef).toCIPointsToSet();
            for (Unit u : srcmpag.getInvokeStmts()) {
                Stmt s2 = (Stmt)u;
                InvokeExpr ie = s2.getInvokeExpr();
                if (!(ie instanceof StaticInvokeExpr)) continue;
                Iterator<Edge> it = pta.getCallGraph().edgesOutOf(u);
                while (it.hasNext()) {
                    Edge e = it.next();
                    SootMethod tgtmtd = e.tgt();
                    MethodPAG tgtmpag = pag.getMethodPAG(tgtmtd);
                    MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
                    LocalVarNode tgtThisRef = (LocalVarNode)tgtnf.caseThis();
                    Set addTo = pts.computeIfAbsent(tgtThisRef, k -> new HashSet());
                    boolean returnValue = false;
                    Iterator<AllocNode> itx = other.iterator();
                    while (itx.hasNext()) {
                        AllocNode node = itx.next();
                        if (!addTo.add(node)) continue;
                        returnValue = true;
                    }
                    if (!returnValue) continue;
                    workList.add(tgtmtd);
                }
            }
        }
        while (!workList.isEmpty()) {
            SootMethod method = (SootMethod)workList.iterator().next();
            workList.remove(method);
            MethodPAG srcmpag = pag.getMethodPAG(method);
            LocalVarNode thisRef = (LocalVarNode)srcmpag.nodeFactory().caseThis();
            Set other = pts.computeIfAbsent(thisRef, k -> new HashSet());
            for (Unit u : srcmpag.getInvokeStmts()) {
                Stmt s3 = (Stmt)u;
                InvokeExpr ie = s3.getInvokeExpr();
                if (!(ie instanceof StaticInvokeExpr)) continue;
                Iterator<Edge> it = pta.getCallGraph().edgesOutOf(u);
                while (it.hasNext()) {
                    Edge e = it.next();
                    SootMethod tgtmtd = e.tgt();
                    MethodPAG tgtmpag = pag.getMethodPAG(tgtmtd);
                    MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
                    LocalVarNode tgtThisRef = (LocalVarNode)tgtnf.caseThis();
                    Set addTo = pts.computeIfAbsent(tgtThisRef, k -> new HashSet());
                    if (!addTo.addAll(other)) continue;
                    workList.add(tgtmtd);
                }
            }
        }
        return pts;
    }

    public static Object getIR(Object sparkNode) {
        if (sparkNode instanceof VarNode) {
            return ((VarNode)sparkNode).getVariable();
        }
        if (sparkNode instanceof AllocNode) {
            return ((AllocNode)sparkNode).getNewExpr();
        }
        return sparkNode;
    }

    public static boolean mustAlias(PTA pta, VarNode v1, VarNode v2) {
        PointsToSet v1pts = pta.reachingObjects(v1).toCIPointsToSet();
        PointsToSet v2pts = pta.reachingObjects(v2).toCIPointsToSet();
        return v1pts.pointsToSetEquals(v2pts);
    }

    public static void printPts(PTA pta, PointsToSet pts) {
        StringBuffer ret = new StringBuffer();
        Iterator<AllocNode> it = pts.iterator();
        while (it.hasNext()) {
            AllocNode n = it.next();
            ret.append("\t").append(n).append("\n");
        }
        System.out.print(ret);
    }

    public static void dumpCallGraph(Iterable<Edge> callgraph, boolean appOnly) {
        String filename = "callgraph";
        DotGraph canvas = PTAUtils.setDotGraph(filename);
        int mn = -1;
        HashSet<String> methodSet = new HashSet<String>();
        ArrayList<String> methodList = new ArrayList<String>();
        for (Edge edge : callgraph) {
            String dstName;
            MethodOrMethodContext srcmtd = edge.getSrc();
            if (appOnly && !srcmtd.method().getDeclaringClass().isApplicationClass()) continue;
            MethodOrMethodContext dstmtd = edge.getTgt();
            String srcName = srcmtd.toString();
            if (methodSet.add(srcName)) {
                canvas.drawNode(srcName).setLabel("" + ++mn);
                methodList.add(mn, srcName);
            }
            if (methodSet.add(dstName = dstmtd.toString())) {
                canvas.drawNode(dstName).setLabel("" + ++mn);
                methodList.add(mn, dstName);
            }
            canvas.drawEdge(srcName, dstName);
        }
        PTAUtils.plotDotGraph(canvas, filename);
        try {
            PrintWriter out = new PrintWriter(new File(output_dir, "callgraphnodes"));
            for (int i = 0; i < methodList.size(); ++i) {
                out.println(i + ":" + (String)methodList.get(i));
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void slice(CallGraph callgraph, MethodOrMethodContext method, Set<MethodOrMethodContext> set1, Set<Edge> set2) {
        Iterator<Edge> it = callgraph.edgesInto(method);
        while (it.hasNext()) {
            Edge edge = it.next();
            set2.add(edge);
            MethodOrMethodContext src = edge.getSrc();
            if (!set1.add(src)) continue;
            PTAUtils.slice(callgraph, src, set1, set2);
        }
    }

    public static void dumpSlicedCallGraph(CallGraph callgraph, MethodOrMethodContext method) {
        HashSet<MethodOrMethodContext> tgts = new HashSet<MethodOrMethodContext>();
        HashSet<Edge> edges = new HashSet<Edge>();
        tgts.add(method);
        PTAUtils.slice(callgraph, method, tgts, edges);
        PTAUtils.dumpCallGraph(edges, false);
    }

    public static void dumpSlicedCallGraph2(CallGraph callgraph, MethodOrMethodContext method) {
        HashSet<Edge> edges = new HashSet<Edge>();
        HashSet<MethodOrMethodContext> visited = new HashSet<MethodOrMethodContext>();
        UniqueQueue queue = new UniqueQueue();
        queue.add(method);
        block0: while (!queue.isEmpty()) {
            MethodOrMethodContext front = (MethodOrMethodContext)queue.poll();
            Iterator<Edge> it = callgraph.edgesInto(front);
            while (it.hasNext()) {
                Edge edge = it.next();
                MethodOrMethodContext src = edge.getSrc();
                if (!visited.add(src)) continue;
                queue.add(src);
                edges.add(edge);
                continue block0;
            }
        }
        PTAUtils.dumpCallGraph(edges, false);
    }

    public static boolean isUnresolved(Type type) {
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            type = at.getArrayElementType();
        }
        if (!(type instanceof RefType)) {
            return false;
        }
        RefType rt = (RefType)type;
        SootClass cl = rt.getSootClass();
        return cl.resolvingLevel() < 1;
    }

    public static boolean castNeverFails(Type src, Type dst) {
        if (dst == null) {
            return true;
        }
        if (dst == src) {
            return true;
        }
        if (src == null) {
            return false;
        }
        if (dst.equals(src)) {
            return true;
        }
        if (src instanceof NullType) {
            return true;
        }
        if (src instanceof AnySubType) {
            return true;
        }
        if (dst instanceof NullType) {
            return false;
        }
        if (dst instanceof AnySubType) {
            throw new RuntimeException("oops src=" + src + " dst=" + dst);
        }
        return PTAScene.v().getOrMakeFastHierarchy().canStoreType(src, dst);
    }

    public static QueueReader<SootMethod> dispatch(Type type, VirtualCallSite site) {
        ChunkedQueue<SootMethod> targetsQueue = new ChunkedQueue<SootMethod>();
        QueueReader<SootMethod> targets = targetsQueue.reader();
        if (site.kind() == Kind.THREAD && !PTAScene.v().getOrMakeFastHierarchy().canStoreType(type, clRunnable)) {
            return targets;
        }
        MethodOrMethodContext container2 = site.container();
        if (site.iie() instanceof SpecialInvokeExpr && site.kind() != Kind.THREAD) {
            SootMethod target = VirtualCalls.v().resolveSpecial((SpecialInvokeExpr)site.iie(), site.subSig(), container2.method());
            if (target != null) {
                targetsQueue.add(target);
            }
        } else {
            Type mType = site.recNode().getType();
            VirtualCalls.v().resolve(type, mType, site.subSig(), container2.method(), targetsQueue);
        }
        return targets;
    }

    public static boolean addWithTypeFiltering(PointsToSetInternal pts, Type type, Node node) {
        if (PTAUtils.castNeverFails(node.getType(), type)) {
            return pts.add(node.getNumber());
        }
        return false;
    }

    public static void dumpPts(PTA pta, boolean appOnly) {
        try {
            PrintWriter file = new PrintWriter(new File(output_dir, "pts.txt"));
            file.println("Points-to results:");
            for (ValNode vn : pta.getPag().getValNodes()) {
                if (!(vn instanceof VarNode)) continue;
                SootClass clz = null;
                if (vn instanceof LocalVarNode) {
                    SootMethod sm = ((LocalVarNode)vn).getMethod();
                    if (sm != null) {
                        clz = sm.getDeclaringClass();
                    }
                } else if (vn instanceof GlobalVarNode) {
                    GlobalVarNode gvn = (GlobalVarNode)vn;
                    clz = gvn.getDeclaringClass();
                } else if (vn instanceof ContextVarNode) {
                    ContextVarNode cv = (ContextVarNode)vn;
                    VarNode varNode = cv.base();
                    if (varNode instanceof LocalVarNode) {
                        LocalVarNode cvbase = (LocalVarNode)varNode;
                        clz = cvbase.getMethod().getDeclaringClass();
                    } else if (varNode instanceof GlobalVarNode) {
                        GlobalVarNode gvn = (GlobalVarNode)varNode;
                        clz = gvn.getDeclaringClass();
                    }
                }
                if (appOnly && clz != null && !clz.isApplicationClass()) continue;
                String label = PTAUtils.getNodeLabel(vn);
                nodes.put("[" + label + "]", vn);
                file.print(label + " -> {");
                PointsToSet p2set = pta.reachingObjects(vn);
                if (p2set == null || p2set.isEmpty()) {
                    file.print(" empty }\n");
                    continue;
                }
                Iterator<AllocNode> it = p2set.iterator();
                while (it.hasNext()) {
                    Node n = it.next();
                    label = PTAUtils.getNodeLabel(n);
                    nodes.put("[" + label + "]", n);
                    file.print(" ");
                    file.print(label);
                }
                file.print(" }\n");
            }
            PTAUtils.dumpNodeNames(file);
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public static void slicePAG(AllocNode allocNode, PAG pag, String filename) {
        HashMap<Node, Set> edges = new HashMap<Node, Set>();
        UniqueQueue queue = new UniqueQueue();
        Set<VarNode> tov = pag.allocLookup(allocNode);
        edges.computeIfAbsent(allocNode, k -> new HashSet()).addAll(tov);
        queue.addAll(tov);
        HashSet<VarNode> visited = new HashSet<VarNode>(tov);
        while (!queue.isEmpty()) {
            ValNode front = (ValNode)queue.poll();
            Set<ValNode> tovx = pag.simpleLookup(front);
            Set set = edges.computeIfAbsent(front, k -> new HashSet());
            for (ValNode vn : tovx) {
                if (!set.add(vn)) continue;
                queue.add(vn);
                visited.add((VarNode)vn);
            }
        }
        DotGraph canvas = PTAUtils.setDotGraph("hello");
        edges.forEach((n, elements) -> {
            PTAUtils.drawNode(canvas, n);
            elements.forEach(element -> {
                PTAUtils.drawNode(canvas, element);
                PTAUtils.drawEdge(canvas, n, element, "black");
            });
        });
        canvas.plot(filename);
        for (Node node : visited) {
            System.out.println(node);
        }
    }

    public static void dumpMPAG(PAG pag, SootMethod method) {
        String filename = method.getSignature() + ".dot";
        DotGraph canvas = PTAUtils.setDotGraph(filename);
        Object reader = pag.getMethodPAG(method).getInternalReader().clone();
        while (((QueueReader)reader).hasNext()) {
            Node src = (Node)((QueueReader)reader).next();
            Node dst = (Node)((QueueReader)reader).next();
            PTAUtils.drawNode(canvas, src);
            PTAUtils.drawNode(canvas, dst);
            String color = src instanceof AllocNode ? "green" : (src instanceof FieldRefNode ? "red" : (dst instanceof FieldRefNode ? "blue" : "black"));
            PTAUtils.drawEdge(canvas, src, dst, color);
        }
        PTAUtils.plotDotGraph(canvas, filename);
    }

    public static void dumpMPAGs(PTA pta, String filename) {
        DotGraph canvas = PTAUtils.setDotGraph(filename);
        for (SootMethod m4 : pta.getNakedReachableMethods()) {
            Object reader = pta.getPag().getMethodPAG(m4).getInternalReader().clone();
            while (((QueueReader)reader).hasNext()) {
                Node src = (Node)((QueueReader)reader).next();
                Node dst = (Node)((QueueReader)reader).next();
                PTAUtils.drawNode(canvas, src);
                PTAUtils.drawNode(canvas, dst);
                String color = src instanceof AllocNode ? "green" : (src instanceof FieldRefNode ? "red" : (dst instanceof FieldRefNode ? "blue" : "black"));
                PTAUtils.drawEdge(canvas, src, dst, color);
            }
        }
        PTAUtils.plotDotGraph(canvas, filename);
    }

    public static void dumpPAG(PAG pag, String filename) {
        DotGraph canvas = PTAUtils.setDotGraph(filename);
        PTAUtils.drawPAGMap(canvas, pag.getAlloc(), "green");
        PTAUtils.drawPAGMap(canvas, pag.getSimple(), "black");
        PTAUtils.drawInvPAGMap(canvas, pag.getStoreInv(), "blue");
        PTAUtils.drawPAGMap(canvas, pag.getLoad(), "red");
        HashSet nodes = new HashSet();
        pag.getAlloc().forEach((k, v) -> {
            nodes.add(k);
            nodes.addAll(v);
        });
        pag.getSimple().forEach((k, v) -> {
            nodes.add(k);
            nodes.addAll(v);
        });
        pag.getStoreInv().forEach((k, v) -> {
            nodes.add(k);
            nodes.addAll(v);
        });
        pag.getLoad().forEach((k, v) -> {
            nodes.add(k);
            nodes.addAll(v);
        });
        nodes.forEach(node -> PTAUtils.drawNode(canvas, node));
        PTAUtils.plotDotGraph(canvas, filename);
    }

    private static void plotDotGraph(DotGraph canvas, String filename) {
        canvas.plot(output_dir + "/" + filename + ".dot");
    }

    private static DotGraph setDotGraph(String fileName) {
        DotGraph canvas = new DotGraph(fileName);
        canvas.setNodeShape("box");
        canvas.setGraphLabel(fileName);
        return canvas;
    }

    public static String getNodeLabel(Node node) {
        int num = node.getNumber();
        if (node instanceof LocalVarNode) {
            return "L" + num;
        }
        if (node instanceof ContextVarNode) {
            return "L" + num;
        }
        if (node instanceof GlobalVarNode) {
            return "G" + num;
        }
        if (node instanceof ContextField) {
            return "OF" + num;
        }
        if (node instanceof FieldRefNode) {
            return "VF" + num;
        }
        if (node instanceof AllocNode) {
            return "O" + num;
        }
        throw new RuntimeException("no such node type exists!");
    }

    private static void drawNode(DotGraph canvas, Node node) {
        DotGraphNode dotNode = canvas.drawNode(node.toString());
        dotNode.setLabel("[" + PTAUtils.getNodeLabel(node) + "]");
        nodes.put("[" + PTAUtils.getNodeLabel(node) + "]", node);
    }

    private static void drawEdge(DotGraph canvas, Node src, Node dst, String color) {
        canvas.drawEdge(src.toString(), dst.toString()).setAttribute("color", color);
    }

    private static void dumpNodeNames(PrintWriter file) {
        nodes.forEach((l, n) -> file.println(l + n));
    }

    public static void dumpNodeNames(String fileName) {
        try {
            PrintWriter out = new PrintWriter(new File(output_dir, fileName));
            PTAUtils.dumpNodeNames(out);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void drawPAGMap(DotGraph canvas, Map<? extends Node, ? extends Set<? extends Node>> map, String color) {
        map.forEach((n, elements) -> elements.forEach(element -> PTAUtils.drawEdge(canvas, n, element, color)));
    }

    private static void drawInvPAGMap(DotGraph canvas, Map<? extends Node, ? extends Set<? extends Node>> map, String color) {
        map.forEach((n, elements) -> elements.forEach(element -> PTAUtils.drawEdge(canvas, element, n, color)));
    }

    public static boolean isThrowable(Type type) {
        if (type instanceof RefType) {
            return PTAScene.v().getOrMakeFastHierarchy().canStoreType(type, RefType.v("java.lang.Throwable"));
        }
        return false;
    }

    public static boolean subtypeOfAbstractStringBuilder(Type t2) {
        if (!(t2 instanceof RefType)) {
            return false;
        }
        RefType rt = (RefType)t2;
        String s2 = rt.toString();
        return s2.equals("java.lang.StringBuffer") || s2.equals("java.lang.StringBuilder");
    }

    public static boolean supportFinalize(AllocNode heap) {
        NumberedString sigFinalize = PTAScene.v().getSubSigNumberer().findOrAdd("void finalize()");
        Type type = heap.getType();
        if (type instanceof RefType) {
            RefType refType = (RefType)type;
            if (type != RefType.v("java.lang.Object")) {
                SootMethod finalizeMethod = VirtualCalls.v().resolveNonSpecial(refType, sigFinalize);
                if (finalizeMethod != null && finalizeMethod.toString().equals("<java.lang.Object: void finalize()>")) {
                    return false;
                }
                return finalizeMethod != null;
            }
        }
        return false;
    }

    public static Context plusplusOp(AllocNode heap) {
        int s2;
        ContextElement[] array;
        if (heap instanceof ContextAllocNode) {
            ContextAllocNode csHeap = (ContextAllocNode)heap;
            ContextElements ctxElems = (ContextElements)csHeap.context();
            int ms = ctxElems.size();
            ContextElement[] oldArray = ctxElems.getElements();
            array = new ContextElement[ms + 1];
            array[0] = csHeap.base();
            System.arraycopy(oldArray, 0, array, 1, ms);
            s2 = ms + 1;
        } else {
            array = new ContextElement[]{heap};
            s2 = 1;
        }
        return new ContextElements(array, s2);
    }

    public static boolean isFakeMainMethod(SootMethod method) {
        String sig = "<FakeMain: void fakeMain()>";
        return method.getSignature().equals(sig);
    }

    private static void initEmptyHeapContextTypes() {
        if (ignoreList == null) {
            ignoreList = new HashSet<SootClass>();
            Hierarchy hierarchy = new Hierarchy();
            for (String str : NO_CONTEXT) {
                SootClass clz = PTAScene.v().getSootClass(str);
                if (clz.isInterface()) {
                    for (SootClass child : hierarchy.getSubinterfacesOfIncluding(clz)) {
                        if (child == null) continue;
                        ignoreList.add(child);
                    }
                    continue;
                }
                for (SootClass child : hierarchy.getSubclassesOfIncluding(clz)) {
                    if (child == null) continue;
                    ignoreList.add(child);
                }
            }
        }
    }

    public static boolean isOfPrimitiveBaseType(AllocNode heap) {
        Type type = heap.getType();
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return arrayType.baseType instanceof PrimType;
        }
        return false;
    }

    public static boolean isPrimitiveArrayType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return arrayType.getArrayElementType() instanceof PrimType;
        }
        return false;
    }

    public static boolean enforceEmptyContext(AllocNode probe) {
        ArrayType arrayType;
        Type type = probe.getType();
        if (type instanceof ArrayType && (arrayType = (ArrayType)type).getArrayElementType() instanceof PrimType) {
            return true;
        }
        PTAUtils.initEmptyHeapContextTypes();
        if (!ignoreList.isEmpty()) {
            SootClass allocated = PTAUtils.getSootClass(probe.getType());
            return ignoreList.contains(allocated);
        }
        return false;
    }

    public static void writeJimple(String parentDir, SootClass clz) {
        File packageDirectory = new File(parentDir + File.separator + clz.getPackageName().replace(".", File.separator));
        try {
            packageDirectory.mkdirs();
            FileOutputStream streamOut = new FileOutputStream(packageDirectory + File.separator + clz.getShortName() + ".jimple");
            PrintWriter writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
            Printer.v().printTo(clz, writerOut);
            writerOut.flush();
            writerOut.close();
            ((OutputStream)streamOut).close();
        }
        catch (Exception e) {
            logger.error("Error writing jimple to file {}", (Object)clz, (Object)e);
        }
    }

    public static void dumpJimple(String outputDir) {
        for (SootClass clz : PTAScene.v().getLibraryClasses()) {
            PTAUtils.writeJimple(outputDir, clz);
        }
        for (SootClass clz : PTAScene.v().getApplicationClasses()) {
            PTAUtils.writeJimple(outputDir, clz);
        }
    }

    public static String fromFileToClass(String name) {
        return name.substring(0, name.lastIndexOf(46)).replace(File.separatorChar, '.');
    }

    public static List<String> getClassesFromJar(JarFile jarFile) {
        LinkedList<String> classes = new LinkedList<String>();
        Enumeration<JarEntry> allEntries = jarFile.entries();
        while (allEntries.hasMoreElements()) {
            JarEntry entry = allEntries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            String clsName = name.substring(0, name.length() - 6).replace('/', '.');
            classes.add(clsName);
        }
        return classes;
    }

    public static String findMainFromMetaInfo(String appPath) {
        String mainClass = null;
        try {
            JarFile jar = new JarFile(appPath);
            Enumeration<JarEntry> allEntries = jar.entries();
            while (allEntries.hasMoreElements()) {
                JarEntry entry = allEntries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".MF")) continue;
                String urlstring = "jar:file:" + appPath + "!/" + name;
                URL url = new URL(urlstring);
                Scanner scanner = new Scanner(url.openStream());
                while (scanner.hasNext()) {
                    String string = scanner.next();
                    if (!"Main-Class:".equals(string) || !scanner.hasNext()) continue;
                    mainClass = scanner.next();
                    break;
                }
                if (mainClass == null) {
                    System.out.println("cannot find meta info.");
                }
                scanner.close();
                jar.close();
                break;
            }
        }
        catch (IOException e) {
            System.out.println("cannot find meta info.");
        }
        return mainClass;
    }

    public static SootClass getSootClass(Type type) {
        SootClass allocated = null;
        if (type instanceof RefType) {
            allocated = ((RefType)type).getSootClass();
        } else if (type instanceof ArrayType && ((ArrayType)type).getArrayElementType() instanceof RefType) {
            allocated = ((RefType)((ArrayType)type).getArrayElementType()).getSootClass();
        }
        return allocated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Body getMethodBody(SootMethod m4) {
        Body body = methodToBody.get(m4);
        if (body != null) return body;
        Class<PTAUtils> clazz = PTAUtils.class;
        synchronized (PTAUtils.class) {
            if (body != null) return body;
            body = m4.isConcrete() ? m4.retrieveActiveBody() : new JimpleBody(m4);
            methodToBody.putIfAbsent(m4, body);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return body;
        }
    }

    public static boolean isEmptyArray(AllocNode heap) {
        NewArrayExpr nae;
        Value sizeVal;
        Object var = heap.getNewExpr();
        if (var instanceof NewArrayExpr && (sizeVal = (nae = (NewArrayExpr)var).getSize()) instanceof IntConstant) {
            IntConstant size = (IntConstant)sizeVal;
            return size.value == 0;
        }
        return false;
    }

    public static LocalVarNode paramToArg(PAG pag, Stmt invokeStmt, MethodPAG srcmpag, VarNode pi) {
        LocalVarNode receiver;
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        InvokeExpr ie = invokeStmt.getInvokeExpr();
        Parm mPi = (Parm)pi.getVariable();
        LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
        if (ie instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
            receiver = pag.findLocalVarNode(iie.getBase());
        } else {
            receiver = thisRef;
        }
        if (mPi.isThis()) {
            return receiver;
        }
        if (mPi.isReturn()) {
            if (invokeStmt instanceof AssignStmt) {
                AssignStmt assignStmt = (AssignStmt)invokeStmt;
                Value mR = assignStmt.getLeftOp();
                return (LocalVarNode)pag.findValNode(mR);
            }
            return null;
        }
        if (mPi.isThrowRet()) {
            return srcnf.makeInvokeStmtThrowVarNode(invokeStmt, srcmpag.getMethod());
        }
        Value arg = ie.getArg(mPi.getIndex());
        if (arg == null) {
            return null;
        }
        return pag.findLocalVarNode(arg);
    }

    public static Set<SootMethod> clinitsOf(SootClass cl) {
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        HashSet<SootClass> visit = new HashSet<SootClass>();
        UniqueQueue worklist = new UniqueQueue();
        for (SootClass curr = cl; curr != null; curr = curr.getSuperclassUnsafe()) {
            worklist.add(curr);
        }
        while (!worklist.isEmpty()) {
            SootClass sc = (SootClass)worklist.poll();
            if (!visit.add(sc)) continue;
            worklist.addAll(sc.getInterfaces());
        }
        for (SootClass sc : visit) {
            SootMethod initStart = sc.getMethodUnsafe(Scene.v().getSubSigNumberer().findOrAdd("void <clinit>()"));
            if (initStart == null) continue;
            ret.add(initStart);
        }
        return ret;
    }
}

