/*
 * Decompiled with CFR 0.152.
 */
package qilin.util;

import java.util.Timer;
import java.util.TimerTask;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class MemoryWatcher
extends Timer {
    private final long pid;
    private final String name;
    private final long[] maxMemory;
    private TimerTask task;

    public MemoryWatcher(long pid, String name) {
        this.pid = pid;
        this.name = name;
        this.maxMemory = new long[1];
    }

    public void start() {
        this.maxMemory[0] = 0L;
        this.task = new TimerTask(){

            @Override
            public void run() {
                SystemInfo si = new SystemInfo();
                OperatingSystem os = si.getOperatingSystem();
                OSProcess process = os.getProcess((int)MemoryWatcher.this.pid);
                long mem = process.getResidentSetSize();
                if (mem > MemoryWatcher.this.maxMemory[0]) {
                    MemoryWatcher.this.maxMemory[0] = mem;
                }
            }
        };
        this.schedule(this.task, 0L, 100L);
    }

    public void stop() {
        this.task.cancel();
        this.cancel();
    }

    public double inKiloByte() {
        return (double)this.maxMemory[0] / 1024.0;
    }

    public double inMegaByte() {
        return (double)this.maxMemory[0] / 1048576.0;
    }

    public double inGigaByte() {
        return (double)this.maxMemory[0] / 1.073741824E9;
    }

    public String toString() {
        return String.format("%s consumed memory: %.2f MB", this.name, this.inMegaByte());
    }
}

