/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.sets.PointsToSet;
import qilin.stat.AbstractStat;
import qilin.stat.Exporter;
import soot.MethodOrMethodContext;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;

public class YummyStat
implements AbstractStat {
    private final PTA pta;
    private long singleCallCnt;
    private long singleReceiverCnt;
    private long singleCallSingleReceiverCnt;
    private final Set<SootMethod> singleCalls = new HashSet<SootMethod>();
    private final Set<SootMethod> singleReceivers = new HashSet<SootMethod>();
    private final Set<SootMethod> singleCallSingleReceivers = new HashSet<SootMethod>();

    public YummyStat(PTA pta) {
        this.pta = pta;
        this.init();
    }

    private void init() {
        HashMap<SootMethod, Set> target2callsites = new HashMap<SootMethod, Set>();
        CallGraph ciCallGraph = this.pta.getCallGraph();
        for (Edge edge : ciCallGraph) {
            Unit callUnit = edge.srcUnit();
            SootMethod target = edge.tgt();
            if (callUnit == null || target == null) continue;
            target2callsites.computeIfAbsent(target, k -> new HashSet()).add(callUnit);
        }
        target2callsites.entrySet().stream().filter(e -> ((Set)e.getValue()).size() == 1).map(Map.Entry::getKey).filter(m4 -> !m4.isStatic()).forEach(this.singleCalls::add);
        this.singleCallCnt = this.singleCalls.size();
        HashSet<SootMethod> instanceReachables = new HashSet<SootMethod>();
        for (MethodOrMethodContext momc : this.pta.getReachableMethods()) {
            SootMethod method = momc.method();
            if (method.isPhantom() || method.isStatic()) continue;
            instanceReachables.add(method);
        }
        for (SootMethod method : instanceReachables) {
            MethodNodeFactory nf = this.pta.getPag().getMethodPAG(method).nodeFactory();
            PointsToSet pts = this.pta.reachingObjects(nf.caseThis()).toCIPointsToSet();
            int ptSize = pts.size();
            if (ptSize != 1) continue;
            this.singleReceivers.add(method);
        }
        this.singleReceiverCnt = this.singleReceivers.size();
        this.singleCalls.stream().filter(this.singleReceivers::contains).forEach(this.singleCallSingleReceivers::add);
        this.singleCallSingleReceiverCnt = this.singleCallSingleReceivers.size();
    }

    @Override
    public void export(Exporter exporter) {
        exporter.collectMetric("#Single-Call Methods:", String.valueOf(this.singleCallCnt));
        exporter.collectMetric("#Single-Receiver Methods:", String.valueOf(this.singleReceiverCnt));
        exporter.collectMetric("#Single-Call-Single-Receiver Methods:", String.valueOf(this.singleCallSingleReceiverCnt));
        if (CoreConfig.v().getOutConfig().dumpStats) {
            exporter.dumpSingleCallMethods(this.singleCalls);
            exporter.dumpSingleReceiverMethods(this.singleReceivers);
            exporter.dumpSingleCallSingleReceiverMethods(this.singleCallSingleReceivers);
        }
    }
}

