/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.builder.FakeMainFactory;
import qilin.core.pag.AllocNode;
import qilin.stat.AbstractStat;
import qilin.stat.Exporter;
import qilin.util.PTAUtils;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.RefLikeType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;

public class TypeClientStat
implements AbstractStat {
    private final PTA pta;
    private int totalCasts = 0;
    private int appCasts = 0;
    private int totalCastsMayFail = 0;
    private int appCastsMayFail = 0;
    private int totalVirtualCalls = 0;
    private int appVirtualCalls = 0;
    private int totalPolyCalls = 0;
    private int appPolyCalls = 0;
    private int totalStaticCalls = 0;
    private int totalPolyCallTargets = 0;
    private int unreachable = 0;
    private final Map<InvokeExpr, SootMethod> polyCalls = new HashMap<InvokeExpr, SootMethod>();
    private final Map<SootMethod, Set<Stmt>> mayFailCasts = new HashMap<SootMethod, Set<Stmt>>();

    public TypeClientStat(PTA pta) {
        this.pta = pta;
        this.init();
    }

    private void init() {
        CallGraph callGraph = this.pta.getCallGraph();
        HashSet<SootMethod> reachableMethods = new HashSet<SootMethod>();
        for (MethodOrMethodContext momc : this.pta.getCgb().getReachableMethods()) {
            SootMethod sm = momc.method();
            reachableMethods.add(sm);
        }
        for (SootMethod sm : reachableMethods) {
            boolean app = sm.getDeclaringClass().isApplicationClass();
            for (Unit unit : PTAUtils.getMethodBody(sm).getUnits()) {
                Stmt st = (Stmt)unit;
                if (st.containsInvokeExpr()) {
                    InvokeExpr ie = st.getInvokeExpr();
                    if (ie instanceof StaticInvokeExpr) {
                        ++this.totalStaticCalls;
                        continue;
                    }
                    ++this.totalVirtualCalls;
                    if (app) {
                        ++this.appVirtualCalls;
                    }
                    HashSet<SootMethod> targets = new HashSet<SootMethod>();
                    Iterator<Edge> it = callGraph.edgesOutOf(st);
                    while (it.hasNext()) {
                        targets.add(it.next().tgt());
                    }
                    if (targets.size() == 0) {
                        ++this.unreachable;
                    }
                    if (targets.size() <= 1) continue;
                    this.totalPolyCallTargets += targets.size();
                    ++this.totalPolyCalls;
                    this.polyCalls.put(ie, sm);
                    if (!app) continue;
                    ++this.appPolyCalls;
                    continue;
                }
                if (!(st instanceof AssignStmt)) continue;
                Value rhs = ((AssignStmt)st).getRightOp();
                Value lhs = ((AssignStmt)st).getLeftOp();
                if (!(rhs instanceof CastExpr) || !(lhs.getType() instanceof RefLikeType)) continue;
                Type targetType = ((CastExpr)rhs).getCastType();
                Value v = ((CastExpr)rhs).getOp();
                if (!(v instanceof Local)) continue;
                ++this.totalCasts;
                if (app) {
                    ++this.appCasts;
                }
                boolean fails = false;
                Collection<AllocNode> pts = this.pta.reachingObjects((Local)v).toCollection();
                for (AllocNode n : pts) {
                    if (fails) break;
                    fails = !PTAUtils.castNeverFails(n.getType(), targetType);
                }
                if (!fails) continue;
                ++this.totalCastsMayFail;
                this.mayFailCasts.computeIfAbsent(sm, k -> new HashSet()).add(st);
                if (!app) continue;
                ++this.appCastsMayFail;
            }
        }
    }

    @Override
    public void export(Exporter exporter) {
        exporter.collectMetric("#Cast (Total):", String.valueOf(this.totalCasts));
        exporter.collectMetric("#Cast (AppOnly):", String.valueOf(this.appCasts));
        exporter.collectMetric("#May Fail Cast (Total):", String.valueOf(this.totalCastsMayFail));
        exporter.collectMetric("#May Fail Cast (AppOnly):", String.valueOf(this.appCastsMayFail));
        exporter.collectMetric("#Static Call Site(Total):", String.valueOf(this.totalStaticCalls - FakeMainFactory.implicitCallEdges));
        exporter.collectMetric("#Virtual Call Site(Total):", String.valueOf(this.totalVirtualCalls));
        exporter.collectMetric("#Virtual Call Site(AppOnly):", String.valueOf(this.appVirtualCalls));
        exporter.collectMetric("#Virtual Call Site(Polymorphic):", String.valueOf(this.totalPolyCalls));
        exporter.collectMetric("#Virtual Call Site(Polymorphic AppOnly):", String.valueOf(this.appPolyCalls));
        exporter.collectMetric("#Virtual Call Site(Unreachable):", String.valueOf(this.unreachable));
        exporter.collectMetric("#Avg Poly Call Targets:", String.valueOf(1.0 * (double)this.totalPolyCallTargets / (double)this.totalPolyCalls));
        if (CoreConfig.v().getOutConfig().dumpStats) {
            exporter.dumpPolyCalls(this.polyCalls);
            exporter.dumpMayFailCasts(this.mayFailCasts);
        }
    }
}

