/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextField;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.core.sets.PointsToSet;
import qilin.stat.AbstractStat;
import qilin.stat.Exporter;
import qilin.util.PTAUtils;
import soot.Context;
import soot.Local;
import soot.RefLikeType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;

public class PointsToStat
implements AbstractStat {
    private final PTA pta;
    private final PAG pag;
    private int contextCnt = 0;
    private double avgCtxPerMthd = 0.0;
    private int ciAllocs = 0;
    private int csAllocs = 0;
    private int totalGlobalPointers = 0;
    private int totalGlobalPointsToCi = 0;
    private int totalGlobalPointsToCs = 0;
    private int appGlobalPointers = 0;
    private int appGlobalPointsToCi = 0;
    private int appGlobalPointsToCs = 0;
    private int totalLocalPointersCi = 0;
    private int totalLocalPointersCs = 0;
    private int totalLocalCiToCi = 0;
    private int totalLocalCiToCs = 0;
    private int totalLocalCsToCi = 0;
    private int totalLocalCsToCs = 0;
    private int appLocalPointersCi = 0;
    private int appLocalPointersCs = 0;
    private int appLocalCiToCi = 0;
    private int appLocalCiToCs = 0;
    private int appLocalCsToCi = 0;
    private int appLocalCsToCs = 0;
    private int totalFieldPointsToCs = 0;
    private int methodThrowCnt = 0;
    private final Map<SootMethod, PointsToSet> methodThrowPts;
    private final Set<LocalVarNode> mLocalVarNodes = new HashSet<LocalVarNode>();
    private int ptsCnt = 0;
    private int varCnt = 0;
    private final Set<LocalVarNode> mLocalVarNodesNoNative = new HashSet<LocalVarNode>();
    private int ptsCntNoNative = 0;
    private int varCntNoNative = 0;
    private final Set<String> handledNatives = Set.of("<org.apache.xerces.parsers.XML11Configuration: boolean getFeature0(java.lang.String)>", "<java.lang.ref.Finalizer: void invokeFinalizeMethod(java.lang.Object)>", "<java.lang.Thread: java.lang.Thread currentThread()>", "<java.lang.Thread: void start0()>", "<java.lang.Object: java.lang.Object clone()>", "<java.lang.System: void setIn0(java.io.InputStream)>", "<java.lang.System: void setOut0(java.io.PrintStream)>", "<java.lang.System: void setErr0(java.io.PrintStream)>", "<java.io.FileSystem: java.io.FileSystem getFileSystem()>", "<java.io.UnixFileSystem: java.lang.String[] list(java.io.File)>", "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction)>", "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction,java.security.AccessControlContext)>", "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction)>", "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction,java.security.AccessControlContext)>");

    public PointsToStat(PTA pta) {
        this.pta = pta;
        this.pag = pta.getPag();
        this.methodThrowPts = new HashMap<SootMethod, PointsToSet>();
        this.init();
    }

    protected Set<Object> getPointsToNewExpr(PointsToSet pts) {
        HashSet<Object> allocSites = new HashSet<Object>();
        Iterator<AllocNode> it = pts.iterator();
        while (it.hasNext()) {
            AllocNode n = it.next();
            allocSites.add(n.getNewExpr());
        }
        return allocSites;
    }

    private void init() {
        PointsToSet pts;
        this.ciAllocs = this.pag.getAllocNodes().size();
        this.csAllocs = this.pag.getAlloc().keySet().size();
        for (SootField global : this.pag.getGlobalPointers()) {
            try {
                if (!global.isStatic()) continue;
                GlobalVarNode gvn = this.pag.findGlobalVarNode(global);
                boolean app = gvn.getDeclaringClass().isApplicationClass();
                ++this.totalGlobalPointers;
                if (app) {
                    ++this.appGlobalPointers;
                }
                PointsToSet pts2 = this.pta.reachingObjects(gvn);
                Set<Object> allocSites = this.getPointsToNewExpr(pts2);
                this.totalGlobalPointsToCi += allocSites.size();
                this.totalGlobalPointsToCs += pts2.size();
                if (!app) continue;
                this.appGlobalPointsToCi += allocSites.size();
                this.appGlobalPointsToCs += pts2.size();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Local local : this.pag.getLocalPointers()) {
            try {
                Collection<VarNode> varNodes = this.pag.getVarNodes(local);
                LocalVarNode lvn = this.pag.findLocalVarNode(local);
                if (local.toString().contains("intermediate/")) continue;
                this.mLocalVarNodes.add(lvn);
                if (!this.handledNatives.contains(lvn.getMethod().toString())) {
                    this.mLocalVarNodesNoNative.add(lvn);
                }
                boolean app = lvn.getMethod().getDeclaringClass().isApplicationClass();
                ++this.totalLocalPointersCi;
                if (app) {
                    ++this.appLocalPointersCi;
                }
                this.totalLocalPointersCs += varNodes.size();
                if (app) {
                    this.appLocalPointersCs += varNodes.size();
                }
                pts = this.pta.reachingObjects(local);
                Set<Object> allocSites = this.getPointsToNewExpr(pts);
                this.totalLocalCiToCi += allocSites.size();
                this.totalLocalCiToCs += pts.size();
                if (app) {
                    this.appLocalCiToCi += allocSites.size();
                    this.appLocalCiToCs += pts.size();
                }
                for (VarNode cvn : varNodes) {
                    PointsToSet cpts = this.pta.reachingObjects(cvn);
                    Set<Object> callocSites = this.getPointsToNewExpr(cpts);
                    this.totalLocalCsToCi += callocSites.size();
                    this.totalLocalCsToCs += cpts.size();
                    if (!app) continue;
                    this.appLocalCsToCi += callocSites.size();
                    this.appLocalCsToCs += cpts.size();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ContextField cfvn : this.pag.getContextFields()) {
            this.totalFieldPointsToCs += cfvn.getP2Set().size();
        }
        Map<MethodPAG, Set<Context>> mpag2contexts = this.pag.getMethod2ContextsMap();
        int[] cnts = new int[2];
        mpag2contexts.forEach((k, v) -> {
            cnts[0] = cnts[0] + 1;
            cnts[1] = cnts[1] + v.size();
        });
        this.contextCnt = cnts[1];
        this.avgCtxPerMthd = (double)cnts[1] * 1.0 / (double)cnts[0];
        for (SootMethod sm : this.pta.getNakedReachableMethods()) {
            VarNode mThrow = this.pag.getMethodPAG(sm).nodeFactory().caseMethodThrow();
            pts = this.pta.reachingObjects(mThrow);
            if (pts.isEmpty()) continue;
            ++this.methodThrowCnt;
            this.methodThrowPts.put(sm, pts);
        }
        for (SootMethod sm : this.pta.getNakedReachableMethods()) {
            MethodPAG mpag = this.pag.getMethodPAG(sm);
            MethodNodeFactory mnf = mpag.nodeFactory();
            if (!sm.isStatic()) {
                this.mLocalVarNodes.add((LocalVarNode)mnf.caseThis());
                if (!this.handledNatives.contains(sm.toString())) {
                    this.mLocalVarNodesNoNative.add((LocalVarNode)mnf.caseThis());
                }
            }
            for (int i = 0; i < sm.getParameterCount(); ++i) {
                Type mType = sm.getParameterType(i);
                if (!(mType instanceof RefLikeType)) continue;
                this.mLocalVarNodes.add((LocalVarNode)mnf.caseParm(i));
                if (this.handledNatives.contains(sm.toString())) continue;
                this.mLocalVarNodesNoNative.add((LocalVarNode)mnf.caseParm(i));
            }
        }
        HashSet<LocalVarNode> tmp = new HashSet<LocalVarNode>();
        for (LocalVarNode lvn : this.mLocalVarNodes) {
            SootMethod sm = lvn.getMethod();
            if (PTAUtils.isFakeMainMethod(sm)) {
                tmp.add(lvn);
                continue;
            }
            PointsToSet cpts = this.pta.reachingObjects(lvn);
            Set<Object> callocSites = this.getPointsToNewExpr(cpts);
            if (callocSites.size() > 0) {
                this.ptsCnt += callocSites.size();
                ++this.varCnt;
                if (this.handledNatives.contains(sm.toString())) continue;
                this.ptsCntNoNative += callocSites.size();
                ++this.varCntNoNative;
                continue;
            }
            tmp.add(lvn);
        }
        this.mLocalVarNodes.removeAll(tmp);
        this.mLocalVarNodesNoNative.removeAll(tmp);
        System.out.println("PTS relation:" + this.ptsCnt);
        System.out.println("VAR CNT:" + this.varCnt);
        System.out.println("AVG PTS: " + (double)this.ptsCnt * 1.0 / (double)this.varCnt);
        System.out.println("PTS relation (no native):" + this.ptsCntNoNative);
        System.out.println("VAR CNT (no native):" + this.varCntNoNative);
        System.out.println("AVG PTS (no native): " + (double)this.ptsCntNoNative * 1.0 / (double)this.varCntNoNative);
    }

    @Override
    public void export(Exporter exporter) {
        exporter.collectMetric("#Context:", String.valueOf(this.contextCnt));
        exporter.collectMetric("#Avg Context per Method:", String.valueOf(this.avgCtxPerMthd));
        exporter.collectMetric("#Method with Throw Pointer-to:", String.valueOf(this.methodThrowCnt));
        exporter.collectMetric("#Alloc Node(CI): ", String.valueOf(this.ciAllocs));
        exporter.collectMetric("#Alloc Node(CS): ", String.valueOf(this.csAllocs));
        exporter.collectMetric("#Global CS Pointer-to Relation:", String.valueOf(this.totalGlobalPointsToCs));
        exporter.collectMetric("#Local CS Pointer-to Relation:", String.valueOf(this.totalLocalCsToCs));
        exporter.collectMetric("#Field CS Pointer-to Relation:", String.valueOf(this.totalFieldPointsToCs));
        exporter.collectMetric("#Global Pointer (lib + app):", String.valueOf(this.totalGlobalPointers));
        exporter.collectMetric("#Global Avg Points-To Target(CI):", String.valueOf((double)this.totalGlobalPointsToCi / (double)this.totalGlobalPointers));
        exporter.collectMetric("#Global Avg Points-To Target(CS):", String.valueOf((double)this.totalGlobalPointsToCs / (double)this.totalGlobalPointers));
        exporter.collectMetric("#App Global Pointer:", String.valueOf(this.appGlobalPointers));
        exporter.collectMetric("#App Global Avg Points-To Target(CI):", String.valueOf((double)this.appGlobalPointsToCi / (double)this.appGlobalPointers));
        exporter.collectMetric("#App Global Avg Points-To Target(CS):", String.valueOf((double)this.appGlobalPointsToCs / (double)this.appGlobalPointers));
        exporter.collectMetric("#Avg Points-to Target(CI):", String.valueOf((double)this.ptsCnt / (double)this.varCnt));
        exporter.collectMetric("#Avg Points-to Target without Native Var(CI):", String.valueOf((double)this.ptsCntNoNative / (double)this.varCntNoNative));
        exporter.collectMetric("#Local Pointer (lib + app):", String.valueOf(this.totalLocalPointersCi));
        exporter.collectMetric("#Local Avg Points-To Target(CI):", String.valueOf((double)this.totalLocalCiToCi / (double)this.totalLocalPointersCi));
        exporter.collectMetric("#Local Avg Points-To Target(CS):", String.valueOf((double)this.totalLocalCiToCs / (double)this.totalLocalPointersCi));
        exporter.collectMetric("#App Local Pointer:", String.valueOf(this.appLocalPointersCi));
        exporter.collectMetric("#App Local Avg Points-To Target(CI):", String.valueOf((double)this.appLocalCiToCi / (double)this.appLocalPointersCi));
        exporter.collectMetric("#App Local Avg Points-To Target(CS):", String.valueOf((double)this.appLocalCiToCs / (double)this.appLocalPointersCi));
        exporter.collectMetric("#Context Local Pointer (lib + app):", String.valueOf(this.totalLocalPointersCs));
        exporter.collectMetric("#Context Local Avg Points-To Target(CI):", String.valueOf((double)this.totalLocalCsToCi / (double)this.totalLocalPointersCs));
        exporter.collectMetric("#Context Local Avg Points-To Target(CS):", String.valueOf((double)this.totalLocalCsToCs / (double)this.totalLocalPointersCs));
        exporter.collectMetric("#App Context Local Pointer:", String.valueOf(this.appLocalPointersCs));
        exporter.collectMetric("#App Context Local Avg Points-To Target(CI):", String.valueOf((double)this.appLocalCsToCi / (double)this.appLocalPointersCs));
        exporter.collectMetric("#App Context Local Avg Points-To Target(CS):", String.valueOf((double)this.appLocalCsToCs / (double)this.appLocalPointersCs));
        if (CoreConfig.v().getOutConfig().dumpStats) {
            exporter.dumpMethodThrowPointsto(this.methodThrowPts);
            exporter.dumpReachableLocalVars(this.mLocalVarNodes);
            exporter.dumpReachableLocalVarsNoNative(this.mLocalVarNodesNoNative);
            exporter.dumpInsensPointsTo(this.mLocalVarNodes, this.pta);
        }
    }
}

