/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.util.Map;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.pag.ContextField;
import qilin.core.pag.PAG;
import qilin.core.pag.ValNode;
import qilin.core.pag.VarNode;
import qilin.stat.AbstractStat;
import qilin.stat.Exporter;

public class PAGStat
implements AbstractStat {
    private final PTA pta;
    private final PAG pag;
    private int newEdges = 0;
    private int simpleEdges = 0;
    private int hloadEdges = 0;
    private int hstoreEdges = 0;
    private int storeEdges = 0;
    private int loadEdges = 0;

    public PAGStat(PTA pta) {
        this.pta = pta;
        this.pag = pta.getPag();
        this.init();
    }

    private void init() {
        for (Set<VarNode> set : this.pag.getAlloc().values()) {
            this.newEdges += set.size();
        }
        for (Map.Entry entry : this.pag.getSimple().entrySet()) {
            Set tagets = (Set)entry.getValue();
            int nt = tagets.size();
            this.simpleEdges += nt;
            if (entry.getKey() instanceof ContextField) {
                this.hloadEdges += nt;
                continue;
            }
            for (ValNode v : tagets) {
                if (!(v instanceof ContextField)) continue;
                ++this.hstoreEdges;
            }
        }
        for (Map.Entry entry : this.pag.getStoreInv().entrySet()) {
            this.storeEdges += ((Set)entry.getValue()).size();
        }
        for (Map.Entry entry : this.pag.getLoad().entrySet()) {
            this.loadEdges += ((Set)entry.getValue()).size();
        }
    }

    @Override
    public void export(Exporter exporter) {
        exporter.collectMetric("#Alloc-pag-edge:", String.valueOf(this.newEdges));
        exporter.collectMetric("#Simple-pag-edge:", String.valueOf(this.simpleEdges));
        exporter.collectMetric("\t#Local-to-Local:", String.valueOf(this.simpleEdges - this.hloadEdges - this.hstoreEdges));
        exporter.collectMetric("\t#Field-to-Local:", String.valueOf(this.hloadEdges));
        exporter.collectMetric("\t#Local-to-Field:", String.valueOf(this.hstoreEdges));
        exporter.collectMetric("#Store-pag-edge:", String.valueOf(this.storeEdges));
        exporter.collectMetric("#Load-pag-edge:", String.valueOf(this.loadEdges));
    }
}

