/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.Parm;
import qilin.core.sets.PointsToSet;
import qilin.util.Util;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;

public class Exporter {
    private final String metrics = "Metrics.csv";
    private final String staticFPTs = "StaticFieldPointsTo.csv";
    private static final int STATLENGTH = 50;
    private final StringBuffer report = new StringBuffer();

    public void addLine(String str) {
        this.report.append(str).append('\n');
    }

    private String makeUp(String string) {
        String makeUpString = " ";
        String tmp = "";
        for (int i = 0; i < Math.max(0, 50 - string.length()); ++i) {
            tmp = tmp.concat(" ");
        }
        return string + tmp;
    }

    public void collectMetric(String desc, String value) {
        this.addLine(this.makeUp(desc) + value);
    }

    private String getFilePath(String fileName) {
        Object finalPath = CoreConfig.v().getOutConfig().outDir;
        File file = new File((String)(finalPath = (String)finalPath + File.separator + CoreConfig.v().getAppConfig().MAIN_CLASS + File.separator + CoreConfig.v().getPtaConfig().ptaName + File.separator));
        if (!file.exists()) {
            file.mkdirs();
        }
        finalPath = (String)finalPath + fileName;
        return finalPath;
    }

    private void dumpMethods(Collection<SootMethod> methods, String fileName) {
        StringBuilder builder = new StringBuilder();
        for (SootMethod sm : methods) {
            String sig = sm.getSignature();
            sig = Util.stripQuotes(sig);
            builder.append(sig);
            builder.append("\n");
        }
        String finalPath = this.getFilePath(fileName);
        Util.writeToFile(finalPath, builder.toString());
    }

    public void dumpReachableMethods(Collection<SootMethod> reachables) {
        String reachMethods = "Reachable.csv";
        this.dumpMethods(reachables, reachMethods);
    }

    public void dumpAppReachableMethods(Collection<SootMethod> appReachables) {
        String appReachMethods = "AppReachable.csv";
        this.dumpMethods(appReachables, appReachMethods);
    }

    public void dumpSingleCallMethods(Collection<SootMethod> singleCallMs) {
        String singleCalls = "SingleCallMethods.csv";
        this.dumpMethods(singleCallMs, singleCalls);
    }

    public void dumpSingleReceiverMethods(Collection<SootMethod> singleReceiverMs) {
        String singleReceivers = "SingleReceiverMethods.csv";
        this.dumpMethods(singleReceiverMs, singleReceivers);
    }

    public void dumpSingleCallSingleReceiverMethods(Collection<SootMethod> singleCallSingleReceiverMs) {
        String singleCallSingleReceivers = "SingleCallSingleReceiverMethods.csv";
        this.dumpMethods(singleCallSingleReceiverMs, singleCallSingleReceivers);
    }

    public void dumpClassTypes(Collection<SootClass> classes) {
        StringBuilder builder = new StringBuilder();
        for (SootClass sc : classes) {
            builder.append(sc.getName());
            builder.append("\n");
        }
        String classTypes = "ClassType.csv";
        String finalPath = this.getFilePath(classTypes);
        Util.writeToFile(finalPath, builder.toString());
    }

    public void dumpPolyCalls(Map<InvokeExpr, SootMethod> polys) {
        StringBuilder builder = new StringBuilder();
        for (InvokeExpr ie : polys.keySet()) {
            SootMethod tgt = ie.getMethod();
            String polySig = polys.get(ie).getSignature() + "/" + tgt.getDeclaringClass() + "." + tgt.getName() + "\n";
            builder.append(polySig);
        }
        String polyCalls = "PolyCalls.csv";
        String finalPath = this.getFilePath(polyCalls);
        Util.writeToFile(finalPath, builder.toString());
    }

    public void dumpMayFailCasts(Map<SootMethod, Set<Stmt>> casts) {
        StringBuilder builder = new StringBuilder();
        for (SootMethod sm : casts.keySet()) {
            for (Stmt stmt : casts.get(sm)) {
                AssignStmt as = (AssignStmt)stmt;
                CastExpr ce = (CastExpr)as.getRightOp();
                Type targetType = ce.getCastType();
                builder.append(sm.toString());
                builder.append("\t");
                builder.append(targetType.toString());
                builder.append("\t");
                builder.append(sm).append("/").append(ce.getOp().toString());
                builder.append("\t");
                builder.append(sm).append("/").append(as.getLeftOp().toString());
                builder.append("\n");
            }
        }
        String mayFailCasts = "MayFailCasts.csv";
        String finalPath = this.getFilePath(mayFailCasts);
        Util.writeToFile(finalPath, builder.toString());
    }

    public void dumpMethodThrowPointsto(Map<SootMethod, PointsToSet> m2pts) {
        String methodThrowPts = "MethodThrowPointsTo.csv";
        String finalPath = this.getFilePath(methodThrowPts);
        try {
            File mfile = new File(finalPath);
            mfile.delete();
            mfile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(mfile, true));
            for (SootMethod sm : m2pts.keySet()) {
                PointsToSet pts = m2pts.get(sm).toCIPointsToSet();
                Iterator<AllocNode> it = pts.iterator();
                while (it.hasNext()) {
                    AllocNode n = it.next();
                    StringBuilder builder = new StringBuilder();
                    builder.append(n.toString());
                    builder.append("\t");
                    String sig = Util.stripQuotes(sm.getSignature());
                    builder.append(sig);
                    builder.append("\n");
                    try {
                        writer.write(builder.toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dumpInsensCallGraph(CallGraph ciCallGraph) {
        String insensCallGraphEdges = "InsensCallGraphEdges.csv";
        String finalPath = this.getFilePath(insensCallGraphEdges);
        try {
            File mfile = new File(finalPath);
            mfile.delete();
            mfile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(mfile, true));
            for (Edge edge : ciCallGraph) {
                String srcSig = Util.stripQuotes(edge.src().getSignature());
                String dstSig = Util.stripQuotes(edge.tgt().getSignature());
                String str = edge.srcStmt() + " in method " + srcSig + "\t" + dstSig + "\n";
                writer.write(str);
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dumpReachableLocalVars(Collection<LocalVarNode> lvns) {
        StringBuilder builder = new StringBuilder();
        for (LocalVarNode lvn : lvns) {
            String varName = this.getDoopVarName(lvn);
            builder.append(varName).append("\n");
        }
        String insensReachVars = "InsensReachVars.csv";
        String finalPath = this.getFilePath(insensReachVars);
        Util.writeToFile(finalPath, builder.toString());
    }

    public void dumpReachableLocalVarsNoNative(Collection<LocalVarNode> lvns) {
        StringBuilder builder = new StringBuilder();
        for (LocalVarNode lvn : lvns) {
            String varName = this.getDoopVarName(lvn);
            builder.append(varName).append("\n");
        }
        String insensReachVars = "InsensReachVarsNoNatives.csv";
        String finalPath = this.getFilePath(insensReachVars);
        Util.writeToFile(finalPath, builder.toString());
    }

    private String getDoopVarName(LocalVarNode lvn) {
        SootMethod m4 = lvn.getMethod();
        Object v = lvn.getVariable();
        Object varName = v.toString();
        if (v instanceof Parm) {
            Parm parm = (Parm)v;
            if (parm.isThis()) {
                varName = "@this";
            } else if (!parm.isReturn() && !parm.isThrowRet()) {
                varName = "@parameter" + parm.getIndex();
            }
        }
        return m4.getSignature() + "/" + (String)varName;
    }

    public void dumpInsensPointsTo(Collection<LocalVarNode> lvns, PTA pta) {
        String insensVarPTs = "InsensVarPointsTo.csv";
        String finalPath = this.getFilePath(insensVarPTs);
        try {
            File mfile = new File(finalPath);
            mfile.delete();
            mfile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(mfile, true));
            for (LocalVarNode lvn : lvns) {
                String varName = this.getDoopVarName(lvn);
                HashSet<AllocNode> callocSites = new HashSet<AllocNode>();
                PointsToSet cpts = pta.reachingObjects(lvn).toCIPointsToSet();
                Iterator<AllocNode> it = cpts.iterator();
                while (it.hasNext()) {
                    AllocNode heap = it.next();
                    callocSites.add(heap);
                }
                for (AllocNode heap : callocSites) {
                    String str = heap.getNewExpr() + "\t" + varName + "\n";
                    if (heap.getMethod() != null) {
                        str = heap.getMethod() + "/" + heap.getNewExpr() + "\t" + varName + "\n";
                    }
                    writer.write(str);
                }
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String report() {
        String tmp = this.report.toString();
        if (CoreConfig.v().getOutConfig().dumpStats) {
            String statistics = "Statistics.txt";
            String finalPath = this.getFilePath(statistics);
            Util.writeToFile(finalPath, tmp);
        }
        return tmp;
    }
}

