/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.core.builder.FakeMainFactory;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.VarNode;
import qilin.stat.AbstractStat;
import qilin.stat.Exporter;
import soot.MethodOrMethodContext;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;

public class CallGraphStat
implements AbstractStat {
    private final PTA pta;
    private final Set<SootMethod> reachableMethods = new HashSet<SootMethod>();
    private int reachableStatic = 0;
    private final Set<MethodOrMethodContext> reachableParameterizedMethods = new HashSet<MethodOrMethodContext>();
    private final Set<MethodOrMethodContext> reachableAppParameterizedMethods = new HashSet<MethodOrMethodContext>();
    private final Set<SootMethod> reachableAppMethods = new HashSet<SootMethod>();
    private int reachableAppStatic = 0;
    private int CSCallEdges = 0;
    private int CSStaticToStatic = 0;
    private int CSStaticToInstance = 0;
    private int CSInstanceToStatic = 0;
    private int CSInstancetoInstance = 0;
    private int CSApp2lib = 0;
    private int CSApp2app = 0;
    private int CSLib2lib = 0;
    private int CSLib2app = 0;
    private int CICallEdges = 0;
    private int CIApp2lib = 0;
    private int CIApp2app = 0;
    private int CILib2lib = 0;
    private int CILib2app = 0;
    private int CIStaticToStatic = 0;
    private int CIStaticToInstance = 0;
    private int CIInstanceToStatic = 0;
    private int CIInstancetoInstance = 0;

    public CallGraphStat(PTA pta) {
        this.pta = pta;
        this.init();
    }

    private void init() {
        boolean fromApp;
        SootMethod srcm;
        Edge e;
        Iterator<Edge> iterator;
        boolean toApp;
        CallGraph csCallGraph = this.pta.getCgb().getCallGraph();
        this.CSCallEdges = csCallGraph.size();
        for (MethodOrMethodContext momc : this.pta.getCgb().getReachableMethods()) {
            SootMethod m4 = momc.method();
            toApp = m4.getDeclaringClass().isApplicationClass();
            this.reachableParameterizedMethods.add(momc);
            this.reachableMethods.add(m4);
            if (toApp) {
                this.reachableAppParameterizedMethods.add(momc);
                this.reachableAppMethods.add(momc.method());
            }
            iterator = csCallGraph.edgesInto(momc);
            while (iterator.hasNext()) {
                e = iterator.next();
                srcm = e.getSrc().method();
                fromApp = srcm.getDeclaringClass().isApplicationClass();
                if (fromApp && toApp) {
                    ++this.CSApp2app;
                } else if (fromApp) {
                    ++this.CSApp2lib;
                } else if (!toApp) {
                    ++this.CSLib2lib;
                } else {
                    ++this.CSLib2app;
                }
                if (e.src().isStatic()) {
                    if (e.isStatic()) {
                        ++this.CSStaticToStatic;
                        continue;
                    }
                    ++this.CSStaticToInstance;
                    continue;
                }
                if (e.isStatic()) {
                    ++this.CSInstanceToStatic;
                    continue;
                }
                ++this.CSInstancetoInstance;
            }
        }
        CallGraph ciCallGraph = this.pta.getCallGraph();
        this.CICallEdges = ciCallGraph.size();
        for (SootMethod sm : this.reachableMethods) {
            toApp = sm.getDeclaringClass().isApplicationClass();
            if (sm.isStatic()) {
                ++this.reachableStatic;
                if (toApp) {
                    ++this.reachableAppStatic;
                }
            }
            iterator = ciCallGraph.edgesInto(sm);
            while (iterator.hasNext()) {
                e = iterator.next();
                srcm = e.getSrc().method();
                fromApp = srcm.getDeclaringClass().isApplicationClass();
                if (fromApp && toApp) {
                    ++this.CIApp2app;
                } else if (fromApp) {
                    ++this.CIApp2lib;
                } else if (!toApp) {
                    ++this.CILib2lib;
                } else {
                    ++this.CILib2app;
                }
                if (e.src().isStatic()) {
                    if (e.isStatic()) {
                        ++this.CIStaticToStatic;
                        continue;
                    }
                    ++this.CIStaticToInstance;
                    continue;
                }
                if (e.isStatic()) {
                    ++this.CIInstanceToStatic;
                    continue;
                }
                ++this.CIInstancetoInstance;
            }
        }
    }

    private long thisReceiverCount() {
        return this.pta.getCgb().getReceiverToSitesMap().entrySet().stream().filter(e -> e.getKey() instanceof ContextVarNode).filter(e -> ((VarNode)e.getKey()).base() instanceof LocalVarNode).filter(e -> ((LocalVarNode)((VarNode)e.getKey()).base()).isThis()).count();
    }

    @Override
    public void export(Exporter exporter) {
        exporter.collectMetric("#Method (Static):", String.valueOf(PTAScene.v().getAllMethods().size() - 1));
        exporter.collectMetric("#Reachable Method (CI):", String.valueOf(this.reachableMethods.size() - 1));
        exporter.collectMetric("\t#Reachable-Static Method (CI):", String.valueOf(this.reachableStatic - 1));
        exporter.collectMetric("#Reachable Method (CS):", String.valueOf(this.reachableParameterizedMethods.size() - 1));
        exporter.collectMetric("#Reachable App Method (CI):", String.valueOf(this.reachableAppMethods.size()));
        exporter.collectMetric("\t#Reachable-App-Static Method (CI):", String.valueOf(this.reachableAppStatic));
        exporter.collectMetric("#Reachable App Method (CS):", String.valueOf(this.reachableAppParameterizedMethods.size()));
        exporter.collectMetric("#Call Edge(CI):", String.valueOf(this.CICallEdges - FakeMainFactory.implicitCallEdges));
        exporter.collectMetric("\t#Static-Static Call Edge(CI):", String.valueOf(this.CIStaticToStatic - FakeMainFactory.implicitCallEdges));
        exporter.collectMetric("\t#Static-Instance Call Edge(CI):", String.valueOf(this.CIStaticToInstance));
        exporter.collectMetric("\t#Instance-Static Call Edge(CI):", String.valueOf(this.CIInstanceToStatic));
        exporter.collectMetric("\t#Instance-Instance Call Edge(CI):", String.valueOf(this.CIInstancetoInstance));
        exporter.collectMetric("\t#Application-Application Call Edge(CI):", String.valueOf(this.CIApp2app));
        exporter.collectMetric("\t#Application-Library Call Edge(CI):", String.valueOf(this.CIApp2lib));
        exporter.collectMetric("\t#Library-Application Call Edge(CI):", String.valueOf(this.CILib2app));
        exporter.collectMetric("\t#Library-Library Call Edge(CI):", String.valueOf(this.CILib2lib));
        exporter.collectMetric("#Call Edge(CS):", String.valueOf(this.CSCallEdges - FakeMainFactory.implicitCallEdges));
        exporter.collectMetric("\t#Static-Static Call Edge(CS):", String.valueOf(this.CSStaticToStatic - FakeMainFactory.implicitCallEdges));
        exporter.collectMetric("\t#Static-Instance Call Edge(CS):", String.valueOf(this.CSStaticToInstance));
        exporter.collectMetric("\t#Instance-Static Call Edge(CS):", String.valueOf(this.CSInstanceToStatic));
        exporter.collectMetric("\t#Instance-Instance Call Edge(CS):", String.valueOf(this.CSInstancetoInstance));
        exporter.collectMetric("\t#Application-Application Call Edge(CS):", String.valueOf(this.CSApp2app));
        exporter.collectMetric("\t#Application-Library Call Edge(CS):", String.valueOf(this.CSApp2lib));
        exporter.collectMetric("\t#Library-Application Call Edge(CS):", String.valueOf(this.CSLib2app));
        exporter.collectMetric("\t#Library-Library Call Edge(CS):", String.valueOf(this.CSLib2lib));
        exporter.collectMetric("#receivers:", String.valueOf(this.pta.getCgb().getReceiverToSitesMap().size()));
        exporter.collectMetric("\t#thisreceivers:", String.valueOf(this.thisReceiverCount()));
        exporter.collectMetric("#avg p2s size for virtualcalls:", String.valueOf((double)(this.CSCallEdges - this.CSStaticToStatic - this.CSInstanceToStatic) * 1.0 / (double)this.pta.getCgb().getReceiverToSitesMap().size()));
        if (CoreConfig.v().getOutConfig().dumpStats) {
            exporter.dumpReachableMethods(this.reachableMethods);
            exporter.dumpAppReachableMethods(this.reachableAppMethods);
            exporter.dumpInsensCallGraph(this.pta.getCallGraph());
        }
    }
}

