/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.util.Set;
import java.util.stream.Collectors;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.stat.AbstractStat;
import qilin.stat.Exporter;
import soot.SootClass;
import soot.SootMethod;

public class BenchmarkStat
implements AbstractStat {
    private final PTA pta;
    private int classes = 0;
    private int appClasses = 0;
    private int phantomClasses = 0;
    private int libClasses = 0;
    private Set<SootClass> reachableClasses;
    private Set<SootClass> reachableAppClasses;
    int libReachableClasses = 0;

    public BenchmarkStat(PTA pta) {
        this.pta = pta;
        this.init();
    }

    private void init() {
        this.reachableClasses = this.pta.getNakedReachableMethods().stream().map(SootMethod::getDeclaringClass).collect(Collectors.toSet());
        this.reachableAppClasses = this.reachableClasses.stream().filter(SootClass::isApplicationClass).collect(Collectors.toSet());
        this.classes = PTAScene.v().getClasses().size();
        this.appClasses = PTAScene.v().getApplicationClasses().size();
        this.phantomClasses = PTAScene.v().getPhantomClasses().size();
        this.libClasses = this.classes - this.appClasses - this.phantomClasses;
        this.libReachableClasses = this.reachableClasses.size() - this.reachableAppClasses.size() - 1;
    }

    @Override
    public void export(Exporter exporter) {
        exporter.collectMetric("#Class:", String.valueOf(this.classes));
        exporter.collectMetric("#Appclass:", String.valueOf(this.appClasses));
        exporter.collectMetric("#Libclass:", String.valueOf(this.libClasses));
        exporter.collectMetric("#Phantomclass:", String.valueOf(this.phantomClasses));
        exporter.collectMetric("#Class(reachable):", String.valueOf(this.reachableClasses.size()));
        exporter.collectMetric("#Appclass(reachable):", String.valueOf(this.reachableAppClasses.size()));
        exporter.collectMetric("#Libclass(reachable):", String.valueOf(this.libReachableClasses));
        if (CoreConfig.v().getOutConfig().dumpStats) {
            exporter.dumpClassTypes(PTAScene.v().getClasses());
        }
    }
}

