/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import qilin.core.PTA;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.VarNode;
import qilin.core.sets.PointsToSet;
import qilin.stat.AbstractStat;
import qilin.stat.Exporter;
import qilin.util.Pair;
import qilin.util.Util;
import soot.Local;
import soot.SootMethod;
import soot.jimple.spark.pag.SparkField;
import soot.util.queue.QueueReader;

public class AliasStat
implements AbstractStat {
    private final PTA pta;
    Map<LocalVarNode, Set<LocalVarNode>> assignMap = new HashMap<LocalVarNode, Set<LocalVarNode>>();
    Map<SparkField, Map<Boolean, Set<LocalVarNode>>> globalMap = new HashMap<SparkField, Map<Boolean, Set<LocalVarNode>>>();
    private int intraAlias = 0;
    private int intraAlias_incstst = 0;
    private int globalAlias = 0;
    private int globalAlias_incstst = 0;
    private int intraAlias_app = 0;
    private int intraAlias_incstst_app = 0;
    private int globalAlias_app = 0;
    private int globalAlias_incstst_app = 0;

    public AliasStat(PTA pta) {
        this.pta = pta;
    }

    private Pair<Integer, Integer> recordAndComputeIntraAliases(Set<SootMethod> reachableMethods) {
        int intraAlias = 0;
        int intraAlias_incstst = 0;
        for (SootMethod m4 : reachableMethods) {
            HashMap localMap = new HashMap();
            MethodPAG srcmpag = this.pta.getPag().getMethodPAG(m4);
            Object reader = srcmpag.getInternalReader().clone();
            while (((QueueReader)reader).hasNext()) {
                FieldRefNode fr;
                LocalVarNode base;
                Node from = (Node)((QueueReader)reader).next();
                Node to = (Node)((QueueReader)reader).next();
                if (from instanceof LocalVarNode) {
                    FieldRefNode fr2;
                    LocalVarNode base2;
                    if (to instanceof LocalVarNode) {
                        if (!(((VarNode)from).getVariable() instanceof Local) || !(((VarNode)to).getVariable() instanceof Local)) continue;
                        Util.addToMap(this.assignMap, (LocalVarNode)from, (LocalVarNode)to);
                        Util.addToMap(this.assignMap, (LocalVarNode)to, (LocalVarNode)from);
                        continue;
                    }
                    if (!(to instanceof FieldRefNode) || !((base2 = (LocalVarNode)(fr2 = (FieldRefNode)to).getBase()).getVariable() instanceof Local)) continue;
                    AliasStat.addToMap(this.globalMap, fr2.getField(), true, base2);
                    AliasStat.addToMap(localMap, fr2.getField(), true, base2);
                    continue;
                }
                if (!(from instanceof FieldRefNode) || !((base = (LocalVarNode)(fr = (FieldRefNode)from).getBase()).getVariable() instanceof Local)) continue;
                AliasStat.addToMap(this.globalMap, fr.getField(), false, base);
                AliasStat.addToMap(localMap, fr.getField(), false, base);
            }
            int methodAlias = 0;
            int methodAlias_incstst = 0;
            for (Map subMap : localMap.values()) {
                Set<LocalVarNode> storeSet = subMap.getOrDefault(true, Collections.emptySet());
                Set<LocalVarNode> loadSet = subMap.getOrDefault(false, Collections.emptySet());
                int stld = this.checkAlias(storeSet, loadSet, this.assignMap) + this.checkAlias(loadSet, storeSet, this.assignMap);
                int stst = this.checkAlias(storeSet, storeSet, this.assignMap);
                methodAlias += stld;
                methodAlias_incstst += stld + stst;
            }
            intraAlias += methodAlias;
            intraAlias_incstst += methodAlias_incstst;
        }
        return new Pair<Integer, Integer>(intraAlias, intraAlias_incstst);
    }

    private Pair<Integer, Integer> computeInterAliases() {
        int globalAlias = 0;
        int globalAlias_incstst = 0;
        for (Map<Boolean, Set<LocalVarNode>> subMap : this.globalMap.values()) {
            Set<LocalVarNode> storeSet = subMap.getOrDefault(true, Collections.emptySet());
            Set<LocalVarNode> loadSet = subMap.getOrDefault(false, Collections.emptySet());
            int stld = this.checkAlias(storeSet, loadSet, this.assignMap) + this.checkAlias(loadSet, storeSet, this.assignMap);
            int stst = this.checkAlias(storeSet, storeSet, this.assignMap);
            globalAlias += stld;
            globalAlias_incstst += stld + stst;
        }
        return new Pair<Integer, Integer>(globalAlias, globalAlias_incstst);
    }

    private int checkAlias(Set<LocalVarNode> set1, Set<LocalVarNode> set2, Map<LocalVarNode, Set<LocalVarNode>> exclMap) {
        int num = 0;
        for (LocalVarNode l1 : set1) {
            Set exclSet = exclMap.getOrDefault(l1, Collections.emptySet());
            int l1Hashcode = l1.hashCode();
            for (LocalVarNode l2 : set2) {
                int l2Hashcode = l2.hashCode();
                if (l2Hashcode <= l1Hashcode || exclSet.contains(l2) || !this.checkAlias(l1, l2)) continue;
                ++num;
            }
        }
        return num;
    }

    private boolean checkAlias(LocalVarNode l1, LocalVarNode l2) {
        PointsToSet pts1 = this.pta.reachingObjects((Local)l1.getVariable());
        PointsToSet pts2 = this.pta.reachingObjects((Local)l2.getVariable());
        return pts1.hasNonEmptyIntersection(pts2);
    }

    public static <K, T, V> boolean addToMap(Map<K, Map<T, Set<V>>> m4, K key1, T key2, V value) {
        Map subMap = m4.computeIfAbsent(key1, k -> new HashMap());
        return Util.addToMap(subMap, key2, value);
    }

    public void aliasesProcessing() {
        Collection<SootMethod> reachableMethods = this.pta.getNakedReachableMethods();
        Pair<Integer, Integer> r1 = this.recordAndComputeIntraAliases(reachableMethods.stream().filter(m4 -> m4.getDeclaringClass().isApplicationClass()).collect(Collectors.toSet()));
        this.intraAlias_app = r1.getFirst();
        this.intraAlias_incstst_app = r1.getSecond();
        Pair<Integer, Integer> r2 = this.computeInterAliases();
        this.globalAlias_app = r2.getFirst();
        this.globalAlias_incstst_app = r2.getSecond();
        Pair<Integer, Integer> r3 = this.recordAndComputeIntraAliases(reachableMethods.stream().filter(m4 -> !m4.getDeclaringClass().isApplicationClass()).collect(Collectors.toSet()));
        this.intraAlias = this.intraAlias_app + r3.getFirst();
        this.intraAlias_incstst = this.intraAlias_incstst_app + r3.getSecond();
        Pair<Integer, Integer> r4 = this.computeInterAliases();
        this.globalAlias = r4.getFirst();
        this.globalAlias_incstst = r4.getSecond();
    }

    public int getGlobalAliasesIncludingStSt() {
        return this.globalAlias_incstst;
    }

    @Override
    public void export(Exporter exporter) {
        this.aliasesProcessing();
        exporter.collectMetric("#intraAlias(App):", String.valueOf(this.intraAlias_app));
        exporter.collectMetric("#intraAlias_incstst(App):", String.valueOf(this.intraAlias_incstst_app));
        exporter.collectMetric("#globalAlias(App):", String.valueOf(this.globalAlias_app));
        exporter.collectMetric("#globalAlias_incstst(App):", String.valueOf(this.globalAlias_incstst_app));
        exporter.collectMetric("#intraAlias:", String.valueOf(this.intraAlias));
        exporter.collectMetric("#intraAlias_incstst:", String.valueOf(this.intraAlias_incstst));
        exporter.collectMetric("#globalAlias:", String.valueOf(this.globalAlias));
        exporter.collectMetric("#globalAlias_incstst:", String.valueOf(this.globalAlias_incstst));
    }
}

