/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.tools;

import java.util.HashSet;
import java.util.Set;
import qilin.core.pag.AllocNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.VarNode;
import qilin.parm.ctxcons.CtxConstructor;
import qilin.parm.heapabst.AllocSiteAbstractor;
import qilin.parm.heapabst.HeuristicAbstractor;
import qilin.parm.select.HeuristicSelector;
import qilin.parm.select.PartialMethodLvSelector;
import qilin.parm.select.PipelineSelector;
import qilin.pta.PTAConfig;
import qilin.pta.toolkits.zipper.Main;
import qilin.pta.tools.Spark;
import qilin.pta.tools.StagedPTA;
import qilin.util.Stopwatch;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.RefLikeType;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.util.queue.QueueReader;

public class ZipperPTA
extends StagedPTA {
    private final Set<SootMethod> PCMs = new HashSet<SootMethod>();

    public ZipperPTA(int k, int hk, CtxConstructor ctxCons) {
        this.ctxCons = ctxCons;
        PartialMethodLvSelector us = new PartialMethodLvSelector(k, hk, this.PCMs);
        this.ctxSel = PTAConfig.v().getPtaConfig().enforceEmptyCtxForIgnoreTypes ? new PipelineSelector(new HeuristicSelector(), us) : us;
        this.heapAbst = PTAConfig.v().getPtaConfig().mergeHeap ? new HeuristicAbstractor(this.pag) : new AllocSiteAbstractor();
        this.prePTA = new Spark();
    }

    @Override
    protected void preAnalysis() {
        Stopwatch sparkTimer = Stopwatch.newAndStart("Spark");
        this.prePTA.pureRun();
        sparkTimer.stop();
        System.out.println(sparkTimer);
        Stopwatch zipperTimer = Stopwatch.newAndStart("Zipper");
        Main.run(this.prePTA, this.PCMs);
        zipperTimer.stop();
        System.out.println(zipperTimer);
        this.extraStats();
    }

    protected void extraStats() {
        int[] RM = new int[1];
        int[] PCN = new int[1];
        int[] NPCN = new int[1];
        int[] totalN = new int[1];
        for (MethodOrMethodContext momc : this.prePTA.getReachableMethods()) {
            SootMethod method = momc.method();
            HashSet<Object> nodes = new HashSet<Object>();
            if (method.isPhantom()) {
                return;
            }
            MethodPAG srcmpag = this.pag.getMethodPAG(method);
            Object reader = srcmpag.getInternalReader().clone();
            while (((QueueReader)reader).hasNext()) {
                FieldRefNode fr;
                VarNode base;
                Node from = (Node)((QueueReader)reader).next();
                Node to = (Node)((QueueReader)reader).next();
                if (from instanceof LocalVarNode) {
                    nodes.add(((VarNode)from).getVariable());
                } else if (from instanceof AllocNode) {
                    nodes.add(((AllocNode)from).getNewExpr());
                } else if (from instanceof FieldRefNode && (base = (fr = (FieldRefNode)from).getBase()) instanceof LocalVarNode) {
                    nodes.add(base.getVariable());
                }
                if (to instanceof LocalVarNode) {
                    nodes.add(((VarNode)to).getVariable());
                    continue;
                }
                if (!(to instanceof FieldRefNode) || !((base = (fr = (FieldRefNode)to).getBase()) instanceof LocalVarNode)) continue;
                nodes.add(base.getVariable());
            }
            for (Unit u : srcmpag.getInvokeStmts()) {
                InstanceInvokeExpr iie;
                Value base;
                Value dest;
                Stmt s2 = (Stmt)u;
                InvokeExpr ie = s2.getInvokeExpr();
                int numArgs = ie.getArgCount();
                for (int i = 0; i < numArgs; ++i) {
                    Value arg = ie.getArg(i);
                    if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
                    nodes.add(arg);
                }
                if (s2 instanceof AssignStmt && (dest = ((AssignStmt)s2).getLeftOp()).getType() instanceof RefLikeType) {
                    nodes.add(dest);
                }
                if (!(ie instanceof InstanceInvokeExpr) || !((base = (iie = (InstanceInvokeExpr)ie).getBase()) instanceof Local)) continue;
                nodes.add(base);
            }
            if (this.PCMs.contains(method)) {
                PCN[0] = PCN[0] + nodes.size();
            } else {
                NPCN[0] = NPCN[0] + nodes.size();
            }
            RM[0] = RM[0] + 1;
            totalN[0] = totalN[0] + nodes.size();
        }
        RM[0] = RM[0] - 1;
        System.out.println("#ReachableMethod:" + RM[0]);
        System.out.println("#FCSM:" + this.PCMs.size());
        System.out.println("#PCSM:0");
        System.out.println("#CIM:" + (RM[0] - this.PCMs.size()));
        System.out.println("#CIN: " + NPCN[0]);
        System.out.println("#CSN: " + PCN[0]);
        System.out.println("totalN: " + totalN[0]);
    }
}

