/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.tools;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import qilin.core.pag.AllocNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.parm.ctxcons.CallsiteCtxConstructor;
import qilin.parm.heapabst.AllocSiteAbstractor;
import qilin.parm.heapabst.HeuristicAbstractor;
import qilin.parm.select.HeuristicSelector;
import qilin.parm.select.PartialVarSelector;
import qilin.parm.select.PipelineSelector;
import qilin.pta.PTAConfig;
import qilin.pta.tools.Spark;
import qilin.pta.tools.StagedPTA;
import qilin.util.PTAUtils;
import qilin.util.Stopwatch;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.RefLikeType;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.util.queue.QueueReader;

public abstract class PartialCallSiteSensPTA
extends StagedPTA {
    protected Set<Object> csnodes = new HashSet<Object>();
    protected Set<SootMethod> csmethods = new HashSet<SootMethod>();
    protected PAG prePAG;
    Set<SootMethod> PCSM = new HashSet<SootMethod>();
    Set<SootMethod> CSM = new HashSet<SootMethod>();

    public PartialCallSiteSensPTA(int ctxLen) {
        this.ctxCons = new CallsiteCtxConstructor();
        PartialVarSelector us = new PartialVarSelector(ctxLen, ctxLen - 1, this.csnodes, this.csmethods);
        this.ctxSel = PTAConfig.v().getPtaConfig().enforceEmptyCtxForIgnoreTypes ? new PipelineSelector(new HeuristicSelector(), us) : us;
        this.heapAbst = PTAConfig.v().getPtaConfig().mergeHeap ? new HeuristicAbstractor(this.pag) : new AllocSiteAbstractor();
        this.prePTA = new Spark();
        this.prePAG = this.prePTA.getPag();
    }

    @Override
    protected void preAnalysis() {
        Stopwatch sparkTimer = Stopwatch.newAndStart("Spark");
        this.prePTA.pureRun();
        sparkTimer.stop();
        System.out.println(sparkTimer);
        this.select();
        this.extraStats();
    }

    protected abstract Map<Object, Integer> calculatingNode2Length();

    protected void select() {
        Stopwatch preTimer = Stopwatch.newAndStart("pre-analysis");
        Map<Object, Integer> ret = this.calculatingNode2Length();
        ret.forEach((sparkNode, l) -> {
            if (l > 0) {
                this.csnodes.add(PTAUtils.getIR(sparkNode));
            }
            SootMethod method = null;
            if (sparkNode instanceof LocalVarNode) {
                method = ((LocalVarNode)sparkNode).getMethod();
            } else if (sparkNode instanceof AllocNode) {
                AllocNode allocNode = (AllocNode)sparkNode;
                method = allocNode.getMethod();
            }
            if (method != null) {
                if (l == 0) {
                    this.PCSM.add(method);
                } else {
                    this.CSM.add(method);
                }
            }
        });
        this.PCSM.retainAll(this.CSM);
        this.CSM.removeAll(this.PCSM);
        this.csmethods.addAll(this.CSM);
        this.csmethods.addAll(this.PCSM);
        System.out.println("#CSNODES:" + this.csnodes.size());
        System.out.println("#CSMETHODS:" + this.csmethods.size());
        preTimer.stop();
        System.out.println(preTimer);
    }

    protected void extraStats() {
        int[] RM = new int[1];
        int[] PCN = new int[1];
        int[] NPCN = new int[1];
        int[] totalN = new int[1];
        for (MethodOrMethodContext momc : this.prePTA.getReachableMethods()) {
            SootMethod method = momc.method();
            HashSet<Object> nodes = new HashSet<Object>();
            if (method.isPhantom()) {
                return;
            }
            MethodPAG srcmpag = this.pag.getMethodPAG(method);
            Object reader = srcmpag.getInternalReader().clone();
            while (((QueueReader)reader).hasNext()) {
                FieldRefNode fr;
                VarNode base;
                Node from = (Node)((QueueReader)reader).next();
                Node node = (Node)((QueueReader)reader).next();
                if (from instanceof LocalVarNode) {
                    nodes.add(((VarNode)from).getVariable());
                } else if (from instanceof AllocNode) {
                    nodes.add(((AllocNode)from).getNewExpr());
                } else if (from instanceof FieldRefNode && (base = (fr = (FieldRefNode)from).getBase()) instanceof LocalVarNode) {
                    nodes.add(base.getVariable());
                }
                if (node instanceof LocalVarNode) {
                    nodes.add(((VarNode)node).getVariable());
                    continue;
                }
                if (!(node instanceof FieldRefNode) || !((base = (fr = (FieldRefNode)node).getBase()) instanceof LocalVarNode)) continue;
                nodes.add(base.getVariable());
            }
            for (Unit unit : srcmpag.getInvokeStmts()) {
                InstanceInvokeExpr iie;
                Value base;
                Value dest;
                Stmt s2 = (Stmt)unit;
                InvokeExpr ie = s2.getInvokeExpr();
                int numArgs = ie.getArgCount();
                for (int i = 0; i < numArgs; ++i) {
                    Value arg = ie.getArg(i);
                    if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
                    nodes.add(arg);
                }
                if (s2 instanceof AssignStmt && (dest = ((AssignStmt)s2).getLeftOp()).getType() instanceof RefLikeType) {
                    nodes.add(dest);
                }
                if (!(ie instanceof InstanceInvokeExpr) || !((base = (iie = (InstanceInvokeExpr)ie).getBase()) instanceof Local)) continue;
                nodes.add(base);
            }
            for (Unit unit : nodes) {
                boolean index = false;
                if (this.csnodes.contains(unit)) {
                    index = true;
                }
                if (index) {
                    PCN[0] = PCN[0] + 1;
                } else {
                    NPCN[0] = NPCN[0] + 1;
                }
                totalN[0] = totalN[0] + 1;
            }
            RM[0] = RM[0] + 1;
        }
        RM[0] = RM[0] - 1;
        System.out.println("#ReachableMethod:" + RM[0]);
        System.out.println("#FCSM:" + this.CSM.size());
        System.out.println("#PCSM:" + this.PCSM.size());
        System.out.println("#CIM:" + (RM[0] - this.PCSM.size() - this.CSM.size()));
        System.out.println("#CIN: " + NPCN[0]);
        System.out.println("#CSN: " + PCN[0]);
        System.out.println("totalN: " + totalN[0]);
    }
}

