/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.tools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import qilin.core.pag.PAG;
import qilin.parm.ctxcons.CtxConstructor;
import qilin.parm.heapabst.MahjongAbstractor;
import qilin.parm.select.DebloatingSelector;
import qilin.parm.select.PipelineSelector;
import qilin.parm.select.UniformSelector;
import qilin.pta.PTAConfig;
import qilin.pta.toolkits.mahjong.Mahjong;
import qilin.pta.tools.Spark;
import qilin.pta.tools.StagedPTA;

public class MahjongPTA
extends StagedPTA {
    protected final Map<Object, Object> heapModelMap = new HashMap<Object, Object>();
    public Set<Object> mergedHeap = new HashSet<Object>();
    public Set<Object> csHeap = new HashSet<Object>();

    public MahjongPTA(int k, int hk, CtxConstructor ctxCons) {
        this.ctxCons = ctxCons;
        UniformSelector us = new UniformSelector(k, hk);
        DebloatingSelector ds = new DebloatingSelector(this.csHeap);
        this.ctxSel = new PipelineSelector(us, ds);
        this.heapAbst = new MahjongAbstractor(this.pag, this.mergedHeap, this.heapModelMap);
        this.prePTA = new Spark();
        System.out.println("Mahjong ...");
    }

    @Override
    protected void preAnalysis() {
        PTAConfig.v().getPtaConfig().mergeHeap = false;
        this.prePTA.pureRun();
        Mahjong.run(this.prePTA, this.heapModelMap);
        PAG prePAG = this.prePTA.getPag();
        this.heapModelMap.forEach((origin, merged) -> {
            if (prePAG.findAllocNode(origin) == null || prePAG.findAllocNode(merged) == null) {
                return;
            }
            if (prePAG.findAllocNode(origin).getType() != prePAG.findAllocNode(merged).getType()) {
                return;
            }
            if (!this.csHeap.add(merged)) {
                this.mergedHeap.add(merged);
            }
        });
        this.csHeap.removeAll(this.mergedHeap);
        System.out.println("#MERGE HEAP (not-single):" + this.mergedHeap.size());
        System.out.println("#NON-MERGED HEAP (single):" + this.csHeap.size());
    }
}

