/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.tools;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Map;
import qilin.core.pag.AllocNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.Parm;
import qilin.pta.toolkits.eagle.Eagle;
import qilin.pta.tools.PartialObjSensPTA;
import qilin.util.Pair;
import qilin.util.Stopwatch;
import soot.Local;
import soot.jimple.Expr;
import soot.jimple.NewArrayExpr;
import soot.jimple.Stmt;

public class EaglePTA
extends PartialObjSensPTA {
    public EaglePTA(int ctxLen) {
        super(ctxLen);
        System.out.println("Eagle ....");
    }

    @Override
    protected Map<Object, Integer> calculatingNode2Length() {
        Stopwatch timer = Stopwatch.newAndStart("TransGraph Construction");
        Eagle eagle = new Eagle();
        eagle.buildGraph(this.prePTA);
        timer.stop();
        System.out.println(timer);
        Stopwatch eagleTimer = Stopwatch.newAndStart("Eagle Selection");
        Map<Object, Integer> ret = eagle.contxtLengthAnalysis();
        eagleTimer.stop();
        System.out.println(eagleTimer);
        eagle.dumpCount();
        System.out.println("#Node:" + eagle.totalNodesCount());
        System.out.println("#Edge:" + eagle.totalEdgesCount());
        return ret;
    }

    protected void writeToFile(Map<Object, Integer> partialResults) throws FileNotFoundException {
        int EOL = 10;
        String insensVarFile = "InsensitiveVar.facts";
        String insensHeapFile = "InsensitiveHeap.facts";
        PrintWriter varWriter = new PrintWriter(insensVarFile);
        PrintWriter heapWriter = new PrintWriter(insensHeapFile);
        partialResults.forEach((k, v) -> {
            if (v > 0) {
                return;
            }
            if (k instanceof AllocNode) {
                AllocNode heap = (AllocNode)k;
                if (heap.getMethod() == null) {
                    return;
                }
                Object newExpr = heap.getNewExpr().toString();
                Object patt3233$temp = heap.getNewExpr();
                if (patt3233$temp instanceof NewArrayExpr) {
                    NewArrayExpr nae = (NewArrayExpr)patt3233$temp;
                    newExpr = "new " + nae.getBaseType().toString() + "[]";
                }
                String heapSig = heap.getMethod().toString() + "/" + (String)newExpr;
                heapWriter.write(heapSig);
                heapWriter.write(10);
            } else if (k instanceof LocalVarNode) {
                LocalVarNode lvn = (LocalVarNode)k;
                Object variable = lvn.getVariable();
                Object varName = variable.toString();
                if (variable instanceof Parm) {
                    Parm parm = (Parm)variable;
                    if (parm.isThis()) {
                        varName = "@this";
                    } else {
                        if (parm.isReturn()) {
                            return;
                        }
                        if (parm.isThrowRet()) {
                            return;
                        }
                        varName = "@parameter" + parm.getIndex();
                    }
                } else if (!(variable instanceof Local)) {
                    if (variable instanceof Stmt) {
                        return;
                    }
                    if (variable instanceof Expr) {
                        return;
                    }
                    if (variable instanceof Pair) {
                        return;
                    }
                    return;
                }
                String varSig = lvn.getMethod().toString() + "/" + (String)varName;
                varWriter.write(varSig);
                varWriter.write(10);
            }
        });
        varWriter.close();
        heapWriter.close();
    }
}

