/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.tools;

import qilin.CoreConfig;
import qilin.core.CorePTA;
import qilin.core.builder.CallGraphBuilder;
import qilin.core.pag.PAG;
import qilin.core.solver.Propagator;
import qilin.core.solver.Solver;
import qilin.stat.IEvaluator;
import qilin.stat.SimplifiedEvaluator;
import qilin.util.PTAUtils;

public abstract class BasePTA
extends CorePTA {
    protected IEvaluator evaluator = new SimplifiedEvaluator(this);

    public IEvaluator evaluator() {
        return this.evaluator;
    }

    @Override
    protected PAG createPAG() {
        return new PAG(this);
    }

    @Override
    protected CallGraphBuilder createCallGraphBuilder() {
        return new CallGraphBuilder(this);
    }

    @Override
    public Propagator getPropagator() {
        return new Solver(this);
    }

    @Override
    public void run() {
        this.evaluator.begin();
        this.pureRun();
        this.evaluator.end();
        this.dumpStats();
        System.out.println(this.evaluator());
    }

    protected void dumpStats() {
        if (CoreConfig.v().getOutConfig().dumppts) {
            PTAUtils.dumpPts(this, !CoreConfig.v().getOutConfig().dumplibpts);
        }
        if (CoreConfig.v().getOutConfig().dumpCallGraph) {
            PTAUtils.dumpCallGraph(this.getCallGraph(), false);
        }
        if (CoreConfig.v().getOutConfig().dumppag) {
            PTAUtils.dumpPAG(this.pag, "pag");
            PTAUtils.dumpNodeNames("nodeNames");
        }
    }
}

