/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.zipper;

import java.util.Set;
import qilin.core.PTA;
import qilin.pta.toolkits.zipper.Global;
import qilin.pta.toolkits.zipper.analysis.Zipper;
import qilin.util.Stopwatch;
import soot.SootMethod;

public class Main {
    public static void run(PTA pta, Set<SootMethod> zipperPCMOutput) {
        int numThreads = Runtime.getRuntime().availableProcessors();
        Global.setThread(numThreads);
        Global.setExpress(false);
        String zipperStr = Global.isExpress() ? "Zipper-e" : "Zipper";
        System.out.println("\u001b[1m\u001b[33m" + zipperStr + " starts ...\u001b[0m");
        String flows = Global.getFlow() != null ? Global.getFlow() : "Direct+Wrapped+Unwrapped";
        System.out.println("Precision loss patterns: \u001b[1m\u001b[32m" + flows + "\u001b[0m");
        Zipper.outputNumberOfClasses(pta);
        Stopwatch zipperTimer = Stopwatch.newAndStart("Zipper Timer");
        Zipper zipper = new Zipper(pta);
        Set<SootMethod> pcm = zipper.analyze();
        zipperTimer.stop();
        System.out.print("\u001b[1m\u001b[33m" + zipperStr + " finishes, analysis time: \u001b[0m");
        System.out.print("\u001b[1m\u001b[32m");
        System.out.printf("%.2fs", Float.valueOf(zipperTimer.elapsed()));
        System.out.println("\u001b[0m");
        System.out.println("Writing Zipper precision-critical methods ...\n");
        System.out.println();
        zipperPCMOutput.addAll(pcm);
    }
}

