/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.turner;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.PAG;
import qilin.core.pag.ValNode;
import qilin.pta.PTAConfig;
import qilin.pta.toolkits.turner.AbstractMVFG;
import qilin.pta.toolkits.turner.MethodLevelCallGraph;
import qilin.pta.toolkits.turner.MethodVFG;
import qilin.pta.toolkits.turner.ModularMVFG;
import qilin.pta.toolkits.turner.OCG;
import qilin.util.graph.MergedNode;
import qilin.util.graph.SCCMergedGraph;
import qilin.util.graph.TopologicalSorter;
import soot.SootMethod;
import soot.jimple.spark.pag.SparkField;

public class Turner {
    protected OCG ocg;
    private int total_node_count = 0;
    private int total_edge_count = 0;
    private final PTA prePTA;
    private final int k;
    private final int hk;
    public static boolean isModular = false;

    public Turner(int k, PTA pta) {
        this.k = k;
        this.hk = k - 1;
        this.prePTA = pta;
        if (isModular) {
            System.out.println("Turner with modularization ...");
        } else {
            System.out.println("Turner ...");
        }
    }

    public Map<Object, Integer> contxtLengthAnalysis() {
        this.ocg = new OCG(this.prePTA);
        this.ocg.run();
        this.mergeNodeAndEdgeCount(this.ocg.getTotalNodeCount(), this.ocg.getTotalEdgeCount());
        ConcurrentHashMap.KeySetView nodes = ConcurrentHashMap.newKeySet();
        Collection<SootMethod> reachables = this.prePTA.getNakedReachableMethods();
        if (isModular) {
            MethodLevelCallGraph mcg = new MethodLevelCallGraph(this.prePTA.getCallGraph());
            SCCMergedGraph<SootMethod> mg = new SCCMergedGraph<SootMethod>(mcg);
            this.mystat(mg);
            TopologicalSorter<SootMethod> topoSorter = new TopologicalSorter<SootMethod>();
            topoSorter.sort(mg, true).forEach(node -> {
                for (SootMethod method : node.getContent()) {
                    nodes.addAll(this.computeCtxLevelForVariables(method, (MergedNode<SootMethod>)node));
                }
            });
        } else {
            reachables.forEach(method -> nodes.addAll(this.computeCtxLevelForVariables((SootMethod)method)));
        }
        HashMap<Object, Integer> ret1 = new HashMap<Object, Integer>();
        reachables.forEach(method -> {
            AbstractMVFG mvfg = MethodVFG.findMethodVFG(method);
            if (mvfg != null) {
                for (Object obj : mvfg.getAllNodes()) {
                    if (nodes.contains(obj)) {
                        ret1.put(obj, obj instanceof AllocNode ? this.hk : this.k);
                        continue;
                    }
                    ret1.put(obj, 0);
                }
            }
        });
        PAG pag = this.prePTA.getPag();
        HashSet fields = new HashSet();
        HashSet readSet = new HashSet();
        HashSet writeSet = new HashSet();
        pag.getContextFields().forEach(contextField -> {
            SparkField field = contextField.getField();
            fields.add(field);
            if (!pag.simpleInvLookup((ValNode)contextField).isEmpty()) {
                writeSet.add(field);
            }
            if (!pag.simpleLookup((ValNode)contextField).isEmpty()) {
                readSet.add(field);
            }
        });
        for (SparkField f : fields) {
            int x = 0;
            ++this.total_node_count;
            if (writeSet.contains(f) && readSet.contains(f)) {
                x = this.k;
            }
            ret1.put(f, x);
        }
        HashMap<Object, Integer> ret = new HashMap<Object, Integer>(ret1);
        if (PTAConfig.v().turnerConfig == PTAConfig.TurnerConfig.PHASE_ONE) {
            HashMap ret2 = new HashMap();
            ret1.forEach((w, v) -> {
                if (w instanceof AllocNode) {
                    ret2.put(w, this.ocg.isCSLikely((AllocNode)w) ? this.hk : 0);
                } else {
                    ret2.put(w, this.k);
                }
            });
            ret = ret2;
        }
        System.out.println("#Node:" + this.total_node_count);
        System.out.println("#Edge:" + this.total_edge_count);
        this.statObjInOCG(ret);
        return ret;
    }

    private void statObjInOCG(Map<Object, Integer> ret) {
        int cibyocg = 0;
        int cibydfa = 0;
        int csobj = 0;
        int tops = 0;
        int bottoms = 0;
        int topandbottoms = 0;
        for (AllocNode o : this.prePTA.getPag().getAllocNodes()) {
            if (!this.ocg.isCSLikely(o)) {
                ++cibyocg;
            } else if (ret.containsKey(o) && ret.get(o) > 0) {
                ++csobj;
            } else {
                ++cibydfa;
            }
            if (this.ocg.isTop(o)) {
                ++tops;
            }
            if (this.ocg.isBottom(o)) {
                ++bottoms;
            }
            if (!this.ocg.isTop(o) || !this.ocg.isBottom(o)) continue;
            ++topandbottoms;
        }
        System.out.println("#CIByOCG:" + cibyocg);
        System.out.println("#CIByDFA:" + cibydfa);
        System.out.println("#CSOBJ:" + csobj);
        System.out.println("#CITOP:" + tops);
        System.out.println("#CIBOT:" + bottoms);
        System.out.println("#CITOPBOT:" + topandbottoms);
    }

    private Collection<Object> computeCtxLevelForVariables(SootMethod method) {
        if (method.isPhantom()) {
            return Collections.emptySet();
        }
        AbstractMVFG mvfg = MethodVFG.findOrCreateMethodVFG(this.prePTA, method, this.ocg);
        mvfg.computeNodesInPrecisionLossPatterns();
        this.mergeNodeAndEdgeCount(mvfg.getTotalNodeCount(), mvfg.getTotalEdgeCount());
        return mvfg.getCSNodes();
    }

    private Collection<Object> computeCtxLevelForVariables(SootMethod method, MergedNode<SootMethod> sccNode) {
        if (method.isPhantom()) {
            return Collections.emptySet();
        }
        AbstractMVFG mvfg = ModularMVFG.findOrCreateMethodVFG(this.prePTA, method, this.ocg, sccNode);
        mvfg.computeNodesInPrecisionLossPatterns();
        this.mergeNodeAndEdgeCount(mvfg.getTotalNodeCount(), mvfg.getTotalEdgeCount());
        return mvfg.getCSNodes();
    }

    private void mergeNodeAndEdgeCount(int nodeCnt, int edgeCnt) {
        this.total_node_count += nodeCnt;
        this.total_edge_count += edgeCnt;
    }

    private void mystat(SCCMergedGraph<SootMethod> scccg) {
        int sccCnt = scccg.allNodes().size();
        int sccCntGtW = 0;
        int maxScc = 0;
        double avgScc = 0.0;
        double avgSccGtW = 0.0;
        for (MergedNode<SootMethod> scc : scccg.allNodes()) {
            int n = scc.getContent().size();
            if (n > maxScc) {
                maxScc = n;
            }
            avgScc += (double)n;
            if (n <= 1) continue;
            ++sccCntGtW;
            avgSccGtW += (double)n;
        }
        avgScc /= (double)sccCnt;
        avgSccGtW /= (double)sccCntGtW;
        int[] dist = new int[maxScc + 1];
        for (MergedNode mergedNode : scccg.allNodes()) {
            int sccSize;
            int n = sccSize = mergedNode.getContent().size();
            dist[n] = dist[n] + 1;
        }
        System.out.println("#scc count:" + sccCnt);
        System.out.println("#scc count (exclude singleton):" + sccCntGtW);
        System.out.println("Average scc size:" + avgScc);
        System.out.println("Average scc size(exclude singleton):" + avgSccGtW);
        System.out.println("Maximum scc size:" + maxScc);
        System.out.println("Scc size distribution (size, count):");
        for (int i = 0; i <= maxScc; ++i) {
            if (dist[i] <= 0) continue;
            System.out.println(i + "," + dist[i]);
        }
    }
}

