/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.turner;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ConstantNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.core.sets.PointsToSet;
import qilin.pta.PTAConfig;
import qilin.util.PTAUtils;
import soot.ArrayType;
import soot.PrimType;
import soot.RefLikeType;
import soot.SootMethod;
import soot.Type;
import soot.jimple.spark.pag.SparkField;

public class OCG {
    public final PTA pta;
    protected final Map<LocalVarNode, Set<AllocNode>> pts;
    public Map<AllocNode, OCGNode> nodes;
    private int total_node_count = 0;
    private int total_edge_count = 0;

    public OCG(PTA pta) {
        this.pta = pta;
        this.pts = PTAUtils.calcStaticThisPTS(pta);
        this.nodes = new HashMap<AllocNode, OCGNode>();
        this.buildGraph();
    }

    protected void buildGraph() {
        PAG pag = this.pta.getPag();
        pag.getAllocNodes().forEach(this::findOrCreate);
        pag.getContextFields().forEach(contextField -> {
            AllocNode base = contextField.getBase();
            if (base instanceof ConstantNode) {
                return;
            }
            SparkField f = contextField.getField();
            Type patt2302$temp = f.getType();
            if (patt2302$temp instanceof ArrayType) {
                ArrayType at = (ArrayType)patt2302$temp;
                if (at.baseType instanceof PrimType) {
                    return;
                }
            }
            PointsToSet pts = this.pta.reachingObjects((Node)contextField).toCIPointsToSet();
            Iterator<AllocNode> it = pts.iterator();
            while (it.hasNext()) {
                AllocNode n = it.next();
                if (n instanceof ConstantNode) continue;
                this.addEdge(this.findOrCreate(base), this.findOrCreate(n));
            }
        });
    }

    public Collection<OCGNode> allNodes() {
        return this.nodes.values();
    }

    public int getTotalNodeCount() {
        return this.total_node_count;
    }

    public int getTotalEdgeCount() {
        return this.total_edge_count;
    }

    public void stat() {
        int case1 = 0;
        int total_factory = 0;
        int case1_factory = 0;
        int case1_normal = 0;
        int case2 = 0;
        int case2_noPred = 0;
        int case2_hasPred = 0;
        int otherCase = 0;
        for (OCGNode node : this.nodes.values()) {
            if (node.successors.size() == 0) {
                ++case2;
                if (node.predecessors.size() == 0) {
                    ++case2_noPred;
                } else {
                    ++case2_hasPred;
                }
                if (!this.isFactoryObject(node.ir)) continue;
                ++total_factory;
                continue;
            }
            if (node.predecessors.size() == 0) {
                ++case1;
                if (this.isFactoryObject(node.ir)) {
                    ++case1_factory;
                    continue;
                }
                ++case1_normal;
                continue;
            }
            if (this.isFactoryObject(node.ir)) {
                ++total_factory;
            }
            ++otherCase;
        }
        System.out.println("#case1:" + case1);
        System.out.println("#total_factory:" + total_factory);
        System.out.println("#case1_factory:" + case1_factory);
        System.out.println("#case1_normal:" + case1_normal);
        System.out.println("#case2:" + case2);
        System.out.println("#case2_noPred:" + case2_noPred);
        System.out.println("#case2_hasPred:" + case2_hasPred);
        System.out.println("#othercase:" + otherCase);
    }

    private OCGNode findOrCreate(AllocNode ir) {
        if (this.nodes.containsKey(ir)) {
            return this.nodes.get(ir);
        }
        ++this.total_node_count;
        OCGNode ret = new OCGNode(ir);
        this.nodes.put(ir, ret);
        return ret;
    }

    private boolean isNewTop(OCGNode node) {
        return node.predecessors.isEmpty() && !this.isFactoryObject(node.ir);
    }

    private boolean isNewBottom(OCGNode node) {
        return node.successors.isEmpty();
    }

    public boolean isTop(AllocNode heap) {
        return !this.nodes.containsKey(heap) || this.isNewTop(this.findOrCreate(heap));
    }

    public boolean isBottom(AllocNode heap) {
        return !this.nodes.containsKey(heap) || this.isNewBottom(this.findOrCreate(heap));
    }

    private boolean isNotTopAndBottom(OCGNode node) {
        return !this.isNewBottom(node) && !this.isNewTop(node);
    }

    public boolean isCSLikely(AllocNode allocNode) {
        OCGNode node = this.nodes.getOrDefault(allocNode, null);
        if (node == null) {
            return false;
        }
        return node.cslikely;
    }

    public void run() {
        int[] a = new int[2];
        System.out.println((Object)PTAConfig.v().turnerConfig);
        for (OCGNode node : this.nodes.values()) {
            PTAConfig.TurnerConfig hgConfig = PTAConfig.v().turnerConfig;
            node.cslikely = hgConfig == PTAConfig.TurnerConfig.PHASE_TWO ? true : this.isNotTopAndBottom(node);
            if (node.cslikely) {
                a[1] = a[1] + 1;
                continue;
            }
            a[0] = a[0] + 1;
        }
        for (int i = 0; i < 2; ++i) {
            System.out.println("#level " + i + ": " + a[i]);
        }
        this.stat();
    }

    protected void addEdge(OCGNode pre, OCGNode succ) {
        ++this.total_edge_count;
        pre.addSucc(succ);
        succ.addPred(pre);
    }

    boolean isFactoryObject(AllocNode heap) {
        SootMethod method = heap.getMethod();
        if (method == null) {
            return false;
        }
        Type retType = method.getReturnType();
        if (!(retType instanceof RefLikeType)) {
            return false;
        }
        if (retType instanceof ArrayType) {
            ArrayType at = (ArrayType)retType;
            if (at.baseType instanceof PrimType) {
                return false;
            }
        }
        MethodPAG methodPAG = this.pta.getPag().getMethodPAG(method);
        MethodNodeFactory factory = methodPAG.nodeFactory();
        VarNode retNode = factory.caseRet();
        PointsToSet pts = this.pta.reachingObjects(retNode).toCIPointsToSet();
        return pts.contains(heap);
    }

    public static class OCGNode {
        public final AllocNode ir;
        public Set<OCGNode> successors;
        public Set<OCGNode> predecessors;
        public boolean cslikely;

        public OCGNode(AllocNode ir) {
            this.ir = ir;
            this.cslikely = false;
            this.successors = new HashSet<OCGNode>();
            this.predecessors = new HashSet<OCGNode>();
        }

        public String toString() {
            return this.ir.toString();
        }

        public void addSucc(OCGNode node) {
            this.successors.add(node);
        }

        public void addPred(OCGNode node) {
            this.predecessors.add(node);
        }
    }
}

