/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.turner;

import java.util.Set;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.VarNode;
import qilin.pta.toolkits.turner.AbstractMVFG;
import qilin.pta.toolkits.turner.OCG;
import qilin.util.graph.MergedNode;
import soot.RefLikeType;
import soot.SootMethod;

public class ModularMVFG
extends AbstractMVFG {
    private final MergedNode<SootMethod> sccNode;

    public static AbstractMVFG findOrCreateMethodVFG(PTA prePTA, SootMethod method, OCG hg, MergedNode<SootMethod> sccNode) {
        return method2VFG.computeIfAbsent(method, k -> new ModularMVFG(prePTA, method, hg, sccNode));
    }

    public ModularMVFG(PTA prePTA, SootMethod method, OCG hg, MergedNode<SootMethod> sccNode) {
        super(prePTA, hg, method);
        this.sccNode = sccNode;
        this.buildVFG();
    }

    @Override
    protected boolean statisfyAddingLoadCondition(Set<SootMethod> targets) {
        for (SootMethod tgtmtd : targets) {
            if (tgtmtd.isPhantom() || this.sccNode.getContent().contains(tgtmtd)) {
                return true;
            }
            if (!(tgtmtd.getReturnType() instanceof RefLikeType)) continue;
            MethodPAG tgtmpag = this.prePTA.getPag().getMethodPAG(tgtmtd);
            AbstractMVFG tgtVfg = (AbstractMVFG)method2VFG.get(tgtmtd);
            assert (tgtVfg != null);
            MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
            VarNode ret = tgtnf.caseRet();
            if (!tgtVfg.getCSNodes().contains(ret)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean satisfyAddingStoreCondition(int paramIndex, Set<SootMethod> targets) {
        for (SootMethod tgtmtd : targets) {
            LocalVarNode parm;
            if (tgtmtd.isPhantom() || this.sccNode.getContent().contains(tgtmtd)) {
                return true;
            }
            MethodPAG tgtmpag = this.prePTA.getPag().getMethodPAG(tgtmtd);
            AbstractMVFG tgtVfg = (AbstractMVFG)method2VFG.get(tgtmtd);
            assert (tgtVfg != null);
            MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
            if (paramIndex == -1) {
                parm = (LocalVarNode)tgtnf.caseThis();
            } else {
                if (!(tgtmtd.getParameterType(paramIndex) instanceof RefLikeType)) continue;
                parm = (LocalVarNode)tgtnf.caseParm(paramIndex);
            }
            if (!tgtVfg.getCSNodes().contains(parm)) continue;
            return true;
        }
        return false;
    }
}

