/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.mahjong.automata;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import qilin.core.pag.AllocNode;
import qilin.pta.toolkits.mahjong.automata.DFA;
import soot.Type;
import soot.jimple.spark.pag.SparkField;

public class DFAState {
    private final Set<AllocNode> objs;
    private final Set<Type> output;
    private final Map<SparkField, DFAState> nextMap;
    private boolean hasHashCode = false;
    private int hashCode;

    public DFAState() {
        this.objs = Collections.emptySet();
        this.output = Collections.emptySet();
        this.nextMap = new HashMap<SparkField, DFAState>();
    }

    public DFAState(Set<AllocNode> objs, Set<Type> output) {
        this.objs = objs;
        this.output = output;
        this.nextMap = new HashMap<SparkField, DFAState>();
    }

    public Set<AllocNode> getObjects() {
        return this.objs;
    }

    public Set<Type> getOutput() {
        return this.output;
    }

    void addTransition(SparkField f, DFAState nextState) {
        this.nextMap.put(f, nextState);
    }

    Map<SparkField, DFAState> getNextMap() {
        return this.nextMap;
    }

    DFAState nextState(SparkField f) {
        return this.nextMap.getOrDefault(f, DFA.getDeadState());
    }

    Set<SparkField> outEdges() {
        return this.nextMap.keySet();
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            this.hashCode = this.objs.hashCode();
            this.hasHashCode = true;
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DFAState)) {
            return false;
        }
        DFAState anoDFAState = (DFAState)other;
        return this.getObjects().equals(anoDFAState.getObjects());
    }

    public String toString() {
        return this.getObjects().stream().map(obj -> obj == null ? "null" : String.valueOf(obj.getNumber())).sorted().collect(Collectors.toCollection(LinkedHashSet::new)).toString();
    }
}

