/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.mahjong.automata;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import qilin.pta.toolkits.mahjong.automata.DFAState;
import soot.Type;

public class DFA {
    private Set<DFAState> states;
    private Set<DFAState> allStates;
    private final DFAState q0;
    static final DFAState deadState = new DFAState();

    public DFA(DFAState q0) {
        this.q0 = q0;
    }

    public Set<DFAState> getStates() {
        if (this.states == null) {
            this.computeStates();
        }
        return this.states;
    }

    public Set<DFAState> getAllStates() {
        if (this.allStates == null) {
            this.computeStates();
        }
        return this.allStates;
    }

    private void computeStates() {
        LinkedList<DFAState> queue = new LinkedList<DFAState>();
        queue.add(this.q0);
        this.states = new HashSet<DFAState>();
        while (!queue.isEmpty()) {
            DFAState s2 = (DFAState)queue.poll();
            if (this.states.contains(s2)) continue;
            this.states.add(s2);
            queue.addAll(s2.getNextMap().values());
        }
        this.allStates = new HashSet<DFAState>(this.states);
        this.allStates.add(deadState);
    }

    public DFAState getStartState() {
        return this.q0;
    }

    public static DFAState getDeadState() {
        return deadState;
    }

    public Set<Type> outputOf(DFAState s2) {
        return s2.getOutput();
    }
}

