/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.eagle;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.Parm;
import qilin.core.pag.ValNode;
import qilin.core.sets.PointsToSet;
import qilin.pta.toolkits.eagle.BNode;
import qilin.util.PTAUtils;
import qilin.util.Util;
import qilin.util.queue.UniqueQueue;
import soot.RefLikeType;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.queue.QueueReader;

public class Eagle {
    protected Map<Object, Map<Boolean, BNode>> sparkNode2BNode = new HashMap<Object, Map<Boolean, BNode>>();
    public Set<BNode> allocs = new HashSet<BNode>();
    public Set<BNode> allocIs = new HashSet<BNode>();
    public Map<BNode, Set<BNode>> outEdges = new HashMap<BNode, Set<BNode>>();
    protected Map<BNode, Set<BNode>> balancedOutEdges = new HashMap<BNode, Set<BNode>>();
    private int new_count = 0;
    private int assign_count = 0;
    protected int store_count = 0;
    private int load_count = 0;
    private int balance_count = 0;
    private int hstore_count = 0;
    private int hload_count = 0;
    private int total_nodes_count = 0;
    private int total_edges_count = 0;

    public void dumpCount() {
        System.out.println("#NEW:" + this.new_count);
        System.out.println("#ASSIGN:" + this.assign_count);
        System.out.println("#STORE:" + this.store_count);
        System.out.println("#LOAD:" + this.load_count);
        System.out.println("#HSTORE:" + this.hstore_count);
        System.out.println("#HLOAD:" + this.hload_count);
        System.out.println("#BALANCE:" + this.balance_count);
    }

    public Collection<? extends BNode> getNodes() {
        return this.sparkNode2BNode.values().stream().flatMap(subMap -> subMap.values().stream()).collect(Collectors.toSet());
    }

    public Collection<Object> getSparkNodes() {
        return this.sparkNode2BNode.values().stream().flatMap(subMap -> subMap.values().stream()).map(gn -> gn.sparkNode).collect(Collectors.toSet());
    }

    public BNode getBNode(Object origin, Boolean forward) {
        Map subMap = this.sparkNode2BNode.computeIfAbsent(origin, k -> new HashMap());
        if (subMap.containsKey(forward)) {
            return (BNode)subMap.get(forward);
        }
        BNode ret = new BNode(origin, forward);
        subMap.put(forward, ret);
        ++this.total_nodes_count;
        return ret;
    }

    protected void addNormalEdge(BNode from, BNode to) {
        Set m4 = this.outEdges.computeIfAbsent(from, k -> new HashSet());
        m4.add(to);
        ++this.total_edges_count;
    }

    public boolean addBalancedEdge(BNode from, BNode to) {
        boolean ret = Util.addToMap(this.balancedOutEdges, from, to);
        ++this.balance_count;
        ++this.total_edges_count;
        return ret;
    }

    public void addNewEdge(AllocNode from, LocalVarNode to) {
        BNode fromE = this.getBNode(from, true);
        BNode toE = this.getBNode(to, true);
        this.addNormalEdge(fromE, toE);
        BNode toEI = this.getBNode(to, false);
        BNode fromEI = this.getBNode(from, false);
        this.addNormalEdge(toEI, fromEI);
        ++this.new_count;
        this.allocs.add(fromE);
        this.allocIs.add(fromEI);
    }

    public void addAssignEdge(LocalVarNode from, LocalVarNode to) {
        BNode fromE = this.getBNode(from, true);
        BNode toE = this.getBNode(to, true);
        this.addNormalEdge(fromE, toE);
        BNode toEI = this.getBNode(to, false);
        BNode fromEI = this.getBNode(from, false);
        this.addNormalEdge(toEI, fromEI);
        ++this.assign_count;
    }

    public void addStoreEdge(LocalVarNode from, LocalVarNode base) {
        BNode fromE = this.getBNode(from, true);
        BNode baseEI = this.getBNode(base, false);
        this.addNormalEdge(fromE, baseEI);
        BNode baseE = this.getBNode(base, true);
        BNode fromEI = this.getBNode(from, false);
        this.addNormalEdge(baseE, fromEI);
        ++this.store_count;
    }

    public void addLoadEdge(LocalVarNode base, LocalVarNode to) {
        BNode baseE = this.getBNode(base, true);
        BNode toE = this.getBNode(to, true);
        this.addNormalEdge(baseE, toE);
        BNode toEI = this.getBNode(to, false);
        BNode baseEI = this.getBNode(base, false);
        this.addNormalEdge(toEI, baseEI);
        ++this.load_count;
    }

    public void addHstoreEdge(Object from, AllocNode baseObj) {
        BNode fromE = this.getBNode(from, true);
        BNode baseObjE = this.getBNode(baseObj, true);
        this.addNormalEdge(fromE, baseObjE);
        BNode baseObjEI = this.getBNode(baseObj, false);
        BNode fromEI = this.getBNode(from, false);
        this.addNormalEdge(baseObjEI, fromEI);
        this.allocIs.add(baseObjEI);
        this.allocs.add(baseObjE);
        ++this.hstore_count;
    }

    public void addHloadEdge(AllocNode baseObj, Object to) {
        BNode baseObjEI = this.getBNode(baseObj, false);
        BNode toE = this.getBNode(to, true);
        this.addNormalEdge(baseObjEI, toE);
        BNode toEI = this.getBNode(to, false);
        BNode baseObjE = this.getBNode(baseObj, true);
        this.addNormalEdge(toEI, baseObjE);
        this.allocIs.add(baseObjEI);
        this.allocs.add(baseObjE);
        ++this.hload_count;
    }

    public int totalEdgesCount() {
        return this.total_edges_count;
    }

    public int totalNodesCount() {
        return this.total_nodes_count;
    }

    public Set<BNode> getAllOutEdges(BNode node) {
        HashSet<BNode> ret = new HashSet<BNode>(this.getOutEdges(node));
        if (this.balancedOutEdges.containsKey(node)) {
            ret.addAll((Collection<BNode>)this.balancedOutEdges.get(node));
        }
        return ret;
    }

    public Collection<BNode> getOutEdges(BNode node) {
        return this.outEdges.getOrDefault(node, Collections.emptySet());
    }

    public boolean reachValidReceiverObject(BNode from, BNode to) {
        BNode fromEI = this.getBNode(to.sparkNode, false);
        if (from.sparkNode instanceof SparkField) {
            return this.getOutEdges(fromEI).contains(from);
        }
        return true;
    }

    protected boolean enterCS(BNode node) {
        return node.entryCS();
    }

    public Map<Object, Integer> contxtLengthAnalysis() {
        UniqueQueue<BNode> workList = new UniqueQueue<BNode>();
        HashSet<Object> matchedObjects = new HashSet<Object>();
        for (BNode heapNode : this.allocIs) {
            for (BNode dst : this.getOutEdges(heapNode)) {
                dst.cs = true;
                workList.add(dst);
            }
        }
        while (!workList.isEmpty()) {
            BNode node = (BNode)workList.poll();
            for (BNode dst : this.getAllOutEdges(node)) {
                if (dst.isHeapPlus() && !node.isHeapMinus()) {
                    if (!this.reachValidReceiverObject(node, dst) || !matchedObjects.add(dst.sparkNode)) continue;
                    BNode fromEI = this.getBNode(dst.sparkNode, false);
                    this.addBalancedEdge(fromEI, dst, workList);
                    continue;
                }
                if (!this.enterCS(dst)) continue;
                workList.add(dst);
            }
        }
        HashMap<Object, Integer> ret = new HashMap<Object, Integer>();
        this.getSparkNodes().forEach(sparkNode -> {
            BNode node = this.getBNode(sparkNode, true);
            BNode nodeInv = this.getBNode(sparkNode, false);
            ret.put(sparkNode, node.cs != false && nodeInv.cs != false ? 1 : 0);
        });
        return ret;
    }

    protected void addBalancedEdge(BNode from, BNode to, Queue<BNode> workList) {
        if (this.addBalancedEdge(from, to) && from.cs.booleanValue()) {
            workList.add(from);
        }
    }

    protected void addParamEdges(AllocNode o, LocalVarNode thisRef, LocalVarNode[] parms, LocalVarNode mret, LocalVarNode mThrow) {
        this.addHloadEdge(o, thisRef);
        for (LocalVarNode parm : parms) {
            if (parm == null) continue;
            this.addHloadEdge(o, parm);
        }
        if (mret != null) {
            this.addHstoreEdge(mret, o);
        }
        if (mThrow != null) {
            this.addHstoreEdge(mThrow, o);
        }
    }

    public void buildGraph(PTA prePTA) {
        PAG prePAG = prePTA.getPag();
        Map<LocalVarNode, Set<AllocNode>> pts = PTAUtils.calcStaticThisPTS(prePTA);
        CallGraph callGraph = prePTA.getCallGraph();
        for (SootMethod method : prePTA.getNakedReachableMethods()) {
            if (method.isPhantom()) continue;
            MethodPAG srcmpag = prePAG.getMethodPAG(method);
            MethodNodeFactory srcnf = srcmpag.nodeFactory();
            LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
            if (PTAUtils.isFakeMainMethod(method)) {
                this.addNewEdge(prePTA.getRootNode(), thisRef);
            }
            Object reader = srcmpag.getInternalReader().clone();
            while (((QueueReader)reader).hasNext()) {
                Node from = (Node)((QueueReader)reader).next();
                Node to = (Node)((QueueReader)reader).next();
                if (from instanceof LocalVarNode) {
                    if (to instanceof LocalVarNode) {
                        this.addAssignEdge((LocalVarNode)from, (LocalVarNode)to);
                        continue;
                    }
                    if (!(to instanceof FieldRefNode)) continue;
                    FieldRefNode fr = (FieldRefNode)to;
                    this.addStoreEdge((LocalVarNode)from, (LocalVarNode)fr.getBase());
                    continue;
                }
                if (from instanceof AllocNode) {
                    if (!(to instanceof LocalVarNode)) continue;
                    this.addNewEdge((AllocNode)from, (LocalVarNode)to);
                    continue;
                }
                if (!(from instanceof FieldRefNode)) continue;
                FieldRefNode fr = (FieldRefNode)from;
                this.addLoadEdge((LocalVarNode)fr.getBase(), (LocalVarNode)to);
            }
            srcmpag.getExceptionEdges().forEach((k, vs) -> {
                for (Node v : vs) {
                    this.addAssignEdge((LocalVarNode)k, (LocalVarNode)v);
                }
            });
            int numParms = method.getParameterCount();
            LocalVarNode[] parms = new LocalVarNode[numParms];
            for (int i = 0; i < numParms; ++i) {
                if (!(method.getParameterType(i) instanceof RefLikeType)) continue;
                parms[i] = (LocalVarNode)srcnf.caseParm(i);
            }
            LocalVarNode mret = method.getReturnType() instanceof RefLikeType ? (LocalVarNode)srcnf.caseRet() : null;
            LocalVarNode throwFinal = prePAG.findLocalVarNode(new Parm(method, -3));
            if (method.isStatic()) {
                pts.getOrDefault(thisRef, Collections.emptySet()).forEach(a -> this.addParamEdges((AllocNode)a, thisRef, parms, mret, throwFinal));
            } else {
                PointsToSet thisPts = prePTA.reachingObjects(thisRef).toCIPointsToSet();
                Iterator<AllocNode> it = thisPts.iterator();
                while (it.hasNext()) {
                    AllocNode n = it.next();
                    this.addParamEdges(n, thisRef, parms, mret, throwFinal);
                }
            }
            for (Unit u : srcmpag.getInvokeStmts()) {
                LocalVarNode receiver;
                Value dest;
                Stmt s2 = (Stmt)u;
                InvokeExpr ie = s2.getInvokeExpr();
                int numArgs = ie.getArgCount();
                Value[] args = new Value[numArgs];
                for (int i = 0; i < numArgs; ++i) {
                    Value arg = ie.getArg(i);
                    if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
                    args[i] = arg;
                }
                LocalVarNode retDest = null;
                if (s2 instanceof AssignStmt && (dest = ((AssignStmt)s2).getLeftOp()).getType() instanceof RefLikeType) {
                    retDest = prePAG.findLocalVarNode(dest);
                }
                if (ie instanceof InstanceInvokeExpr) {
                    InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                    receiver = prePAG.findLocalVarNode(iie.getBase());
                } else {
                    receiver = thisRef;
                }
                Iterator<Edge> it = callGraph.edgesOutOf(u);
                while (it.hasNext()) {
                    Edge e = it.next();
                    SootMethod tgtmtd = e.tgt();
                    for (int i = 0; i < numArgs; ++i) {
                        ValNode argNode;
                        if (args[i] == null || !(tgtmtd.getParameterType(i) instanceof RefLikeType) || !((argNode = prePAG.findValNode(args[i])) instanceof LocalVarNode)) continue;
                        this.addStoreEdge((LocalVarNode)argNode, receiver);
                    }
                    if (retDest != null && tgtmtd.getReturnType() instanceof RefLikeType) {
                        this.addLoadEdge(receiver, retDest);
                    }
                    LocalVarNode stmtThrowNode = srcnf.makeInvokeStmtThrowVarNode(s2, method);
                    this.addLoadEdge(receiver, stmtThrowNode);
                    this.addStoreEdge(receiver, receiver);
                }
            }
        }
        prePAG.getContextFields().forEach(contextField -> {
            AllocNode base = contextField.getBase();
            SparkField field = contextField.getField();
            if (!prePAG.simpleInvLookup((ValNode)contextField).isEmpty()) {
                this.addHloadEdge(base, field);
            }
            if (!prePAG.simpleLookup((ValNode)contextField).isEmpty()) {
                this.addHstoreEdge(field, base);
            }
        });
    }
}

